#version 120
#extension GL_ARB_shader_texture_lod : enable

//***************************ADJUSTABLE VARIABLES***************************//
//***************************ADJUSTABLE VARIABLES***************************//
//***************************ADJUSTABLE VARIABLES***************************//

//***************************GODRAYS***************************//

//#define GODRAYS
	const float exposure = 0.25;
	const float density = 1;
	const int NUM_SAMPLES = 5;			//increase this for better quality at the cost of performance
	const float grnoise = 0.0;		//amount of noise /0.0 is default

//***************************REFLECTIONS***************************//

#define REFLECTIONS
	#define WATER_REFLECTIONS
	#define REFLECTION_STRENGTH 0.625 //[0.125 0.25 0.375 0.5 0.625 0.75 0.875 1.0] //Strength
	#define RAIN_REFLECTIONS
	#define SPECULAR_REFLECTIONS

//***************************VISUALS***************************//

#define WATER_REFRACT
	#define REFRACT_MULT 7.0

#define WATER_CAUSTIC
	#define CAUSTIC_STRENGHT 1.0

//#define MOTIONBLUR
	#define MOTIONBLUR_AMOUNT 1.0
	//#define HQ_MOTIONBLUR			//High quality motionblur only enable one!
	#define LQ_MOTIONBLUR			//Low quality motionblur only enable one!

#define FOG

//***************************CLOUDS***************************//

#define Clouds
	//#define NORMALMAP_CLOUD_EFFECT
	#define NORMAL_QUALITY 1	//No decimals!
	#define NORMAL_SIZE 1.0

//***************************VISUALS***************************//

#define Stars

#define COLOR_CORRECTION

//***************************VOLUMETRIC LIGHT***************************//
//#define VOLUMETRIC_LIGHT
	#define VL_MULT 					1.0				// Simple multiplier
	#define VL_STRENGTH_DAY 			1.0		 		// Strength of day time
	#define VL_STRENGTH_NIGHT 			1.0			    // Strength of night time
	#define VL_STRENGTH_SUNSET_SUNRISE 	1.0			    // Strength of sunset and sunrise time
	#define VL_STRENGTH_INSIDE 			1.0				// Strength inside buildings

//***************************END OF ADJUSTABLE VARIABLES***************************//
//***************************END OF ADJUSTABLE VARIABLES***************************//
//***************************END OF ADJUSTABLE VARIABLES***************************//

const bool 		gcolorMipmapEnabled 	= true; //gcolor texture mipmapping

//don't touch these lines if you don't know what you do!
const int maxf = 3;				//number of refinements
const float stp = 1.0;			//size of one step for raytracing algorithm
const float ref = 0.05;			//refinement multiplier
const float inc = 2.2;			//increasement factor at each step

varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 lightVector;
varying vec3 ambient_color;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;
varying vec3 cloudColor;
varying float SdotU;
varying float MdotU;
varying float moonVisibility;

uniform sampler2D composite;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux3;
uniform sampler2D gcolor;
//uniform sampler2D gdepth;
uniform sampler2D gnormal;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D noisetex;
//uniform sampler2DShadow shadowcolor1;

uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

uniform vec3 sunPosition;
uniform vec3 cameraPosition;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferPreviousModelView;

uniform vec3 previousCameraPosition;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;
uniform float far;
uniform float near;
uniform vec3 upPosition;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;

float timefract = worldTime;

float comp = 1.0-near/far/far;			//distance above that are considered as sky

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float transition_fading = 1.0-(clamp((timefract-12000.0)/300.0,0.0,1.0)-clamp((timefract-13000.0)/300.0,0.0,1.0) + clamp((timefract-22800.0)/200.0,0.0,1.0)-clamp((timefract-23400.0)/200.0,0.0,1.0));

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;


vec4 aux = texture2D(gaux1, texcoord.st);
vec4 aux2 = texture2D(gaux2, texcoord.st);
float matflag = texture2D(gaux1,texcoord.xy).g;

vec3 fogclr = 0.2*ambient_color;
vec3 fogclr2 = fogclr;
vec3 fogclr3 = fogclr;
vec3 fogclr4 = fogclr;

vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
float pixeldepth = texture2D(depthtex0,texcoord.xy).x;
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;

float sky_lightmap = texture2D(gaux1,texcoord.xy).r;
float reflectionSkyLight = clamp(pow(sky_lightmap, 5.0), 0.0, 1.0);

float iswet = wetness*pow(sky_lightmap,10.0);

int iswater = int(matflag > 0.04 && matflag < 0.07);

vec3 specular = pow(texture2D(gaux3,texcoord.xy).rgb,vec3(2.2));
float specmap = float(aux.a > 0.7 && aux.a < 0.72) + (specular.r+specular.g*(iswet));
vec3 color = texture2D(composite,texcoord.xy,0).rgb;

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord) {
	return max(abs(coord.x-0.5),abs(coord.y-0.5))*2.0;
}

float ld(float dist) {
    return (2.0 * near) / (far + near - dist * (far - near));
}

float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float getSpec(vec2 pos) {
	return texture2D(composite, pos.st).a;
}

float convertVec3ToFloat(in vec3 invec){

	float mixing;
		mixing += invec.x;
		mixing += invec.y;
		mixing += invec.z;
		mixing /= 3.0;

	return mixing;
}


// dirived from: http://devlog-martinsh.blogspot.nl/2011/03/glsl-8x8-bayer-matrix-dithering.html
float find_closest(vec2 pos, float sample)
{

		float dither[64] = float[64](
		0, 32, 8, 40, 2, 34, 10, 42, /* 8x8 Bayer ordered dithering */
		48, 16, 56, 24, 50, 18, 58, 26, /* pattern. Each input pixel */
		12, 44, 4, 36, 14, 46, 6, 38, /* is scaled to the 0..63 range */
		60, 28, 52, 20, 62, 30, 54, 22, /* before looking in this table */
		3, 35, 11, 43, 1, 33, 9, 41, /* to determine the action. */
		51, 19, 59, 27, 49, 17, 57, 25,
		15, 47, 7, 39, 13, 45, 5, 37,
		63, 31, 55, 23, 61, 29, 53, 21);

	vec2 texMod = pos;
	vec2 aspectCorrect = vec2(viewWidth, viewHeight);
	texMod = mod(texMod * aspectCorrect, sqrt(64));
	float limit;

	for (int i; i < (int(texMod.x) + int(texMod.y)*sqrt(64)); i++) {
			limit = (dither[i])/sqrt(64 * 64);
	}
	return limit * sample;
}

float subSurfaceScattering2(vec3 vec,vec3 pos, float N) {

return pow(max(dot(vec,normalize(pos))*0.5+0.5,0.0),N)*(N+1)/6.28;

}

#ifdef Clouds

vec3 drawCloud(vec3 fposition,vec3 color, float mult) {
	if (isEyeInWater > .9) {
		} else {
			//vec4 noiseWeights = 1.0/vec4(1.0,3.5,12.25,42.87)/1.4472;
			const float r = 4.0;
			const vec4 noiseC = vec4(1.0,r,r*r,r*r*r);
			const vec4 noiseWeights = 1.0/vec4(1.0,r,r*r,r*r*r)/dot(1.0/vec4(1.0,r,r*r,r*r*r),vec4(1.0));
			/*--------------------------------*/
			vec3 sVector = normalize(fposition);
			float cosT = max(dot(normalize(sVector),upVec),0.0);
			vec3 tpos = vec3(gbufferModelViewInverse * vec4(sVector,0.0));
			vec3 wvec = normalize(tpos);
			vec3 wVector = normalize(tpos);

			vec3 cloudCol = pow(sunlight * 2.4,vec3(3.4))*(TimeSunrise+TimeSunset);
				cloudCol += (cloudColor * 2.0)*(TimeNoon);
				cloudCol += (moonlight * 100.0)*(TimeMidnight);
				cloudCol +=	pow(sunlight * 1.5,vec3(3.0)) * (1-transition_fading);
			vec3 cloudCol2 = cloudCol;

			float totalcloud = 0.0;

			float height = (700.0)/(wVector.y);
			vec2 wind = vec2(1+frameTimeCounter, 8+frameTimeCounter)/20000;

			vec3 intersection;
			float density;
			float d1;

			int Steps = 1;
			float weight;

			#ifdef NORMALMAP_CLOUD_EFFECT
			Steps += 1 * NORMAL_QUALITY;
			#endif

			for (int i = 0; i < Steps; i++) {
				intersection = wVector * (height - i * 10.0 * NORMAL_SIZE / Steps); 			//curved cloud plane

				vec2 coord1 = (intersection.xz+cameraPosition.xz)/200000+(wind);
				vec2 coord = (coord1/2.0);
				/*--------------------------------*/
				vec4 noiseSample = vec4(texture2D(noisetex,coord - (wind / 3.0 )).x,texture2D(noisetex,coord*noiseC.y).x,texture2D(noisetex,coord*noiseC.z).x,texture2D(noisetex,coord*noiseC.w).x);

				float noise = dot(noiseSample,noiseWeights);
				/*--------------------------------*/
				float cl = max(noise,0.0);
				cl = pow(cl, 0.7);
				d1 = max(1.0-cl*(2.0-rainx) ,0.0);
				density = d1*d1*(2.0)/(19.0);

				totalcloud += density;
				weight += 1;

		}

		cloudCol = mix(cloudCol*pow(1-d1, 2.0),vec3(cloudCol*0.125),pow(d1, 2.0)) * 2.0;

			cloudCol += pow(sunlight * mix(3.0,2.5,TimeSunset + TimeSunrise),vec3(mix(3.0 - (1.0 * (1.0 - transition_fading)),1.0,TimeNoon))) * (50*(pow(1-d1, 18.0))) * mix(1.0,0.25,1.0 - transition_fading) * 1.5 * (1-(TimeMidnight * transition_fading)) * (1-rainx);
			cloudCol += moonlight * (50*(pow(1-d1, 14.0))) * 200 * transition_fading * (1-rainx);

			cloudCol += pow(sunlight * mix(2.0,5.0,TimeSunset + TimeSunrise),vec3(mix(3.0,1.0,TimeNoon))) * (50*subSurfaceScattering2(sunVec,fposition,30.0)*(pow(1-d1, 18.0))) * 4 * (1-(TimeMidnight * transition_fading));
			cloudCol += moonlight * (500*subSurfaceScattering2(moonVec,fposition,30.0)*(pow(1-d1, 16.0))) * 50 * mix(1.0,0.25,1.0 - transition_fading);

		cloudCol = mix(cloudCol, cloudColor, rainx);
		/*--------------------------------*/

			totalcloud = min(totalcloud,1.0) / weight;
			return mix(color.rgb,cloudCol * mult,totalcloud*2.0*pow(cosT,1.75));


		}
	}
#endif

#ifdef Stars
	vec3 drawStar(vec3 fposition,vec3 color) {
		float volumetric_cone = pow(max(dot(normalize(fposition),moonVec),0.0),200.0);
		vec3 sVector = normalize(fposition);
		float cosT = dot(sVector,upVec);
		//star generation
		/*----------*/
		vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
		vec3 wVector = normalize(tpos);
		vec3 intersection = wVector*(50.0/(wVector.y));
			vec2 coord = (intersection.xz)/256.0;
			float noise = texture2D(noisetex,fract(coord.xy/2.0)).x;
		vec3 sum = vec3(1.0, 1.0, 1.0)*(1-rainx) * (1-volumetric_cone);
		/*----------*/
			noise += texture2D(noisetex,fract(coord.xy)).x/2.0;
			float star = max(noise-1.3,0.0);
				  star = star * 5 * max(cosT,0.0) * TimeMidnight * (1-rainx);
		vec3 s = mix(color,sum,star);
		return s;
	}
#endif

float getRainPuddles(vec3 fposition){


	vec3 pPos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
	pPos = nvec3(gbufferProjectionInverse * nvec4(pPos * 2.0 - 1.0));
	vec4 pUw = gbufferModelViewInverse * vec4(pPos,1.0);
	vec3 worldPos = (pUw.xyz + cameraPosition.xyz);

	vec2 coord = (worldPos.xz/10000);

	float rainPuddles = texture2D(noisetex, fract(coord.xy*8)).x;
	rainPuddles += texture2D(noisetex, fract(coord.xy*4)).x;
	rainPuddles += texture2D(noisetex, fract(coord.xy*2)).x;
	rainPuddles += texture2D(noisetex, fract(coord.xy/2)).x;

	float strength = max(rainPuddles-1.9,0.0);
	float dL = 0.5;
	float L = (1.0 - (pow(dL,strength)));

	return L;
}

float getnoise(vec2 pos) {
	return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));
}



#ifdef VOLUMETRIC_LIGHT
	vec3 vlColor(vec3 fogcolor,in vec3 color) {

		float VolumeSample = texture2D(gcolor, texcoord.xy, 3.2).g;

		float iN = (VL_STRENGTH_NIGHT*moonVisibility);
		float iD = (VL_STRENGTH_DAY*TimeNoon);
		float iSSSR = (VL_STRENGTH_SUNSET_SUNRISE*(1-TimeNoon)*(1-moonVisibility));

		float i = (iN + iD + iSSSR);

		float eBS = mix(1.0,0.0,(pow(eyeBrightnessSmooth.y / 240.0f, 1.0f)));

		float Glow = pow(max(dot(normalize(fragpos),lightVector),0.0),2.5*15);
		float vlGlow = (1-Glow*-(2.5*(1-TimeNoon*-5)*(1-(TimeSunrise + TimeSunset)*-5.)*(1-eBS))) * 0.5;

		float Atmosphere = 1-(pow(max(dot(normalize(fragpos),lightVector),0.0),1.5));
		Atmosphere *= 1-(pow(max(dot(normalize(fragpos),-lightVector),0.0),5.0))*(1-TimeSunrise)*(1-TimeSunset)*(1-moonVisibility);

		vec3 atmosphere = ((fogcolor*(sqrt(sunlight*sunlight)))+sunlight*0.05)*2*(Atmosphere)*(1-eBS*0.5)*(i)*(1-moonVisibility);

		float vlInside = ((eBS*30.0*VL_STRENGTH_INSIDE*(1-moonVisibility)));
		float vlInsideNight = ((eBS*30.0*VL_STRENGTH_INSIDE*(moonVisibility)));
		float vlFinalInside = (vlInside + vlInsideNight);

		vec3 vlDay = vec3(sunlight) * VL_STRENGTH_DAY * TimeNoon;
		vec3 vlNight = vec3(moonlight) * 20 * (VL_STRENGTH_NIGHT * moonVisibility);
		vec3 vlSSSR = vec3(sunlight) * 2.0 * (VL_STRENGTH_SUNSET_SUNRISE * (1 - TimeNoon) * (1 - moonVisibility));

		vec3 vlcolor = (vec3(((vlDay + vlNight + vlSSSR))));
				 vlcolor *= (1 - Atmosphere*(1 - moonVisibility)*(1 - eBS));
				 vlcolor += vec3(atmosphere * (1 - eBS));
				 vlcolor *= (1 + (vlFinalInside));
				 vlcolor *= (1 + (vlGlow * (1 - eBS)));

			vlcolor = mix(color, vlcolor, VolumeSample * VL_MULT / 5.0 * (1-isEyeInWater) * (1-rainx) * transition_fading);
			return vlcolor;
	}
#endif


float dynamicExposure() {
		return clamp((-eyeBrightnessSmooth.y+230)/100.0,0.0,1.0);
}

float getAirDensity (float h) {
	return (max((h),60.0)-40.0)/2;
}

vec3 calcFog(vec3 fposition, vec3 color, vec3 fogclr,float yPosition,float d) {
	float tmult = mix(min(abs(worldTime-6000.0)/6000.0,1.0),1.0,rainx);
	float density = (8000.-tmult*tmult*2000.);

	vec3 worldpos = (gbufferModelViewInverse*vec4(fposition,1.0)).rgb+cameraPosition;
	float height = mix(getAirDensity (worldpos.y),0.1,rainx*0.8);

	float fog =   clamp(18.0*exp(-getAirDensity (yPosition)/density) * (1.0-exp( -d*height/density ))/height-0.28+rainx*0.28,0.0,1.);
	vec3 fogC = fogclr*0.9*(0.7+0.3*tmult);
return mix(color,fogC,fog);
}

#ifdef FOG
vec3 getFog(in vec3 color, in bool land,in float hand, in vec4 worldposition, in vec3 rainfogclr){
	float horizon = (worldposition.y - (texcoord.y-cameraPosition.y));

	float calcHeight = (max(pow(max(1.8 - horizon/100.0, 0.0), 4.0)-0.0, 0.0));
	float calcHeight2 = (max(pow(max(1.9 - horizon/100.0, 0.0), 8.0)-0.0, 0.0));

	float volumetric_cone = pow(max(dot(normalize(fragpos),lightVector),0.0),2.5)*transition_fading;
	float volumetric_cone2 = pow(max(dot(normalize(fragpos),lightVector),0.0),10.0*400.0);
	float volumetric_cone3 = pow(max(dot(normalize(fragpos),lightVector),0.0),10.0*1000.0)*transition_fading;
	float norain = 1.0-rainx;

	if (isEyeInWater > .9) {
	} else {

		float fog = exp(-pow(length(fragpos)/far*(1- dynamicExposure())*(1-(TimeSunrise+TimeSunset)*0.4) ,2.0));
		float fog2 = exp(-pow(length(fragpos)/90*(1-dynamicExposure()*.8) ,2.0));
		float fog3 = exp(-pow(length(fragpos)/140 ,2.0));
		float fog4 = exp(-pow(length(fragpos)/40 ,2.0));
		float fogfactor =  clamp(fog + hand,0.0,1.0);
		float fogfactor2 =  clamp(fog2 + hand,0.0,1.0);
		float fogfactor3 =  clamp(fog3 + hand,0.0,1.0);
		float fogfactor4 =  clamp(fog4 + hand,0.0,1.0)*rainx;

		fogclr3 = mix(color.rgb,rainfogclr*8.0,1.0)*rainx;
		fogclr3 += mix(color.rgb,ambient_color*0.5,1.0)*rainx*TimeMidnight;
		fogclr3 -= fogclr3*0.8*rainx;

		fogclr.rgb = fogclr.rgb*(0.75*(1-TimeMidnight));
		fogclr = mix(color.rgb,ambient_color,0.6+ clamp((20000*TimeMidnight), 0.0, 0.25))*(1.0-rainx)*(1.0-TimeMidnight*0.9)*(1-TimeSunrise*-.25)*(1-TimeNoon*-.5);
		fogclr.g -= fogclr.g*0.15;
		fogclr.rb -= fogclr.rb*0.1*(TimeSunrise+TimeSunset);

		vec3 limitcsssr = vec3(250,150,50)/250*(1.0-TimeNoon)*(1.0-TimeMidnight);
		
		float islava = float(aux.a > 0.50 && aux.a < 0.55);


		//glow

		fogclr += sunlight * volumetric_cone*2*transition_fading*(1.0-TimeMidnight)*(1.0-TimeNoon)*(1.0-rainx*0.4)*1.0;
		fogclr += fogclr * 0.05 * volumetric_cone*2*transition_fading*TimeMidnight*(1.0-rainx)*1.0;

		fogclr += volumetric_cone*0.75*(1.0-TimeMidnight)*(1.0-TimeSunrise)*(1.0-TimeSunset)*(1.0-rainx)*1.0;

		if (!land) {
		} else {
			color.rgb = mix(color.rgb,fogclr,(1-fogfactor)*.15*(1- dynamicExposure()));
			color.rgb = mix(color.rgb,fogclr3,(1-fogfactor2)*rainx*(1-TimeMidnight));
		}

		if (land) {
			} else {
				color.rgb += vec3(rainfogclr*rainx)*(1.0*rainx)*(1.0-TimeMidnight);
			}

		color.rgb = mix(color.rgb,fogclr3,(1-fogfactor2)*rainx*(1- TimeMidnight));
		color.rgb = mix(color.rgb,fogclr3,(1-fogfactor2)*rainx*(TimeMidnight));

		//altitude fog
		if (!land) {
			} else {
				color.rgb = mix(color.rgb,fogclr.rgb,0.25*(1-fogfactor)*(1-rainx)*(1-TimeMidnight)*(clamp((calcHeight), 0.0, 1.0)));

				calcHeight = (max(pow(max(1.175 - horizon/300.0, 0.0), 8.0)-0.0, 0.0));
				color.rgb  = mix(color.rgb,clamp(fogclr * 1.5, 0.0, 1.0),clamp(3.0*(clamp((calcHeight), 0.0, 1.0))*(TimeMidnight)*(1- rainx)*(1-TimeSunrise)*(transition_fading)*(1-fogfactor3),0.0,1.0));
			}

	}
	return color;
}
#endif


#ifdef REFLECTIONS
vec4 raytrace(vec3 fragpos, vec3 normal, vec3 fogclr, vec3 rvector) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;
		float normalDotEye = dot(normal, normalize(fragpos));
		vec3 fresnel = vec3(clamp(pow(1.0 + normalDotEye, 1.0),0.0,1.0));
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;


	    for(int i=0;i<30;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = distance(fragpos.xyz,spos.xyz);
        if(err < pow(length(vector)*pow(length(tvector),0.11),1.1)*1.1){

                sr++;
                if(sr >= maxf){

										bool land = texture2D(depthtex0, pos.st).r < comp;
                    float border = clamp(1.0 - pow(cdist(pos.st), 10.0), 0.0, 1.0);
                    color = texture2D(composite, pos.st);
										color.rgb *= fresnel;
										color.a = 1.0;
										color.rgb = land ? calcFog(fragpos,color.rgb,fogclr,cameraPosition.y,length(fragpos)) : fogclr*(1.0-isEyeInWater);
                    color.a *= border;
                    break;
                }
				tvector -=vector;
                vector *=ref;


}
        vector *= inc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }

    return color;
}

vec3 getSkyReflection(vec3 reflectedVector) {

	////////////////////////////////////////////////////////////////////////////////

	float volumetric_cone = pow(max(dot(normalize(reflectedVector),sunVec),0.0),2.5);

	vec3 sclr = vec3(75,85,150)/600*REFLECTION_STRENGTH/REFLECTION_STRENGTH*TimeNoon*(1.0-rainx);
		 sclr += vec3(moonlight*2.5)*REFLECTION_STRENGTH/REFLECTION_STRENGTH*moonVisibility*transition_fading*(1.0-rainx);
		 sclr += vec3(15,15,25)/140*REFLECTION_STRENGTH/REFLECTION_STRENGTH*(TimeSunrise+TimeSunset)*transition_fading*(1.0-rainx);
		 sclr += vec3(25,15,5)/100*REFLECTION_STRENGTH/REFLECTION_STRENGTH*(TimeSunrise+TimeSunset)*transition_fading*volumetric_cone*(1.0-rainx);
		 sclr += vec3(88,22,0)/(120)/17.5*volumetric_cone*(1-transition_fading)*(1.0-rainx);
		 sclr += vec3((moonlight*0.5)*7.5)*(1-transition_fading)*(1.0-rainx);
		 sclr += vec3(0.1,0.095,0.1)*0.5*rainx*(1-moonVisibility*0.75);

	vec3 skycolorreflection = vec3(sclr);
		 skycolorreflection *= (1.0-TimeSunrise*0.35)*(1.0-TimeSunset*0.35)*(1-isEyeInWater*0.8);
		 skycolorreflection *= 2.0;

	////////////////////////////////////////////////////////////////////////////////

	vec3 getSky;

	////////////////////////////////////////////////////////////////////////////////

	#ifdef Clouds
		vec3 addClouds = drawCloud(reflectedVector.xyz,skycolorreflection.rgb * (1-rainx*0.7),3.0);
	#else
		vec3 addClouds = vec3(0);
	#endif

	#ifdef Stars
		vec3 addStars = drawStar(reflectedVector.xyz,skycolorreflection.rgb);
	#else
		vec3 addStars = vec3(0);
	#endif

	////////////////////////////////////////////////////////////////////////////////

		#ifdef Clouds
			getSky += (addClouds)*reflectionSkyLight*(1-isEyeInWater);
		#else
			getSky += (skycolorreflection)*reflectionSkyLight*(1-isEyeInWater);
		#endif

		#ifdef Stars
			getSky += (addStars)*reflectionSkyLight*(1-isEyeInWater);
		#else
			getSky += (skycolorreflection)*reflectionSkyLight*(1-isEyeInWater);
		#endif

	////////////////////////////////////////////////////////////////////////////////

	return getSky;
}
#endif


#ifdef GODRAYS
	vec3 getGodrays(vec3 fragpos) {

	  vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
				 tpos = vec4(tpos.xyz/tpos.w,1.0);
		vec2 pos1 = tpos.xy/tpos.z;
		vec2 lightPos = pos1*0.5+0.5;

		const int nSteps = NUM_SAMPLES;
		const float blurScale = 0.002/nSteps*9.0;
		const int center = (nSteps-1)/2;
		float tw = 0.0;
		const float sigma = 0.5;

		float truepos = sunPosition.z/abs(sunPosition.z);

		vec3 rainc = mix(vec3(1.),fogclr3*1.5,rainx);
		vec3 lightColor = mix(sunlight*(1-moonVisibility)*rainc,moonlight*25*moonVisibility,(truepos));

		if (isEyeInWater < 0.9) {
		vec2 deltaTextCoord = normalize(texcoord.st - lightPos.xy)*blurScale*density;
		vec2 textCoord = texcoord.st;
		float illuminationDecay = 1.0;
		vec2 noise = vec2(getnoise(textCoord),getnoise(-textCoord.yx+0.05));
		float gr = 0.0;
		float avgdecay = 0.0;

		float Visibility = pow(max(dot(normalize(fragpos),lightVector),0.0),4.5);

		for(int i=0; i < NUM_SAMPLES ; i++)
		{

							textCoord += deltaTextCoord;

					float dist = (i-float(center))/center;
					float weight = exp(-(dist*dist)/(2.0*sigma));

					float sample = texture2DLod(gcolor, textCoord, 2.0).r*weight;

					tw += weight;
					gr += sample;

		}
		vec3 grC = mix(lightColor,fogclr3,rainx)*exposure*(gr/tw)*(1.0 - rainx*0.8)*Visibility * transition_fading * (1-isEyeInWater);
		color.xyz = (1-(1-color.xyz/48.0)*(1-grC.xyz/48.0))*48.0;
		}
	return color.rgb;
	}
#endif

#ifdef MOTIONBLUR
	vec3 getMotionblur(vec4 previousPosition, vec4 currentPosition, float hand) {

		if (isEyeInWater > 0.9) {
			} else if (hand > 0.9) {
				} else {
					#ifdef LQ_MOTIONBLUR
						vec2 velocity = (currentPosition.xyz - previousPosition.xyz).st * (0.01*MOTIONBLUR_AMOUNT);
					#endif
					#ifdef HQ_MOTIONBLUR
						vec2 velocity = (currentPosition - previousPosition).st * (0.002*MOTIONBLUR_AMOUNT);
					#endif


					int samples = 1;

					vec2 coord = texcoord.st + velocity;
					float dither = find_closest(texcoord.st,1.0);
					#ifdef HQ_MOTIONBLUR
						for (int i = 0; i < 16; ++i, coord += velocity) {
							if (coord.s > 1.0 || coord.t > 1.0 || coord.s < 0.0 || coord.t < 0.0) {
								break;
							}
								color += texture2D(composite, coord).rgb,color.rgb;
								++samples;
						}
						#endif
							#ifdef LQ_MOTIONBLUR
							for (int i = 0; i < 4; ++i, coord += dither*velocity) {
							if (coord.s > 1.0 || coord.t > 1.0 || coord.s < 0.0 || coord.t < 0.0) {
								break;
							}
								color += texture2D(composite, coord).rgb,color.rgb;
								++samples;
						}
					#endif

					color = (color/1.0)/samples;
				}
		return color;
	}
#endif

float waterH(vec2 posxz, float visibility) {

			vec2 movement = vec2(-abs(frameTimeCounter/2000.-0.5),-abs(frameTimeCounter/2000.-0.5));
			vec2 movement2 = vec2(abs(frameTimeCounter/2000.-0.5),abs(frameTimeCounter/2000.-0.5));

			vec2 coord = (posxz/600)+(movement);
			vec2 coord1 = (posxz/599)+(movement2);
			vec2 coord2 = (posxz/598)+(movement);
			vec2 coord3 = (posxz/597)+(movement2);

			float noise = texture2D(noisetex,fract(coord.xy/2.0)).x/8;
				  noise += texture2D(noisetex,fract(coord1.xy)).x/16.0;
				  noise += texture2D(noisetex,fract(coord2.xy*2.0)).x/8;
				  noise += texture2D(noisetex,fract(coord3.xy*2.0)).x/8;

			return noise * visibility;
}

vec3 getWaveHeight(vec2 posxz){

	vec2 coord = (posxz);

		float deltaPos = 0.3;

		//float fc = (find_closest(texcoord.st,deltaPos));
		float h0 = waterH(coord, 1.0f);
		float h1 = waterH(coord + vec2(deltaPos,0.0), 1.0f);
		float h2 = waterH(coord + vec2(-deltaPos,0.0), 1.0f);
		float h3 = waterH(coord + vec2(0.0,deltaPos), 1.0f);
		float h4 = waterH(coord + vec2(0.0,-deltaPos), 1.0f);

		float xDelta = ((h1-h0)+(h0-h2))/deltaPos;
		float yDelta = ((h3-h0)+(h0-h4))/deltaPos;

		vec3 wave = normalize(vec3(xDelta,yDelta,1.0-pow(abs(xDelta+yDelta),2.0)));

		return wave;
}

#ifdef WATER_CAUSTIC

vec3 waterCaustic(vec3 color, float visibility, in bool land) {

	vec3 underwaterpos = vec3(texcoord.st, texture2D(depthtex1, texcoord.st).r);
		 underwaterpos = nvec3(gbufferProjectionInverse * nvec4(underwaterpos * 2.0 - 1.0));

	vec4 worldpositionuw = gbufferModelViewInverse * vec4(underwaterpos,1.0);
	vec3 wpos = (worldpositionuw.xyz + cameraPosition.xyz);

	vec2 coord = vec2(wpos.xz + wpos.y);

	vec3 caustics = getWaveHeight(coord);

	float getcoustic = convertVec3ToFloat(caustics)/2.0;

	float wca = (CAUSTIC_STRENGHT * 1.5);
	float caustic = 1-(pow(0.05,clamp(getcoustic,-3.0,1.0)*1.1));
	vec3 wc = clamp(mix(color * visibility * wca,vec3(0),caustic * 2.0),0.0,1.0);

if (land)
	return wc;
	//return -0.1+caustics;
}

#endif

float refractmask(in vec2 coord){

	float mask = texture2D(gaux1, coord.st).g;
	mask =  float(mask > 0.04 && mask < 0.07);
	return mask;

}

#ifdef WATER_REFRACT

void waterRefraction(inout vec3 color, in vec4 worldposition, in vec4 fragposition) {
	vec3 posxz = worldposition.xyz + cameraPosition.xyz;

	float offset = 0.1;

	vec3 refraction = getWaveHeight(posxz.xz + posxz.y);

	float depth = getDepth(texture2D(depthtex1, texcoord.st).x);
	float depth2 = getDepth(pixeldepth);

	depth = depth - depth2;

	float refMult = 1.0;
		refMult = clamp(depth,0.0,1.0);
		refMult /= (depth2);
		refMult *= (REFRACT_MULT/75);

	offset *= refMult;

	vec2 coord1 = texcoord.st + refraction.xy * (refMult);
	vec2 coord2 = texcoord.st + refraction.xy * (refMult + offset);
	vec2 coord3 = texcoord.st + refraction.xy * (refMult + offset * 2.0);

	vec3 rA;
		rA.x = texture2D(composite, coord1).x;
		rA.y = texture2D(composite, coord2).y;
		rA.z = texture2D(composite, coord3).z;

	float maskCoord1 = refractmask(coord1);
	float maskCoord2 = refractmask(coord2);
	float maskCoord3 = refractmask(coord3);

	vec3 rB = color.rgb;

	refraction.r = rA.r*maskCoord1 + rB.r*(1-maskCoord1);
	refraction.g = rA.g*maskCoord2 + rB.g*(1-maskCoord2);
	refraction.b = rA.b*maskCoord3 + rB.b*(1-maskCoord3);

	if (iswater > 0.9)
		color = refraction;
}

#endif

vec3 getColorCorrection(vec3 color, bool land){

	float sLM = sky_lightmap;
	float islava = float(aux.a > 0.50 && aux.a < 0.55);

	if (land) {
		} else {
			sLM = 1.0;
		}

	//Color changes depends on time//

	color.b += color.b*0.1*TimeNoon*(1-rainx)*(1-islava);
	color.r -= color.r*0.15*TimeNoon*(1-rainx)*(1-islava);

	color.r = color.r + ((color.g + color.b)/2.0)*(0.05)*(1-rainx)*(1-TimeMidnight)*(sLM)*(1-islava);
	color.g = color.g + ((color.r + color.b)/2.0)*(0.05)*(1-rainx)*(1-TimeMidnight)*(sLM)*(1-islava);
	color.b = color.b + ((color.r + color.g)/2.0)*(0.05)*(1-rainx)*(1-TimeMidnight)*(sLM)*(1-islava);

	/////////////////////////////////////////////////////////////////

	color.bg += color.bg*.1*(1-islava*(1-rainx));

	return color.rgb;
}

float noisepattern(vec2 pos, float sample) {
	float noise = abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));

	noise *= sample;
	return noise;
}

vec3 getSunGlow(){

	float sample;

	sample += texture2DLod(gcolor, texcoord.st, 1.0).b;
	sample += texture2DLod(gcolor, texcoord.st, 2.0).b;

	sample /= 2.0;

	return clamp(pow(sunlight * sample, vec3(1.0)), 0.0, (1 - isEyeInWater) * (transition_fading) * (1 - TimeMidnight) * (1 - rainx));

}

//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

void main() {

	int iswater = int(matflag > 0.04 && matflag < 0.07);
	bool land = texture2D(depthtex0, texcoord.st).r < comp;
	int land2 = int(matflag < 0.03);
	int hand  = int(matflag > 0.75 && matflag < 0.85);
	float getReflectiveObjects = (float(aux2.x > 0.30 && aux2.x < 0.40) + float(aux.a > 0.22 && aux.a < 0.24)) * (1-iswater) * (1-hand);
	float islava = float(aux.a > 0.50 && aux.a < 0.55);

	fogclr = mix(color.rgb,ambient_color,0.6+ clamp((20000*TimeMidnight), 0.0, 0.25))*(1.0-rainx)*(1.0-TimeMidnight*0.9)*(1-TimeSunrise*-.25)*(1-TimeNoon*-.5);

	vec4 currentPosition = vec4(texcoord.x * 2.0 - 1.0, texcoord.y * 2.0 - 1.0, 2.0 * pixeldepth - 1.0, 1.0);

	vec4 fragposition = gbufferProjectionInverse * currentPosition;
		 fragposition = gbufferModelViewInverse * fragposition;
		 fragposition /= fragposition.w;
		 fragposition.xyz += cameraPosition;

	float genDepth = texture2D(depthtex0, texcoord.st).x;

	vec4 fragposition2 = gbufferProjectionInverse * vec4(texcoord.s * 2.0f - 1.0f, texcoord.t * 2.0f - 1.0f, 2.0f * genDepth - 1.0f, 1.0f);
		 fragposition2 /= fragposition2.w;

	vec4 previousPosition = fragposition;
		 previousPosition.xyz -= previousCameraPosition;
		 previousPosition = gbufferPreviousModelView * previousPosition;
		 previousPosition = gbufferPreviousProjection * previousPosition;
		 previousPosition /= previousPosition.w;

	vec4 worldposition = vec4(0.0);
		 worldposition = gbufferModelViewInverse * fragposition2;


	#ifdef WATER_REFRACT
		waterRefraction(color, worldposition, fragposition);
	#endif


	#ifdef MOTIONBLUR
		color = getMotionblur(previousPosition, currentPosition, hand);
	#endif


	vec3 rainfogclr = vec3(0.1,0.095,0.1)*rainx*(1-TimeMidnight);

	fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));

	vec3 colmult = mix(vec3(1.0),vec3(0.08,0.237,0.47)/1.0,isEyeInWater);
	float depth_diff = clamp(pow(ld(texture2D(depthtex0, texcoord.st).r)*2.5,2.0),0.0,1.0);
	color.rgb = mix(color.rgb,vec3(0.024,0.050,0.08)/3.0,depth_diff*(1.0-TimeMidnight*-0.4)*isEyeInWater);


		vec3 uPos = vec3(.0);

		float uDepth = texture2D(depthtex1,texcoord.xy).x;
		uPos = nvec3(gbufferProjectionInverse * vec4(vec3(texcoord.xy,uDepth) * 2.0 - 1.0, 1.0));

		vec3 uVec = fragposition2.xyz-uPos;

		float UNdotUP = abs(dot(normalize(uVec),normal));
		float depth = length(uVec)*UNdotUP;

	#ifdef WATER_CAUSTIC
		color += waterCaustic(color.rgb, exp(-depth / 2.0), land) * pow(sky_lightmap,1.0) * (1 - TimeMidnight * 0.5) * (1 - rainx * 0.75) * (iswater + isEyeInWater) * (1 - iswater * isEyeInWater);
	#endif

	#ifdef REFLECTIONS

		vec3 light_col = mix(pow(sunlight,vec3(4.4)),moonlight*5,moonVisibility);
			 light_col = mix(light_col,vec3(length(light_col))*vec3(0.25,0.32,0.4),rainx);

		float spec = getSpec(texcoord.st);
		light_col = pow(light_col,vec3(5.0/20.0));

		float normalDotEye = dot(normal, normalize(fragpos));
		vec3 fresnel = pow(vec3(clamp(pow(1.0 + normalDotEye, 1.0),0.0,1.0)),vec3(1.0));
		vec4 reflection;

		vec3 npos = normalize(fragpos);
		vec3 reflectedVector = normalize(reflect(npos, normalize(normal)));

		vec3 getSky = getSkyReflection(reflectedVector) * fresnel;
				 getSky += (spec * light_col * 5.0);

		vec3 Refl;

		#ifdef WATER_REFLECTIONS
			reflection = raytrace(fragpos, normal, getSky, reflectedVector);
			reflection.rgb = mix(getSky, reflection.rgb, reflection.a);
			reflection.a = max(reflection.a,1.0);
			Refl.rgb = reflection.rgb * (iswater + (getReflectiveObjects*0.5)) * (1-rainx*0.5*moonVisibility) * (1-isEyeInWater) * REFLECTION_STRENGTH*reflection.a;
			color.rgb = mix(Refl,color + Refl,1-pow(fresnel.x,1.0)*iswater*(1-isEyeInWater));
		#endif

		reflection = raytrace(fragpos, normal, getSky, reflectedVector);
		reflection.rgb = mix(getSky, reflection.rgb, reflection.a);
		reflection.a = max(reflection.a,1.0);

		#ifdef RAIN_REFLECTIONS
		if (specular.g > 0.0) {
			Refl.rgb = (reflection.rgb * fresnel*reflection.a)*clamp(pow(iswet, 10.0), 0.0, 1.0)*(1.0-specmap) * 2.0 * (getRainPuddles(fragpos) + .4*(1-(getRainPuddles(fragpos))));
			color.rgb += (Refl*(1-iswater)*(1-isEyeInWater));
		}
		#endif

		#ifdef SPECULAR_REFLECTIONS
		if (specular.g > 0.0) {
			color.rgb += (reflection.rgb*fresnel*reflection.a)*specmap*(1-iswater);
		}
		#endif

	#endif

	#ifdef FOG
		color = getFog(color, land, hand, worldposition, rainfogclr);
	#endif

	#ifdef VOLUMETRIC_LIGHT
		color.rgb = vec3(vlColor(vec3(fogclr), color.rgb));
	#endif

	#ifdef GODRAYS
		color.rgb = getGodrays(fragpos);
	#endif

	#ifdef Clouds
		if (!land)	color.rgb = drawCloud(fragpos.xyz,color.rgb,1.0);
	#endif

	#ifdef Stars
		if (!land)	color.rgb = drawStar(fragpos.xyz,color.rgb);
	#endif

	color += getSunGlow();


vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	 tpos = vec4(tpos.xyz/tpos.w,1.0);

vec2 pos1 = tpos.xy/tpos.z;
vec2 lightPos = pos1*0.5+0.5;

float visiblesun = 0.0;
float temp;
int nb = 0;

//calculate sun occlusion (only on one pixel)
if (texcoord.x < pw && texcoord.x < ph) {
	for (int i = 0; i < 2;i++) {
		for (int j = 0; j < 3 ;j++) {
		temp = texture2D(gaux1,lightPos + vec2(pw*(i-0.0)*7.0,ph*(j-0.0)*7.0)).g;
		visiblesun +=  1.0-float(temp > 0.04) ;
		nb += 1;
		}
	}
	visiblesun /= nb;

}

#ifdef COLOR_CORRECTION
	color.rgb = getColorCorrection(color,land);
#endif

	/* DRAWBUFFERS:0 */

	gl_FragData[0] = vec4(color.rgb,visiblesun);

}
