//Calling shadows into certain files to reduce duplicated code.

//Shadows
const bool Shadows = true;			
#define SHADOW_MAP_BIAS 0.86			
const int shadowMapResolution = 1024;		//Shadows resolution. [512 1024 2048 3072 4096 8192]
const float shadowDistance = 90;			//Draw distance of shadows.[60 90 120 150 180 210]
const bool 	shadowHardwareFiltering0 = true;
//------------------------------------------

//Shadows
float shading = 0.0;

vec4 fragposition = gbufferProjectionInverse*(vec4(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z,1.0)*2.0-1.0);
fragposition /= fragposition.w;
	
if (Shadows){
	vec4 worldposition = gbufferModelViewInverse * vec4(fragposition);
	
	worldposition = shadowModelView * worldposition;
	worldposition = shadowProjection * worldposition;
	worldposition /= worldposition.w;
	float distb = length(worldposition.st);
	float distortFactor = mix(1.0,distb,SHADOW_MAP_BIAS);
	worldposition.xy /= distortFactor; 
	
	float diffthresh = distortFactor*distortFactor*(0.0097297*tan(acos(diffuse)) + 0.01729729729);
	diffthresh = mix(diffthresh,0.0007,mat);
	const float halfres = (0.5/shadowMapResolution);
	float offset = ((mat)*halfres+halfres);
	
	worldposition = worldposition * 0.5f + vec4(0.5,0.5,0.5-diffthresh,0.5);
	
	if (max(abs(worldposition.x-0.5),abs(worldposition.y-0.5)) < 0.48) {
	if(eyeBrightness.y < 2)shading = 0.0;
	else shading = dot(vec4(shadow2D(shadow,vec3(worldposition.st + vec2(offset,offset), worldposition.z)).x,shadow2D(shadow,vec3(worldposition.st + vec2(-offset,offset), worldposition.z)).x,shadow2D(shadow,vec3(worldposition.st + vec2(offset,-offset), worldposition.z)).x,shadow2D(shadow,vec3(worldposition.st + vec2(-offset,-offset), worldposition.z)).x),vec4(diffuse)*0.25);
	}
}
	//Colors
	vec4 tex = texture2D(texture, texcoord.st) * texture2D(lightmap, lmcoord.st) * color;
	vec3 mixcolors = (1.5+shading+ambientColor.rgb)*tex.rgb/3.0;
//-----------------------------------------------------------------------------------