#version 120
/* DRAWBUFFERS:0 */
/*
                            _____ _____ ___________ 
                           /  ___|_   _|  _  | ___ \
                           \ `--.  | | | | | | |_/ /
                            `--. \ | | | | | |  __/ 
                           /\__/ / | | \ \_/ / |    
                           \____/  \_/  \___/\_|    

						Before editing anything here make sure you've 
						read The agreement, which you accepted by downloading
						my shaderpack. The agreement can be found here:
			http://www.minecraftforum.net/topic/1953873-164-172-sildurs-shaders-pcmacintel/
						   
						Sildur's shaders, derived from Chocapic's shaders */
						

const int noiseTextureResolution  = 512;
const float	sunPathRotation	= 0.0f;		//[0.0f -40.0f]
varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;

varying vec4 ambientColor;

uniform sampler2D texture;
uniform sampler2D lightmap;
uniform sampler2DShadow shadow;

uniform float viewWidth;
uniform float viewHeight;
uniform ivec2 eyeBrightness;

varying float mat;
varying float lblocks;
float diffuse = ambientColor.a;

//Default fog
const int GL_LINEAR = 9729;
const int GL_EXP = 2048;
uniform int fogMode;

/* If you reached this line, then you're probably about to break the agreement which you accepted by downloading Sildur's shaders!
So stop your doing and ask Sildur before copying anything which would break the agreement, unless you're Chocapic then go ahead ;)
--------------------------------------------------------------------------------------------------------------------------------*/ 

void main() {

	//Shadows
	#include "shadows.frag"
	
	if(lblocks > 0.9)gl_FragData[0] = tex;
	else gl_FragData[0] = vec4(mixcolors,tex.a);
	
	//Default fog
	if (fogMode == GL_EXP) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, 1.0 - clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0));
	} else if (fogMode == GL_LINEAR) {
		gl_FragData[0].rgb = mix(gl_FragData[0].rgb, gl_Fog.color.rgb, clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0));
	}

}