#version 120

/*
                            _____ _____ ___________ 
                           /  ___|_   _|  _  | ___ \
                           \ `--.  | | | | | | |_/ /
                            `--. \ | | | | | |  __/ 
                           /\__/ / | | \ \_/ / |    
                           \____/  \_/  \___/\_|    

						Before editing anything here make sure you've 
						read The agreement, which you accepted by downloading
						my shaderpack. The agreement can be found here:
			http://www.minecraftforum.net/topic/1953873-164-172-sildurs-shaders-pcmacintel/
						   
						Sildur's shaders, derived from Chocapic's shaders */
						
						

//#define CROSSPROCESS			//Uncomment if you want default colors.

varying vec4 texcoord;

uniform sampler2D gaux2;
uniform sampler2D gaux4;

void main() {

	vec3 color = texture2D(gaux2, texcoord.st).rgb;
	//fix for water on macs/amd
	color.rgb += texture2D(gaux4, texcoord.xy).rgb*sqrt(texture2D(gaux4,texcoord.xy).a);

	#ifndef CROSSPROCESS
	color.r = (color.r*1.34)+(color.b+color.g)*(-0.1);
    color.g = (color.g*1.2)+(color.r+color.b)*(-0.1);
    color.b = (color.b*1.1)+(color.r+color.g)*(-0.1);
	color = color / (color + 2.2) * (1.0+2.0);
	#endif
	
	gl_FragColor = vec4(color,1.0);
	
}
