#version 120

/*
############   #############   ##############   ############# 
############   #############   ##############   #############
###                 ###        ###        ###   ###       ###
###                 ###        ###        ###   ###       ###
############        ###        ###        ###   #############
############        ###        ###        ###   #############
         ###        ###        ###        ###   ###
         ###        ###        ###        ###   ###
############        ###        ##############   ###
############        ###        ##############   ###

/*

- Before you adjust variables below, please read Chocapic13's Sharing and Modification Rules HERE:
http://www.minecraftforum.net/forums/mapping-and-modding/minecraft-mods/1293898-chocapic13s-shaders

*- Basically all code in this shader Belongs to Chocapic13, I used his shader as a base.

~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
BASE VERSION: Chocapic13's V5TEST2
SHADER VERSION: 2.02 Beta
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

SeaMatis's Shaders Rules:
-You are NOT permitted to use this shader as a base,due to the fact that my shader is not "my own" or "Independent" from Chocapic13's shader
-No taking and reuploading to the internet as yours
-No using monetizing links on my shader
However, you ARE allowed to make videos of my shader, just remember to credit me, and Chocapic13

*/

//disabling is done by adding "//" to the beginning of a line.

const bool gaux2MipmapEnabled = true;



varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 ambient_color;

uniform sampler2D depthtex0;
uniform sampler2D gaux2;
uniform sampler2D gaux4;
uniform sampler2D gcolor;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;
vec3 sunPos = sunPosition;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float timefract = worldTime;

float getnoise(vec2 pos) {
	return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));
}

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
//Bloom
const float rMult = 0.0032;
const int nSteps = 15;


int center = (nSteps-1)/2;
float radius = center*rMult;

vec3 blur = vec3(0.0);
float tw = 0.0;

float sigma = 0.3;


for (int i = 0; i < nSteps; i++) {

float dist = (i-float(center))/center;

float weight = exp(-(dist*dist)/(2.0*sigma));

blur += pow(texture2DLod(gaux2,texcoord.xy + rMult*vec2(1.0,aspectRatio)*vec2(i-center,0.0),2).rgb,vec3(2.2))*weight;
tw += weight;
}
blur /= tw;
blur = clamp(pow(blur,vec3(1.0/2.2)),0.0,1.0);
/* DRAWBUFFERS:3 */
	gl_FragData[0] = vec4(blur,1.0);
}
