#version 120
#extension GL_ARB_shader_texture_lod : enable
#define MAX_COLOR_RANGE 48.0
/*
!! DO NOT REMOVE !!
BSL Shaders is derived from Chocapic13 v5 test 2

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

/*
Disable an effect by putting "//" before "#define" when there is no number after
You can tweak the numbers, the impact on the shaders is self-explained in the variable's name or in a comment
*/

//ADJUSTABLE VARIABLES//

	#define WorldDimension 0								//The world dimension you're in. -1 : Nether | 0 : Overworld | 1 : End [0 -1 1]
	#define Fog_Distance 8									//Set fog starting point. Insert Minecraft's render distance here for best result. [2 4 6 8 10 12 14 16]

	//#define VolLight										//Light shafts viewable from any camera angle. Brightens sky. Thanks to Robobo1221.
		#define VL_MULT 					5.0
		#define VL_STRENGTH_DAY 			1.0
		#define VL_STRENGTH_NIGHT 			1.0
		#define VL_STRENGTH_SUNSET_SUNRISE 	1.0
		#define VL_STRENGTH_INSIDE 			0.5
		const bool   gdepthMipmapEnabled  = true;
	
	#define Godrays											//Light shafts around sun and moon.
		const float exposure = 3.0;
		const int NUM_SAMPLES = 7;
		const float raysize = 1.0;

	//#define RoundSunMoon									//Enables round sun and moon. Disable sun and moon from video settings if required.

	//#define Sky_VanilaColor								//EXPERIMENTAL. Use this if you want vanila minecraft based sky. Affected by resourcepacks too.
	#define Sky_Height 1.3									//Determines sky gradient position. [1.0 1.1 1.2 1.3 1.4 1.5 1.6]
	
	//#define Specular										//Creates gloss and reflection on blocks. Enable Bump mapping for better specular.
		#define Specular_Strength 4.
		
	#define ReflectWater									//Water creates screen space reflection.
		//#define ReflectWater_Cloud						//Reflects cloud if not reflected from screen space reflection. Cloud must be enabled.
		#define ReflectWater_Strength 1.0

	//#define Celshade										//Creates black outline.
		#define Celshade_Out								//Cel shading technique. Can enable both.
		//#define Celshade_In								//Cel shading technique. Can enable both.
		#define Celshade_Stroke 0.666						//Black outline stroke size. [0.666 1.000 1.333 1.666 2.000]
		#define Celshade_Strength 100.0						//Border detection strength. [10.0 25.0 50.0 100.0 200.0 500.0 1000.0 2000.0 5000.0]

	//#define BumpEdge
		#define BORDERE 2.0
		#define EDGESTR 0.25

	#define Cloud
		#define CLOUD_SPEED 1.0
		#define CLOUD_PASS 4
		#define CLOUD_DISTANCE 45
		#define CLOUD_HEIGHT 4
	#define Sky_Stars
	
	//#define Watercolor_Vanila								//Pure texture based water. Only enable one.
	//#define Watercolor_Clear								//Clear-ish water. Only enable one.
	//#define Watercolor_Tropical							//Weak green-ish water. Only enable one.
	//#define Watercolor_Legacy								//Strong blue water. Only enable one.
	//#define Watercolor_Classic							//Weak light blue water. Only enable one.
	#define Watercolor_Original								//Strong dark blue water. Only enable one.

	//#define WorldTimeAnimation

//ADJUSTABLE VARIABLES//

//don't touch these lines if you don't know what you do!
const int maxf = 4;				//number of refinements
const float stp = 1.2;			//size of one step for raytracing algorithm
const float ref = 0.1;			//refinement multiplier
const float inc = 2.2;			//increasement factor at each step

//ground constants (lower quality)
const int Gmaxf = 3;				//number of refinements
const float Gstp = 1.2;			//size of one step for raytracing algorithm
const float Gref = 0.11;			//refinement multiplier
const float Ginc = 3.0;			//increasement factor at each step

varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;

varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 ambient_color;

uniform ivec2 eyeBrightnessSmooth;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D composite;
uniform sampler2D gaux1;
#ifdef Specular
uniform sampler2D gaux3;
#endif
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gnormal;
uniform sampler2D gdepth;
uniform sampler2D noisetex;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;
uniform vec3 skyColor;
#ifdef Sky_VanilaColor
uniform vec3 fogColor;
#endif

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

uniform int isEyeInWater;
uniform int worldTime;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;

const float dimread = WorldDimension;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float matflag = texture2D(gaux1,texcoord.xy).g;

vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;

#ifdef WorldTimeAnimation
float frametime = worldTime/20.0;
#else
float frametime = frameTimeCounter;
#endif

#ifdef Watercolor_Vanila
vec3 watercolor = vec3(0.02,0.08,0.28);
float wateropacity = 0.2;
#endif

#ifdef Watercolor_Clear
vec3 watercolor = vec3(0.02,0.08,0.14);
float wateropacity = 0.2;
#endif

#ifdef Watercolor_Tropical
vec3 watercolor = vec3(0.1,0.6,0.6);
float wateropacity = 0.4;
#endif

#ifdef Watercolor_Legacy
vec3 watercolor = vec3(0.0,0.3,0.7);
float wateropacity = 0.7;
#endif

#ifdef Watercolor_Classic
vec3 watercolor = vec3(0.1,0.4,0.7);
float wateropacity = 0.4;
#endif

#ifdef Watercolor_Original
vec3 watercolor = vec3(0.02,0.06,0.14);
float wateropacity = 0.8;
#endif

float time = float(worldTime);
float transition_fading = (clamp((time-12000.0)/500.0,0.0,1.0)-clamp((time-13500.0)/500.0,0.0,1.0) + clamp((time-22500.0)/500.0,0.0,1.0)-clamp((time-23500.0)/500.0,0.0,1.0));	//fading between sun/moon shadows
float night = clamp((time-13000.0)/500.0,0.0,1.0)-clamp((time-22500.0)/500.0,0.0,1.0);
float timebrightness = abs(sin(time/12000*22/7));

//Time of Day for VL
float TimeSunrise  = ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(time, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(time, 0.0, 4000.0)) / 4000.0) - ((clamp(time, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(time, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(time, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(time, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(time, 23000.0, 24000.0) - 23000.0) / 1000.0);

float sky_lightmap = texture2D(gaux1,texcoord.xy).r;
float torch_lightmap = texture2D(gaux1,texcoord.xy).b;

vec4 color = texture2D(composite,texcoord.xy);
float iswet = wetness*pow(sky_lightmap,5.0)*sqrt(0.5+max(dot(normal,upVec),0.0));

#ifdef Specular
vec3 specular = pow(texture2D(gaux3,texcoord.xy).rgb,vec3(2.2));
float specmap = (specular.r+specular.g*(iswet));
#endif

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

float edepth(vec2 coord) {
	return texture2D(depthtex0,coord).z;
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

#ifdef BumpEdge
float getdist(float rng) {
	return 1-clamp(ld(texture2D(depthtex0,texcoord.xy).r)/rng*far,0,1);
}
vec3 edgeshadow(vec3 clrr,float str) {
	//edge detect
	float d = edepth(texcoord.xy);
	float dtresh = 1/(far-near)/120.0;
	vec4 dc = vec4(d,d,d,d);
	vec4 sa;
	vec4 sb;
	float dist = (getdist(64)+1)/2;
	float bord = floor(BORDERE*viewWidth/1280) * dist;
	sa.x = edepth(texcoord.xy + vec2(-pw,-ph)*bord);
	sa.y = edepth(texcoord.xy + vec2(pw,-ph)*bord);
	sa.z = edepth(texcoord.xy + vec2(-pw,0.0)*bord);
	sa.w = edepth(texcoord.xy + vec2(0.0,ph)*bord);

	//opposite side samples
	sb.x = edepth(texcoord.xy + vec2(pw,ph)*bord);
	sb.y = edepth(texcoord.xy + vec2(-pw,ph)*bord);
	sb.z = edepth(texcoord.xy + vec2(pw,0.0)*bord);
	sb.w = edepth(texcoord.xy + vec2(0.0,-ph)*bord);

	vec4 dd = (2.0* dc - sa - sb) - dtresh;
	dd = vec4(step(dd.x,0.0),step(dd.y,0.0),step(dd.z,0.0),step(dd.w,0.0));

	float e = (clamp(dot(dd,vec4(0.25f,0.25f,0.25f,0.25f)),0.0,1.0));
	return clrr*(1-str)+clrr*e*str;
}
vec3 edgerim(vec3 clrr,float str) {
	//edge detect
	float d = edepth(texcoord.xy);
	float dtresh = 1/(far-near)/120.0;
	vec4 dc = vec4(d,d,d,d);
	vec4 sa;
	vec4 sb;
	float dist = (getdist(64)+1)/2;
	float bord = floor(BORDERE*viewWidth/1280) * dist;
	sa.x = edepth(texcoord.xy + vec2(-pw,-ph)*bord);
	sa.y = edepth(texcoord.xy + vec2(pw,-ph)*bord);
	sa.z = edepth(texcoord.xy + vec2(-pw,0.0)*bord);
	sa.w = edepth(texcoord.xy + vec2(0.0,ph)*bord);

	//opposite side samples
	sb.x = edepth(texcoord.xy + vec2(pw,ph)*bord);
	sb.y = edepth(texcoord.xy + vec2(-pw,ph)*bord);
	sb.z = edepth(texcoord.xy + vec2(pw,0.0)*bord);
	sb.w = edepth(texcoord.xy + vec2(0.0,-ph)*bord);

	vec4 dd = abs(2.0* dc - sa - sb) - (2.0* dc - sa - sb) - dtresh;
	dd = vec4(step(dd.x,0.0),step(dd.y,0.0),step(dd.z,0.0),step(dd.w,0.0));

	float e = (clamp(dot(dd,vec4(0.25f,0.25f,0.25f,0.25f)),0.0,1.0));
	return clrr*(1-e)*str;
}
#endif

vec3 getSkyColor(vec3 fposition) {
//sky gradient
/*----------*/
vec3 sky_color = vec3(0);
if (dimread == 0){
sky_color = vec3(0.1, 0.35, 1.0);
#ifdef Sky_VanilaColor
sky_color = pow(fogColor,vec3(2.2))*0.8;
#endif
vec3 nsunlight = normalize(pow(sunlight,vec3(2.2)))*(1-dot(normalize(fposition),upVec)+skyColor*dot(normalize(fposition),upVec));
nsunlight *= 1-pow(timebrightness,0.15)*(0.8*(1-timebrightness))*(1-transition_fading);
vec3 sVector = normalize(fposition);

sky_color = mix(sky_color*(1-rainStrength*0.05),vec3(0.25,0.3,0.4)*length(ambient_color)*pow(rainStrength,1.5)*0.5,rainStrength);

float Lz = 1.0;
float cosT = dot(sVector,upVec);
float absCosT = pow(max(cosT,0.0),Sky_Height);
float cosS = dot(sunVec,upVec);
float S = acos(cosS);
float cosY = dot(sunVec,sVector);
float absCosY = max(cosY,0.0);
float Y = acos(cosY);
float sidefog = pow(clamp(1-abs(cosT),0,0.9),3)*(1-absCosY*(0.5+0.4*pow(timebrightness,0.1)))*0.9;

float a = -1.;
float b = -0.2+0.1*max(timebrightness,transition_fading)-0.1*moonVisibility;
float c = 4.0-2.0*timebrightness;
float d = -0.6;
float e = 0.1+(timebrightness+transition_fading/8)*0.8;

#ifdef Sky_VanilaColor
sidefog *= 0.22;
float vsmix = max(pow(max(cosT,0.0),0.9)-sidefog,0.0);
sky_color = mix(sky_color,pow(skyColor,vec3(2.2))*0.8,vsmix*(1-rainStrength));
b -= 0.05;
#endif

//sun sky color
float L = (1+a*exp(b/(absCosT+0.01)))*(1+c*exp(d*Y)+e*absCosY*absCosY) + sidefog*(1-transition_fading);
L = pow(L,1.0-rainStrength)+sidefog*rainStrength/2*(1-transition_fading); //modulate intensity when raining
float skymix = clamp(1-exp(-0.005*pow(L*1.1,4.)*(1-rainStrength*0.5)),0,4);
vec3 skyColorSun = mix(sky_color, nsunlight,skymix)*(L*(1-cosY*cosY/2*transition_fading*(1-rainStrength)))*0.5*(1.0-pow(max(cosY,0.0),2.2)*0.4*(1.0-rainStrength));
skyColorSun *= sunVisibility * (1-transition_fading*0.2);

//moon sky color
float McosS = MdotU;
float MS = acos(McosS);
float McosY = dot(moonVec,sVector);
float MY = acos(McosY);

float L2 = (1+a*exp(b/(absCosT+0.01)))*(1+c*exp(d*MY)+e*McosY*McosY)+0.2;
L2 = pow(L2,1.0-rainStrength*0.8)*(1.0-rainStrength*0.2); //modulate intensity when raining
vec3 skyColormoon = mix(moonlight,normalize(vec3(0.25,0.3,0.4))*length(moonlight),rainStrength*0.8)*L2*0.8;
skyColormoon *= moonVisibility;

sky_color = min(vec3(1),skyColormoon*2.0+skyColorSun);
sky_color *= (2.0-(eyeBrightnessSmooth.y/240.0*(1-isEyeInWater)+isEyeInWater))*(1-rainStrength)+rainStrength;
//sky_color = vec3(Lc);
}

if (dimread == -1) sky_color = vec3(0.0005,0.00025,0.00012);
if (dimread == 1) sky_color = vec3(0.005,0,0.005);
return sky_color;
}


vec3 drawSun(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);

float angle = (1-max(dot(sVector,sunVec),0.0))*500.0;
float sun = exp(-angle*angle);
	  angle = (1-max(dot(sVector,sunVec),0.0))*250.0;
	  sun += exp(-angle*angle)*0.5;
sun *= (1-rainStrength)*clamp(sunVisibility+transition_fading*(1-rainStrength)/2,0,1);

vec3 sunlight = pow(vec3(1.0,0.5,0.125),vec3(0.5));
sunlight *= (2-transition_fading)/2;
float sunmult = pow(100.0,(1-rainStrength))*pow(sun,0.1);

return mix(color,sunlight*sunmult,sun*(1-rainStrength));

}

vec3 drawMoon(vec3 fposition,vec3 color) {
vec3 sVector = normalize(fposition);

float angle = (1-max(dot(sVector,moonVec),0.0))*300.0;
float moon = exp(-angle*angle);
moon *= (1-rainStrength)*clamp(moonVisibility+transition_fading*(1-rainStrength)/2,0,1);
moon = clamp(moon*moon*moon*moon,0,1)+moon/10;
vec3 moonlight = vec3(0.1,0.3,0.5)*(2-transition_fading)/2;

return mix(color,pow(moonlight,vec3(1.0/1.2))*32.,moon*(1-rainStrength));

}



vec3 calcFog(vec3 fposition, vec3 color, vec3 fogclr) {
	float start = Fog_Distance*(6.0-3.0*rainStrength)*(1-night);
	float range = Fog_Distance*64.0*(1-night*0.75);
	float fog = 1.0-clamp(length(fposition)/range-start/range,0.0,1.0);
	fog = 1.0-((1.0-fog)*(eyeBrightnessSmooth.y/240.0*(1-isEyeInWater)+isEyeInWater));

	vec3 fc = fogclr*(1.5-night*0.5);
	return mix(fc,color,fog);
}
vec3 calcConstFog1(vec3 fposition0, vec3 color, vec3 fogclr) {
	float start = Fog_Distance*(6.0-3.0*rainStrength)*(1-night);
	float range = Fog_Distance*64.0*(1-night*0.75);
	float fog0 = 1.0-clamp(length(fposition0)/range-start/range,0.0,1.0);
	fog0 = 1.0-((1.0-fog0)*(eyeBrightnessSmooth.y/240.0*(1-isEyeInWater)+isEyeInWater));
	
	vec3 fc = fogclr*(1.5-night*0.5);
	return mix(fc,color,fog0);
}
vec3 calcConstFog2(vec3 fposition, vec3 fposition0, vec3 color, vec3 fogclr) {
	float start = Fog_Distance*(6.0-3.0*rainStrength)*(1-night);
	float range = Fog_Distance*64.0*(1-night*0.75);
	float fog = 1.0-clamp(length(fposition)/range-start/range,0.0,1.0);
	float fog0 = 1.0-clamp(length(fposition0)/range-start/range,0.0,1.0);
	fog = 1.0-((1.0-fog)*(eyeBrightnessSmooth.y/240.0*(1-isEyeInWater)+isEyeInWater));
	fog0 = 1.0-((1.0-fog0)*(eyeBrightnessSmooth.y/240.0*(1-isEyeInWater)+isEyeInWater));
	
	vec3 fc = fogclr*(1.5-night*0.5);
	return mix(fc,color + fc*(1-fog),fog0);
}
vec3 calcSkyFog(vec3 fposition, vec3 color, vec3 fogclr) {
	float density = 1500.0 *(1.0 + rainStrength);
	float start = 0.02;
	float rainFog = 1.0+rainStrength;
	float fog = min(exp(-length(fposition)/density/(sunVisibility*0.7+0.3)*rainFog)+start*sunVisibility*(1-rainStrength),1.0);

	vec3 fc = fogclr*1.5;
	return mix(fc,color,fog);
}
vec3 calcSkyInWaterFog(vec3 fposition, vec3 color, vec3 fogclr) {
	float density = 2000.0 *(1.0 + rainStrength);
	float start = 0.02;
	float rainFog = 1.0+rainStrength;
	float fog = min(exp(-length(fposition)/density/(sunVisibility*0.7+0.3)*rainFog)+start*sunVisibility*(1-rainStrength),1.0);

	vec3 fc = fogclr*3.0;
	return mix(fc,color*2,fog);
}
vec3 underwaterFog (vec3 fposition,vec3 color, vec3 Ucolor,float opacity) {
	float o = clamp(opacity*1.5,0.1,1.0);
	float start = 8.0/o;
	float range = 32.0/o;
	float fog = clamp(length(fposition)/range-start/range,0.0,1.0);

	vec3 c = mix(color,color*pow(Ucolor,vec3(2.2)),fog);
	vec3 fc = Ucolor*0.2;
	return mix(c,fc,fog);
}

float getnoise(vec2 pos) {
	return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));
}

vec3 drawCloud(vec3 fposition,vec3 color, float str) {
float totalcloud = 0;
vec3 sVector = normalize(fposition);
float cosT = dot(sVector,upVec);
float cosS = dot(sunVec,sVector);
float pi = 3.1415927;
vec2 wind = vec2(-frametime,frametime)/20000*CLOUD_SPEED;

//cloud generation

vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);

vec3 cloud_color = (sunlight*sunVisibility+moonlight*8)*2;
vec3 cloud_color_rain = mix(vec3(0.22,0.24,0.32),vec3(0.030,0.044,0.06),moonVisibility)*2;
cloud_color = mix(cloud_color*pow(1-rainStrength,3.0*(1.0+night)),cloud_color_rain,rainStrength)*(4-3*eyeBrightnessSmooth.y/240.0);

for (int i = 0; i < CLOUD_PASS; i++) {
	vec3 intersection = wVector*((CLOUD_DISTANCE-i*CLOUD_HEIGHT/CLOUD_PASS)/(wVector.y));
	vec3 wpos = tpos.xyz;
	vec2 coord1 = (intersection.xz)/50000 + cameraPosition.xz/80000;
	vec2 coord = sin(coord1.yx);
	float noise = texture2D(noisetex,coord*pow(2,pow(5.0,1.0/64.0))+wind*pow(2.0,0.0)).x*8;
		  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,4.0/64.0))+wind*pow(2.0,0.25)).x*7;
		  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,9.0/64.0))+wind*pow(2.0,0.5)).x*6;
		  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,16.0/64.0))+wind*pow(2.0,0.75)).x*5;
		  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,25.0/64.0))+wind*pow(2.0,1.0)).x*4;
		  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,36.0/64.0))+wind*pow(2.0,1.25)).x*3;
		  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,49.0/64.0))+wind*pow(2.0,1.5)).x*2;
		  noise+= texture2D(noisetex,coord*pow(2,pow(5.0,64.0/64.0))+wind*pow(2.0,1.75)).x;
		  noise = (pow(noise/36.0,0.225) - (1.0-(1.05-0.1*sin(i/4*pi))/6.0)*pow(1-rainStrength,0.5))*(mix(6.0,1.0,rainStrength));

	float cloud2 = max(noise,0.0)*0.1;
	totalcloud = mix(totalcloud,1-i/(CLOUD_PASS+1),cloud2);
	cloud_color = mix(cloud_color,vec3(0),(cloud2*10) * (pow((i/CLOUD_PASS),2.2)));
}
totalcloud /= CLOUD_PASS;
totalcloud = pow(totalcloud*10.0,2.0)*0.4;
totalcloud*= pow(clamp(cosT,0.0,1.0/(2.0-rainStrength))*(2.0-rainStrength),2.0-rainStrength*0.7);

float rainl = pow(abs(cosS),8.0)*2*rainStrength;
cloud_color = mix(cloud_color,cloud_color*1.5,rainl)*mix(str,1.0,rainStrength);

vec3 c = mix(color,cloud_color,totalcloud);

return c;
}

vec3 drawStar(vec3 fposition,vec3 color) {

vec3 sVector = normalize(fposition);
float cosT = max(dot(normalize(sVector),upVec),0.0);
float McosY = MdotU;
float cosY = SdotU;
vec3 tpos = vec3(gbufferModelViewInverse * vec4(fposition,1.0));
vec3 wvec = normalize(tpos);
vec3 wVector = normalize(tpos);

vec4 totalcloud = vec4(.0);

vec3 intersection = wVector*((-cameraPosition.y+400.0)/(wVector.y));
vec3 iSpos = (gbufferModelView*vec4(intersection,1.0)).rgb;
float cosT2 = max(dot(normalize(iSpos),upVec),0.0);
vec2 wind = vec2(frametime/10000);

	intersection = wVector*((-cameraPosition.y+300.0*3.66*(1+cosT2*cosT2*3.5)+500*sqrt(cosT2))/(wVector.y)); 			//curved cloud plane
	vec3 wpos = tpos.xyz+cameraPosition;
	vec2 coord1 = intersection.xz/400000.0+wind*0.01;
	vec2 coord = fract(coord1);

	float noise = texture2D(noisetex,coord*32).x;
	noise += texture2D(noisetex,coord*32+vec2(250)).x;
	noise += texture2D(noisetex,coord*32+vec2(500)).x;
	noise += texture2D(noisetex,coord*32+vec2(750)).x;
	noise = clamp(1-noise*7,0,1);

	float starglow = texture2D(noisetex,coord+wind/50).x;
	starglow += texture2D(noisetex,coord/4-wind/50).x;
	starglow = clamp(starglow*starglow-1,0,1);

	totalcloud += vec4(moonlight*16*(1+starglow),noise);
	totalcloud.a = min(totalcloud.a,1.0);

totalcloud *= clamp(cosT*1.5,0,1)*2;
return mix(color.rgb,totalcloud.rgb*(1 - rainStrength*0.8)*4.6,totalcloud.a*pow(cosT2,1.2)*moonVisibility*pow(1-rainStrength,2.0)*(1-transition_fading));

}

vec4 raytrace(vec3 fragpos, vec3 normal,vec3 fogclr, vec3 sky_int) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
    for(int i=0;i<40;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = abs(length(fragpos.xyz-spos.xyz));
		if(err < pow(length(vector)*1.85,1.15)){

                sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 20.0), 0.0, 1.0);
                    color = texture2D(composite, pos.st);
					float land = texture2D(gaux1, pos.st).g;
					land = float(land < 0.03);
					spos.z = mix(fragpos.z,2000.0*(0.4+clamp(sunVisibility+moonVisibility,0,1)*0.6),land);

					#ifdef Cloud
					if (land > 0.1){
						#ifdef ReflectWater_Cloud
						color.rgb = drawCloud(sky_int,calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE,fogclr),2);
						#else
						color.rgb = calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE,fogclr);
						#endif
						}
					else color.rgb = calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE,fogclr);
					#else
					color.rgb = calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE,fogclr);
					#endif

					color.a = 1.0;
                    color.a *= border;
                    break;
                }
				tvector -=vector;
                vector *=ref;


}
        vector *= inc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
    return color;
}

vec3 skyGradient (vec3 fposition, vec3 color, vec3 fogclr) {
	return (fogclr*3.+color)/4.;
}

vec4 raytraceGround(vec3 fragpos, vec3 normal,vec3 fogclr, vec3 sky_int) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));

    vec3 vector = Gstp * rvector;

    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;

	  for(int i=0;i<30;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
		if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = distance(fragpos.xyz,spos.xyz);
         if(err < pow(length(vector)*pow(length(tvector),0.11),1.1)*1.1){

                sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 20.0), 0.0, 1.0);
                    color = texture2D(composite, pos.st);
					float land = texture2D(gaux1, pos.st).g;
					land = float(land < 0.03);
					spos.z = mix(fragpos.z,2000.0*(0.4+clamp(sunVisibility+moonVisibility,0,1)*0.6),land);

					#ifdef Cloud
					if (land > 0.1){
						#ifdef ReflectWater_Cloud
						color.rgb = drawCloud(sky_int,calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE,fogclr),2);
						#else
						color.rgb = calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE,fogclr);
						#endif
						}
					else color.rgb = calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE,fogclr);
					#else
					color.rgb = calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE,fogclr);
					#endif

					color.a = 1.0;
                    color.a *= border;
                    break;
                }
				tvector -=vector;
                vector *=Gref;


}
        vector *= Ginc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
    return color;
}

//VL from Robobo1221
vec3 vlColor(vec3 fogcolor, vec3 color, vec2 pos) {

		float VolumeSample = texture2D(gdepth, pos.xy + vec2(0.0,0.0),2).r;
		VolumeSample += texture2D(gdepth, pos.xy + vec2(pw*2,0.0),2).r;
		VolumeSample += texture2D(gdepth, pos.xy + vec2(-pw*2,0.0),2).r;
		VolumeSample += texture2D(gdepth, pos.xy + vec2(0.0,ph*2),2).r;
		VolumeSample += texture2D(gdepth, pos.xy + vec2(0.0,-ph*2),2).r;
		VolumeSample /= 5;
		
		float iN = (VL_STRENGTH_NIGHT*moonVisibility);
		float iD = (VL_STRENGTH_DAY*TimeNoon);
		float iSSSR = (VL_STRENGTH_SUNSET_SUNRISE*(1-TimeNoon)*(1-moonVisibility));

		float i = (iN + iD + iSSSR);

		float eBS = mix(1.0,0.0,(pow(eyeBrightnessSmooth.y / 240.0f, 1.0f)));

		float Glow = pow(max(dot(normalize(fragpos),lightVector),0.0),2.5*15);
		float vlGlow = (1-Glow*-(2.5*(1-TimeNoon*-5)*(1+(TimeSunrise + TimeSunset)*15.)*(1-eBS))) * 0.5;

		float vlInside = ((eBS*10.0*VL_STRENGTH_INSIDE*(1-moonVisibility)));
		float vlInsideNight = ((eBS*10.0*VL_STRENGTH_INSIDE*(moonVisibility)));
		float vlFinalInside = (vlInside + vlInsideNight);

		vec3 vlDay = fogcolor * VL_STRENGTH_DAY * TimeNoon;
		vec3 vlNight = vec3(moonlight)*8 * VL_STRENGTH_NIGHT;
		vec3 vlSSSR = pow(vec3(fogcolor), vec3(1.25)) * (VL_STRENGTH_SUNSET_SUNRISE * (1 - TimeNoon) * (1 - moonVisibility));
		vec3 combined = (vlDay + vlNight + vlSSSR);

		vec3 vlcolor = combined;
			vlcolor = mix(vlcolor,pow(vlcolor,vec3(1.5)) * 2.2,(TimeSunrise + TimeSunset));
			vlcolor *= (1 + (vlFinalInside));

			vlcolor = color + vlcolor * VolumeSample / 5.0 * VL_MULT * (1-isEyeInWater) * (1-rainStrength) * (1-transition_fading);
			return vlcolor;
	}

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
	color.rgb = pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE;
	int land = int(matflag < 0.03);
	int iswater = int(matflag > 0.04 && matflag < 0.07);
	int reflectable = int(matflag > 0.08 && matflag < 0.15);
	int reflectopaque = int(matflag > 0.14 && matflag < 0.17);
	int ismetal = int(matflag > 0.48 && matflag < 0.52);
	int islava = int(matflag > 0.62 && matflag < 0.65);
	int hand  = int(matflag > 0.78 && matflag < 0.82);
	int particle  = int(matflag > 0.68 && matflag < 0.72);

	fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));
	vec3 fogpos  = nvec3(gbufferProjectionInverse * nvec4(vec3(texcoord.xy,texture2D(depthtex1,texcoord.xy).x) * 2.0 - 1.0));
	vec3 fogpos0  = nvec3(gbufferProjectionInverse * nvec4(vec3(texcoord.xy,texture2D(depthtex0,texcoord.xy).x) * 2.0 - 1.0));
	float cosT = dot(normalize(fragpos),upVec);
	float timebrightness = pow(abs(sin(time/12000*22/7)),0.5);
	timebrightness = timebrightness*timebrightness;

	float wldsky = abs(dimread);

	vec3 fogclr = getSkyColor(fragpos.xyz);
	vec3 wpos = vec3(gbufferModelViewInverse * vec4(fragpos,1.0));
	vec3 fogclrnoise = fogclr;
	if (dimread == 0){
		float fognoise = texture2D(noisetex,(wpos.xz+cameraPosition.xz)/8192+frametime*0.00075).r*4.0*pow(length(fragpos.xz),1.0/10.0);
		fogclrnoise = getSkyColor(fragpos.xyz+vec3(0.0,(fognoise + cameraPosition.y-72.0)*(1-isEyeInWater),0.0));
	}
	//fogclrnoise = pow(fogclrnoise*16*(0.25+night*3.75),vec3(5));
	
	fogpos.z = mix(fogpos.z,2000.0*(0.25+sunVisibility*0.75),land);
	fogpos0.z = mix(fogpos0.z,2000.0*(0.25+sunVisibility*0.75),land);
	float normalDotEye = dot(normal, normalize(fragpos));
	float fresnel = pow(1.0 + normalDotEye, 5.0);
	fresnel = clamp(fresnel*0.98+0.02,0,1);
	
	vec3 lc = mix(vec3(0.0),sunlight,sunVisibility)+mix(vec3(0.0),moonlight*90,moonVisibility);
	vec4 reflection = vec4(0.0);
	
	vec3 npos = normalize(fragpos);
	vec3 reflectedVector = reflect(normalize(fragpos), normalize(normal));
	reflectedVector = fragpos + reflectedVector * (2000.0-fragpos.z);
	
	vec3 skyc = getSkyColor(reflectedVector);
	vec3 sky_color = calcFog(reflectedVector,vec3(0),skyc)*clamp(sky_lightmap*16.0-12.0,0.0,1.0);
	#ifdef Cloud
	#ifdef ReflectWater_Cloud
	sky_color = mix(sky_color,drawCloud(reflectedVector,sky_color,2),clamp(sky_lightmap*16.0-12.0,0.0,1.0));
	#endif
	#endif


	if ((iswater > 0.9 && isEyeInWater == 0)) {
		lc *= mix(vec3(1.0),vec3(1.0,0.8,0.5),sunVisibility);
		#ifdef ReflectWater
		reflection = raytrace(fragpos,normal,skyc,reflectedVector);
		#endif
		reflection.rgb = clamp(mix(sky_color, reflection.rgb, reflection.a)+(color.a)*lc*pow(1.0-rainStrength,4)*128.0,vec3(0),vec3(1024));
		reflection.a = min(reflection.a,1.0);
		reflection.rgb = reflection.rgb*ReflectWater_Strength;
		color.rgb = fresnel*reflection.rgb + (1-fresnel)*color.rgb;
		}
	else if (land < 0.9 && hand < 0.1) {
		#ifdef Specular
		if (specmap*fresnel > 0.005) reflection = raytraceGround(fragpos, normal, skyc,reflectedVector);
		reflection.rgb = mix(sky_color, reflection.rgb, reflection.a);
		reflection.rgb = mix(reflection.rgb,reflection.rgb*normalize(color.rgb),0.0);
		reflection.rgb = reflection.rgb*3.;
		if (ismetal > 0.9){
			vec3 refcol = color.rgb*8.0; 
			reflection.rgb *= refcol;
			lc *= color.rgb*2.25+lc*0.25;
			}
		color.rgb = specmap*fresnel*reflection.rgb + (1-fresnel*specmap)*color.rgb;
		color.rgb += pow(color.a,1)*lc*specmap*(1.0-rainStrength)*Specular_Strength;
		#endif
		}
	
	if (isEyeInWater == 0){
		if (hand < 0.9){
			if (land < 0.9 && matflag < 0.98){
				if (reflectable < 0.9) color.rgb = calcFog(fogpos0.xyz,color.rgb,fogclrnoise);
				if (reflectable > 0.9 && reflectopaque < 0.9) color.rgb = calcConstFog2(fogpos.xyz,fogpos0.xyz,color.rgb,fogclr);
				if (reflectopaque > 0.9) color.rgb = calcConstFog1(fogpos0.xyz,color.rgb,fogclr);
				}
			else
				{
				color.rgb = calcSkyFog(fogpos.xyz,color.rgb,fogclr);
				if (isEyeInWater < 0.9) color.rgb = color.rgb + (color.rgb*color.rgb - 0.008)*0.7*(1-night);
				if (wldsky < 0.1){
					#ifdef Cloud
					if (cosT > 0 && land > 0.9) color.rgb = drawCloud(fragpos.xyz,color.rgb,1);
					#endif
					#ifdef Sky_Stars
					if (cosT > 0 && land > 0.9) color.rgb = drawStar(fragpos.xyz,color.rgb);
					#endif
					#ifdef RoundSunMoon
					if (land > 0.9) {
					color.rgb = drawSun(fragpos,color.rgb);
					color.rgb = drawMoon(fragpos,color.rgb);
					}
					#endif
					}
				}
			}
		}
	
	if (isEyeInWater == 1){
		if (iswater > 0.9 || reflectable > 0.9) color.rgb = calcSkyInWaterFog(fogpos.xyz,color.rgb,fogclr);
		if (land > 0.9) color.rgb = pow(watercolor,vec3(1.0/2.2));
		color.rgb = underwaterFog(fragpos,color.rgb,watercolor,wateropacity);
		}

	#ifdef Celshade
	float celborder = ceil(Celshade_Stroke*viewWidth/1280);
	float cdepth = clamp(ld(texture2D(depthtex0,texcoord.xy).r)/256*far,0,1)*4;
	
	float cdepthmask = 0;
	cdepthmask += clamp(ld(texture2D(depthtex0,texcoord.xy+vec2(pw*celborder,0)).r)/256*far,0,1);
	cdepthmask += clamp(ld(texture2D(depthtex0,texcoord.xy+vec2(-pw*celborder,0)).r)/256*far,0,1);
	cdepthmask += clamp(ld(texture2D(depthtex0,texcoord.xy+vec2(0,ph*celborder)).r)/256*far,0,1);
	cdepthmask += clamp(ld(texture2D(depthtex0,texcoord.xy+vec2(0,-ph*celborder)).r)/256*far,0,1);

	#ifdef Celshade_Out
	float cdeptho = (cdepth-cdepthmask);
	cdeptho = clamp(cdeptho,0,1/Celshade_Strength)*Celshade_Strength;
	cdeptho *= exp(-length(fragpos.xyz)/200)*(1-land)+land;
	cdeptho = 1-cdeptho;
	color.rgb = color.rgb*(isEyeInWater*0.7+cdeptho*(1-isEyeInWater*0.7)) + vec3(0.001);
	#endif

	#ifdef Celshade_In
	float cdepthi = (cdepthmask-cdepth);
	cdepthi = clamp(cdepthi,0,1/Celshade_Strength)*Celshade_Strength;
	cdepthi *= exp(-length(fragpos.xyz)/200)*(1-land)+land;
	cdepthi = 1-cdepthi;
	color.rgb = color.rgb*(isEyeInWater*0.7+cdepthi*(1-isEyeInWater*0.7)) + vec3(0.001);
	#endif

	#endif
	
	#ifdef BumpEdge
	vec3 nobump = color.rgb;
	float isbump = hand + land*(1-rainStrength);
	float bumpfog = 1-(exp(-pow(ld(texture2D(depthtex0, texcoord.st).r)/4*far,4.0)*4.0));
	float bumpfog2 = 1-(exp(-pow(ld(texture2D(depthtex0, texcoord.st).r)/128*far,4.0)*4.0));
	bumpfog = clamp(bumpfog - bumpfog2 + isbump,0,1);
	float bumpstr = EDGESTR;
	if (iswater < 0.9 && islava < 0.9){
	color.rgb = edgeshadow(color.rgb,bumpstr);
	color.rgb = color.rgb + edgerim(color.rgb,bumpstr) * (1+torch_lightmap);
	}

	color.rgb = color.rgb*bumpfog + nobump.rgb*(1-bumpfog);
	//color.rgb = color.rgb*0 + bumpfog;
	#endif
	
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos1 = tpos.xy/tpos.z;
	vec2 lightPos = pos1*0.5+0.5;
	float gr = 0.0;
	vec3 grC = vec3(0);

if (dimread == 0 && isEyeInWater == 0){
	#ifdef Godrays
		float truepos = sunPosition.z/abs(sunPosition.z);		//1 -> sun / -1 -> moon
		vec3 rainc = mix(vec3(1.),fogclr*1.5,rainStrength);
		float centerdist = (1-cdist(lightPos));
		vec3 lightColor = mix(sunlight*sunVisibility*rainc,pow((15.0-10.0*rainStrength)*moonlight,vec3(0.8))*moonVisibility*rainc,(truepos+1.0)/2.)/2;
		lightColor = mix(lightColor,vec3(length(lightColor))*(1.0+7.0*pow(rainStrength,2.0)),rainStrength);
		const int nSteps = NUM_SAMPLES;
		float blurScale = 0.02/nSteps;
		const int center = (nSteps-1)/2;
		vec3 blur = vec3(0.0);
		float tw = 0.0;
		const float sigma = 0.5;

		vec2 deltaTextCoord = normalize(texcoord.st - lightPos.xy)*blurScale;
		vec2 textCoord = texcoord.st - deltaTextCoord*center;

		float distx = texcoord.x*aspectRatio-lightPos.x*aspectRatio;
		float disty = texcoord.y-lightPos.y;
		float illuminationDecay = pow(max(1.0-sqrt((distx*distx)/raysize+(disty*disty)/raysize),0.0),2.0);
		
		if (illuminationDecay > 0){
			for(int i=0; i < nSteps ; i++) {
				textCoord += deltaTextCoord;

				float dist = (i-float(center))/center;
				float weight = exp(-(dist*dist)/(2.0*sigma));

				float sample = texture2D(gdepth, textCoord).r*weight;
				tw += weight;
				gr += sample;
				}
			gr *= 2.0-eyeBrightnessSmooth.y/240.0;
			grC = lightColor*exposure*(gr/tw)*(1.0 - rainStrength*0.8)*illuminationDecay * (1-isEyeInWater) * (1+centerdist*3)/(8*(2-transition_fading+night));
			color.rgb += grC.rgb;
			}
		
	#endif
	
	#ifdef VolLight
	float modCosT = pow(abs(cosT)*(cosT*0.45+0.55),1.5);
	vec3 vlcol = pow(vec3(0.1,0.35,1.0),vec3(mix(1.0/1.5,1.5,modCosT*eyeBrightnessSmooth.y/240.0)));
	vlcol = mix(sunlight,vlcol*0.5,eyeBrightnessSmooth.y/240.0);
	color.rgb = vlColor(vlcol, color.rgb, texcoord.st);
	#endif
	}

	float visiblesun = 0.0;
	float temp;
	float nb = 0;

//calculate sun occlusion (only on one pixel)
if (texcoord.x < 3.0*pw && texcoord.x < 3.0*ph) {
	for (int i = 0; i < 10;i++) {
		for (int j = 0; j < 10 ;j++) {
		temp = texture2D(gaux1,lightPos + vec2(pw*(i-5.0)*10.0,ph*(j-5.0)*10.0)).g;
		visiblesun +=  1.0-float(temp > 0.04) ;
		nb += 1;
		}
	}
	visiblesun /= nb;

}

color.rgb = pow(color.rgb/MAX_COLOR_RANGE,vec3(1.0/2.2));

/* DRAWBUFFERS:5 */
	gl_FragData[0] = vec4(color.rgb,visiblesun);
}
