#version 120
#extension GL_ARB_shader_texture_lod : enable 
#define MAX_COLOR_RANGE 48.0
/*
!! DO NOT REMOVE !!
BSL Shaders is derived from Chocapic13 v5 test 2

This code is from Chocapic13' shaders
Read the terms of modification and sharing before changing something below please !
!! DO NOT REMOVE !!
*/

/*
Disable an effect by putting "//" before "#define" when there is no number after
You can tweak the numbers, the impact on the shaders is self-explained in the variable's name or in a comment
*/

//ADJUSTABLE VARIABLES//

//SHADOW
	#define Shadow											//Casts shadow from sun / moon.
	
	#define ShadowFilter									//Shadow filtering. Improves shadow quality. Enable one only.
	//#define ShadowHQFilter								//Better shadow filtering. Costs performance. Enable one only.
	
	//#define ShadowShading									//Smaller shadow are less darker. You need to enable shadow.
		#define ShadowShadingStrength 0.3					//Amount of darkness reduction. [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
		#define ShadowShadingSpread 32.0					//Radius of shadow shading.[4.0 8.0 16.0 32.0 512.0 128.0]
	
	#define ShadowFix										//Completely removes shadow in dark areas. Fixes underground lighting.
	#define ShadowTranslucent								//Makes shadow visible at semi-transparent blocks. Also removes shadows from certain blocks. Shadow will be visible underwater. Use higher shadow map for better quality.
	//#define ShadowColor									//Shadows behind stained glass are colored.
	
	const int shadowMapResolution = 2048;					//Shadowmap resolution. Higher value costs performance. [1024 2048 4096 8192]
	const float shadowDistance = 256.0;						//Draw distance of shadow. [32.0 96.0 128.0 192.0 256.0 512.0]
	
//LIGHTING
	#define Lighting_SunlightVal 1.5						//Change sunlight strength. [0.5 1 1.5 2 2.5]
	#define Lighting_MoonlightVal 1							//Change moonlight strength. [0.5 1 1.5 2 2.5]
	float Lighting_Darkness = 0.2;					//Shadow darkness levels. Lower values mean darker shadow, 0.2 is default
	const float Lighting_Brightness = 0.6;					//Sky brightness levels. Lower values mean darker sky, 0.6 is default
	
	#define TorchColor_Original								//Yellow-orangeish torch color. Enable one only.
	//#define TorchColor_Bright								//White-orangeish torch color. Enable one only.
	//#define TorchColor_White								//White torch color. Enable one only.
	//#define TorchColor_End								//Purple torch color. Enable one only.
	//#define TorchColor_Water								//Blue torch color. Enable one only.
	//#define TorchColor_Leaf								//Green torch color. Enable one only.
	#define TorchStrength 8									//Torch light intensity. [0.5 1 2 4 8 16 32 512 128]
	
	#define SkylightBrightness 0.0							//Brightness in dark area. [0.0 0.1 0.2 0.3 0.4 0.5]
	
	#define Lighting_Attenuation 2.2

	#define EmissiveRecolor									//Recolors some emissive blocks with torch color. Disabling this while using some torch color may give weird results.
	#define DarkDesaturation								//Desaturates color at night or dark area.
	//#define Lighting_NoTexture							//Replaces texture with gray color.
	
	#define Lighting_TextureMult 1.0
	#define Lighting_FinalMult 1.0
	
//VISUAL
	//#define VolLight										//Light shafts viewable from any camera angle. Brightens sky. Thanks to Robobo1221.
		#define VolLight_Quality 1.0
		
	#define Godrays											//Light shafts around sun and moon.
		const float density = 0.7;			
		const int NUM_SAMPLES = 10;							//increase this for better quality at the cost of performance /10 is default
		const float grnoise = 1.0;							//amount of noise /1.0 is default
	
	//#define SSAO											//High quality ambient occlusion.
		#define SSAO_Side 4.0								//Set number of sides for ambient occlusion. Larger value means smoother edges. [4.0 6.0 8.0 10.0 12.0]
		#define SSAO_Depth 3.0								//Set number of layers for ambient occlusion. Larger value means smoother darkness. [3.0 6.0 9.0 12.0]
		#define SSAO_Size 40								//Set ambient occlusion size. [10 20 30 40 50 60]
		#define SSAO_Strength 1.0							//Set darkness level of ambient occlusion. [0.5 1.0 1.5 2.0 2.5 3.0]
		const float ssaorad = 1;
		const float ssaonoise = 1.0;
	
	#define EDO												//Low quality ambient occlusion.
		#define EDO_Size 30.0								//Set ambient occlusion size. [10.0 20.0 30.0 40.0 50.0 60.0]
		#define EDOPASS 3.0
		#define EDOSTR 0.7									
	
	//#define CelLighting									//Flattens torch light and sky light. Doesn't affect vanila smooth lighting.
	
	#define Gloss											//Specular replacement.
	
	//#define InverseTonemap								//Partially neutralize tonemap effect.
	
	//#define RoundSunMoon
	
	//#define WaterFoam										//EXPERIMENTAL. Creates foam around water edges.
	//#define WaterCaustic									//EXPERIMENTAL. Brightens water a bit. Also affected by light sources.
	
	//#define Watercolor_Vanila								//Pure texture based water. Only enable one.
	//#define Watercolor_Clear								//Clear-ish water. Only enable one.
	//#define Watercolor_Tropical							//Weak green-ish water. Only enable one.
	//#define Watercolor_Legacy								//Strong blue water. Only enable one.
	//#define Watercolor_Classic							//Weak light blue water. Only enable one.
	#define Watercolor_Original								//Strong dark blue water. Only enable one.
	
	#define WorldDimension 0								//The world dimension you're in. -1 : Nether | 0 : Overworld | 1 : End [0 -1 1]
	//#define WorldTimeAnimation							//Animate with world time.
	
	const float	sunPathRotation	= -40.0f;					//Determines sun/moon inclination. [-60.0f -40.0f -20.0f 0.0f 20.0f 40.0f 60.0f]

//ADJUSTABLE VARIABLES//



const float 	wetnessHalflife 		= 70.0f;
const float 	drynessHalflife 		= 70.0f;

const bool 		shadowHardwareFiltering = true;

const int 		noiseTextureResolution  = 1024;
#define SHADOW_MAP_BIAS 0.85

varying vec4 texcoord;

varying vec3 lightVector;
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 upVec;

varying vec3 sunlight;
varying vec3 moonlight;
varying vec3 ambient_color;

varying vec4 lightS;

varying float handItemLight;
varying float handItemMult;
varying float emissiveRecolor;
varying float eyeAdapt;

varying float SdotU;
varying float MdotU;
varying float sunVisibility;
varying float moonVisibility;

uniform sampler2D gcolor;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gnormal;
#ifdef Shadow
uniform sampler2DShadow shadow;
#ifdef ShadowColor
uniform sampler2DShadow shadowcolor;
uniform sampler2DShadow shadowtex1;
#endif
#endif
uniform sampler2D gaux1;
uniform sampler2D noisetex;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
#ifdef Shadow
uniform mat4 shadowProjection;
uniform mat4 shadowModelView;
#endif

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;

uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform ivec2 eyeBrightnessSmooth;
uniform int isEyeInWater;
uniform int worldTime;

vec3 convertScreenSpaceToWorldSpace(vec2 co, float depth) {
    vec4 fragposition = gbufferProjectionInverse * vec4(vec3(co, depth) * 2.0 - 1.0, 1.0);
    fragposition /= fragposition.w;
    return fragposition.xyz;
}

vec3 convertCameraSpaceToScreenSpace(vec3 cameraSpace) {
    vec4 clipSpace = gbufferProjection * vec4(cameraSpace, 1.0);
    vec3 NDCSpace = clipSpace.xyz / clipSpace.w;
    vec3 screenSpace = 0.5 * NDCSpace + 0.5;
    return screenSpace;
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float edepth(vec2 coord) {
	return texture2D(depthtex0,coord).z;
}
const float dimread = WorldDimension;
vec2 newtc = texcoord.xy;
vec3 sky_color = normalize(vec3(0.1, 0.35, 1.));

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;

vec3 aux = texture2D(gaux1, texcoord.st).rgb;
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0f - 1.0f;

#ifdef WorldTimeAnimation
float frametime = worldTime/20.0;
#else
float frametime = frameTimeCounter;
#endif

float handlight = handItemLight;

float modlmap = min(aux.b,0.9);
#ifdef CelLighting
float torch_lightmap = floor(pow(max(aux.b,0.0)*2.2,1.8)*4)/4;
#else
float torch_lightmap = (max((1.0/pow((1-modlmap)*16.0,2.0)-(1.0)/(16.0*16.0))*TorchStrength,0.0)*2.0*3 + pow(max(aux.b,0.0)*2.2,1.8)*TorchStrength/16)/4;
#endif

#ifdef TorchColor_Original
vec3 TorchColor = vec3(0.7,0.27,0.04);
#endif
#ifdef TorchColor_Bright
vec3 TorchColor = vec3(0.7,0.35,0.15);
#endif
#ifdef TorchColor_White
vec3 TorchColor = vec3(0.4);
#endif
#ifdef TorchColor_End
vec3 TorchColor = vec3(0.65,0.27,0.65);
#endif
#ifdef TorchColor_Water
vec3 TorchColor = vec3(0.1,0.35,1.0);
#endif
#ifdef TorchColor_Leaf
vec3 TorchColor = vec3(0.15,0.75,0.15);
#endif

#ifdef Watercolor_Vanila
vec3 watercolor = vec3(0.02,0.08,0.28);
float wateropacity = 0.2;
#endif

#ifdef Watercolor_Clear
vec3 watercolor = vec3(0.02,0.08,0.14);
float wateropacity = 0.2;
#endif

#ifdef Watercolor_Tropical
vec3 watercolor = vec3(0.1,0.6,0.6);
float wateropacity = 0.4;
#endif

#ifdef Watercolor_Legacy
vec3 watercolor = vec3(0.0,0.3,0.7);
float wateropacity = 0.7;
#endif

#ifdef Watercolor_Classic
vec3 watercolor = vec3(0.1,0.4,0.7);
float wateropacity = 0.4;
#endif

#ifdef Watercolor_Original
vec3 watercolor = vec3(0.02,0.06,0.14);
float wateropacity = 0.8;
#endif

//float torch_lightmap = (1.0-exp(-aux.b*light_jitter/TORCH_ATTEN))*TorchStrength;

#ifdef CelLighting
float sky_lightmap = floor(pow(aux.r,Lighting_Attenuation)*8)/8;
#else
float sky_lightmap = pow(aux.r,Lighting_Attenuation);
#endif

float iswet = wetness*pow(sky_lightmap,5.0)*sqrt(0.5+max(dot(normal,upVec),0.0));

	
//position distribution for shadow sampling		
const vec2 shadow_offsets[60] = vec2[60]  (  vec2( 0.0000, 0.2500 ),
									vec2( -0.2165, 0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2( 0.2165, -0.1250 ),
									vec2( 0.2165, 0.1250 ),
									vec2( 0.0000, 0.5000 ),
									vec2( -0.2500, 0.4330 ),
									vec2( -0.4330, 0.2500 ),
									vec2( -0.5000, 0.0000 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.2500, -0.4330 ),
									vec2( -0.0000, -0.5000 ),
									vec2( 0.2500, -0.4330 ),
									vec2( 0.4330, -0.2500 ),
									vec2( 0.5000, -0.0000 ),
									vec2( 0.4330, 0.2500 ),
									vec2( 0.2500, 0.4330 ),
									vec2( 0.0000, 0.7500 ),
									vec2( -0.2565, 0.7048 ),
									vec2( -0.4821, 0.5745 ),
									vec2( -0.51295, 0.3750 ),
									vec2( -0.7386, 0.1302 ),
									vec2( -0.7386, -0.1302 ),
									vec2( -0.51295, -0.3750 ),
									vec2( -0.4821, -0.5745 ),
									vec2( -0.2565, -0.7048 ),
									vec2( -0.0000, -0.7500 ),
									vec2( 0.2565, -0.7048 ),
									vec2( 0.4821, -0.5745 ),
									vec2( 0.51295, -0.3750 ),
									vec2( 0.7386, -0.1302 ),
									vec2( 0.7386, 0.1302 ),
									vec2( 0.51295, 0.3750 ),
									vec2( 0.4821, 0.5745 ),
									vec2( 0.2565, 0.7048 ),
									vec2( 0.0000, 1.0000 ),
									vec2( -0.2588, 0.9659 ),
									vec2( -0.5000, 0.8660 ),
									vec2( -0.7071, 0.7071 ),
									vec2( -0.8660, 0.5000 ),
									vec2( -0.9659, 0.2588 ),
									vec2( -1.0000, 0.0000 ),
									vec2( -0.9659, -0.2588 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.7071, -0.7071 ),
									vec2( -0.5000, -0.8660 ),
									vec2( -0.2588, -0.9659 ),
									vec2( -0.0000, -1.0000 ),
									vec2( 0.2588, -0.9659 ),
									vec2( 0.5000, -0.8660 ),
									vec2( 0.7071, -0.7071 ),
									vec2( 0.8660, -0.5000 ),
									vec2( 0.9659, -0.2588 ),
									vec2( 1.0000, -0.0000 ),
									vec2( 0.9659, 0.2588 ),
									vec2( 0.8660, 0.5000 ),
									vec2( 0.7071, 0.7071 ),
									vec2( 0.5000, 0.8660 ),
									vec2( 0.2588, 0.9659 ));					

float Blinn_Phong(vec3 ppos, vec3 lvector, vec3 normal,float fpow, float gloss, float visibility, float glossmult)  {
	vec3 lightDir = vec3(lvector);
	
	vec3 surfaceNormal = normal;
	float cosAngIncidence = dot(surfaceNormal, lightDir);
	cosAngIncidence = clamp(cosAngIncidence, 0.0, 1.0);
	
	vec3 viewDirection = normalize(-ppos);
	
	vec3 halfAngle = normalize(lightDir + viewDirection);
	float blinnTerm = dot(surfaceNormal, halfAngle);
	
	float normalDotEye = dot(normal, normalize(ppos));
	float fresnel = clamp(pow(1.0 + normalDotEye, 5.0),0.0,1.0);
	fresnel = fresnel*0.85 + 0.15 * (1.0-fresnel);
	float pi = 3.1415927;
	float n =  pow(2.0,gloss*glossmult);
	return (pow(blinnTerm, n )*((n+8.0)/(8*pi)))*visibility;
}

float getnoise(vec2 pos) {
	return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));
}

vec3 inverseUncharted2Tonemap(vec3 x) {
	float A = 1.0;
	float B = 0.37;
	float C = 0.1;
	float D = 0.2;		
	float E = 0.02;
	float F = 0.3;
	vec3 y = x;
	y += E/F;
	vec3 y1 = (y-D*E)/(A*y+C*B);
	vec3 y2 = (y-D*F)/(A*y+B);
	y = y1*y2*pow(length(x),0.2);
	return y;
	//return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}

#ifdef EDO
float getdist(float rng) {
	return 1-clamp(ld(texture2D(depthtex0,texcoord.xy).r)/rng*far,0,1);
}

vec3 edo(vec3 clrr) {
	//edge detect
	float total = 0;
	float d = edepth(newtc.xy);
	float dtresh = 1/(far-near)/50.0;
	vec4 dc = vec4(d,d,d,d);
	vec4 sa;
	vec4 sb;
	
	float dist = (getdist(32)*2+getdist(512))/3;
	float noise = 1+getnoise(texcoord.xy)*3/EDOPASS;
	float border = floor(EDO_Size/EDOPASS*viewWidth/1280);
	float mod = border*dist*noise;
	
	float e = 0;
	
	for (int i = 0; i < EDOPASS; i++) {
	sa.x = edepth(newtc.xy + vec2(-pw,-ph)*mod*i);
	sa.y = edepth(newtc.xy + vec2(pw,-ph)*mod*i);
	sa.z = edepth(newtc.xy + vec2(-pw,0.0)*mod*i);
	sa.w = edepth(newtc.xy + vec2(0.0,ph)*mod*i);
	
	//opposite side samples
	sb.x = edepth(newtc.xy + vec2(pw,ph)*mod*i);
	sb.y = edepth(newtc.xy + vec2(-pw,ph)*mod*i);
	sb.z = edepth(newtc.xy + vec2(pw,0.0)*mod*i);
	sb.w = edepth(newtc.xy + vec2(0.0,-ph)*mod*i);
	
	vec4 dd = (2.0* dc - sa - sb) - dtresh;
	dd = vec4(step(dd.x,0.0),step(dd.y,0.0),step(dd.z,0.0),step(dd.w,0.0));
	
	e = clamp(dot(dd,vec4(0.25f)),0.0,1.0);
	e = e*(dist)+1-dist;
	total += e;
	}
	total /= EDOPASS;
	return clrr * (1-EDOSTR) + clrr*total * EDOSTR;
}
#endif

float fx(float x) {
return (2 *(-sin(x)*sin(x)*sin(x) + 3*sin(x) + 3*x)) / 3;

}
float fx2(float x) {
return (-cos(x) * sin(x) + 6*x) / 2;

}

float subSurfaceScattering(vec3 pos, float N) {

return pow(max(dot(lightVector,normalize(pos)),0.0),N)*(N+1)/6.28;

}

float PosDot(vec3 v1,vec3 v2) {
return max(dot(v1,v2),0.0);
}

float waterH(vec3 posxz) {
vec3 waterpos = posxz;

float speed = 2;
float size = 0.5;

float noise = 1.0;
float noisesize = 32*size;
float noiseweight = 0;
float noiseneg = 1;

float noisea = 1;
for (int i = 0; i < 2; i++) {
noisea += texture2D(noisetex,vec2(waterpos.x,waterpos.z)/noisesize*0.1+vec2(frametime/1000*speed,0)).r*i*noiseneg;
noiseweight += i;
noiseneg *= -1;
noisesize /= 2;
}
noisea /= noiseweight;

noisesize = 16*size;
noiseweight = 0;

float noiseb = 1;
for (int i = 0; i < 2; i++) {
noiseb += texture2D(noisetex,vec2(-waterpos.x,waterpos.z)/noisesize*0.1+vec2(0,frametime/1000*speed)).r*i*noiseneg;
noiseweight += i;
noiseneg *= -1;
noisesize /= 2;
}
noiseb /= noiseweight;

noisesize = 512*size;
noiseweight = 0;

float noisec = 1;
for (int i = 0; i < 2; i++) {
noisec += texture2D(noisetex,vec2(posxz.x,-posxz.z)/noisesize*0.1+vec2(-frametime/1000*speed,0)).r*i*noiseneg;
noiseweight += i;
noiseneg *= -1;
noisesize /= 2;
}
noisec /= noiseweight;

noisesize = 48*size;
noiseweight = 0;

float noised = 1;
for (int i = 0; i < 2; i++) {
noised += texture2D(noisetex,vec2(-posxz.x,-posxz.z)/noisesize*0.1+vec2(0,-frametime/1000*speed)).r*i*noiseneg;
noiseweight += i;
noiseneg *= -1;
noisesize /= 2;
}
noised /= noiseweight;

noise = (noisea*noiseb + noiseb*noisec + noisec*noised + noised*noisea) * (1- noisea*noiseb*noisec*noised)/2;

float wave = 0;
	wave = sin(posxz.x/3+frametime/1.4)*cos(posxz.z/3+frametime/1.4)*sin(frametime/10);
	wave += sin(posxz.x/5+frametime/2.2)*cos(posxz.z/5+frametime/2.2)*cos(frametime/10);

return (noise+wave);
}

//VL from Robobo1221
float distx(float dist){
	return (((dist - near) * far) / ((far - near) * dist));
}

float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float find_closest(vec2 pos, const float sample)
{
 const int ditherPattern[64] = int[64](
  0, 32, 8, 40, 2, 34, 10, 42, /* 8x8 Bayer ordered dithering */
  48, 16, 56, 24, 50, 18, 58, 26, /* pattern. Each input pixel */
  12, 44, 4, 36, 14, 46, 6, 38, /* is scaled to the 0..63 range */
  60, 28, 52, 20, 62, 30, 54, 22, /* before looking in this table */
  3, 35, 11, 43, 1, 33, 9, 41, /* to determine the action. */
  51, 19, 59, 27, 49, 17, 57, 25,
  15, 47, 7, 39, 13, 45, 5, 37,
  63, 31, 55, 23, 61, 29, 53, 21);

 vec2 positon = vec2(0.0f);
      positon.x = floor(mod(texcoord.s * viewWidth, 8.0f));
	  positon.y = floor(mod(texcoord.t * viewHeight, 8.0f));

	int dither = ditherPattern[int(positon.x) + int(positon.y) * 8];

	return float(dither) / 64.0f;
}

float dynamicExposure()
{
		return mix(1.0,0.0,(pow(eyeBrightnessSmooth.y / 240.0f, 3.0f)));
}

float GetVolumetricRays(float pixeldepth) {

	///////////////////////Setting up functions///////////////////////

		float rays;

		float Quality = 6.0 / VolLight_Quality;
		float steps = Quality;

		float ditherPattern = find_closest(texcoord.st, steps);
		ditherPattern *= steps;

		float maxDist = (256.0);
		float minDist = (0.01);
			minDist += ditherPattern;

		float weight = (maxDist / steps);

		vec2 pushback = vec2(0.001, -0.001);	// Fixes light leakage from walls

		for (minDist; minDist < maxDist;) {

		///////////////////////MAKING VL NOT GO THROUGH WALLS///////////////////////

			if (getDepth(pixeldepth) < minDist){
				break;
			}

		///////////////////////Getting worldpositon///////////////////////

			vec4 fragpos = nvec4(convertScreenSpaceToWorldSpace(texcoord.st, distx(minDist)) * 1.0);
			vec4 worldposition = vec4(gbufferModelViewInverse * fragpos);

		///////////////////////Converting ScreenSpace to ShadowSpace///////////////////////

			worldposition = (shadowModelView * worldposition);
			worldposition = (shadowProjection * worldposition);
			worldposition /= worldposition.w;

		///////////////////////Rescaling ShadowMaps///////////////////////

		float distb = sqrt(worldposition.x * worldposition.x + worldposition.y * worldposition.y);
		float distortFactor = (1.0f - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
		worldposition.xy *= 1.0f / distortFactor;
		worldposition = worldposition * 0.5f + 0.5f;

			vec3 pos = worldposition.rgb;

		///////////////////////Projecting shadowmaps on a linear depth plane///////////////////////

			rays += (shadow2D(shadow, vec3(pos.rg, pos.b + pushback.r)).z);

			minDist = minDist + steps;
	}

	///////////////////////Returning the program///////////////////////

		rays /= weight;
		rays *= 0.5;

		return mix(rays, clamp(rays * 2.5, 0.0, 0.1), dynamicExposure());
		//return rays;
}

//////////////////////////////VOID MAIN//////////////////////////////

void main() {

	vec2 newtc = texcoord.xy;
	//unpack material flags
	float land = float(aux.g > 0.04);								//>0.04
	float iswater = float(aux.g > 0.04 && aux.g < 0.07);			//0.05
	float reflectable = float(aux.g > 0.08 && aux.g < 0.12);		//0.1
	float reflectnogloss = float(aux.g > 0.12 && aux.g < 0.14);		//0.13
	float reflectopaque = float(aux.g > 0.14 && aux.g < 0.17);		//0.15
	float translucent = float(aux.g > 0.38 && aux.g < 0.42);		//0.4
	float ismetal = float(aux.g > 0.48 && aux.g < 0.52);			//0.5
	float emissive = float(aux.g > 0.58 && aux.g < 0.63);			//0.6
	float emissivecolored = float(aux.g > 0.61 && aux.g < 0.65);	//0.63
	float islava = float(aux.g > 0.67 && aux.g < 0.69);				//0.68
	float particle = float(aux.g > 0.68 && aux.g < 0.72);			//0.7
	float hand = float(aux.g > 0.78 && aux.g < 0.82);				//0.8
	//float entity = float(aux.g > 0.88 && aux.g < 0.92);			//0.9
	float shading = 0.0f;
	float shadefix = 1.0;
	float spec = 0.0;
	
	#ifdef ShadowTranslucent
	float pixeldepth = 0;
	if(iswater > 0.9 || hand > 0.9 || reflectopaque > 0.9) pixeldepth = texture2D(depthtex0,texcoord.xy).x;
	else pixeldepth = texture2D(depthtex1,texcoord.xy).x;
	#else
	float pixeldepth = texture2D(depthtex0,texcoord.xy).x;
	#endif
	
	float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/500.0,0.0,1.0)-clamp((time-13500.0)/500.0,0.0,1.0) + clamp((time-22500.0)/500.0,0.0,1.0)-clamp((time-23500.0)/500.0,0.0,1.0));	//fading between sun/moon shadows
	float night = clamp((time-13000.0)/500.0,0.0,1.0)-clamp((time-22500.0)/500.0,0.0,1.0);
	
	float timebrightness = pow(abs(sin(time/12000*22/7)),2.0);
	
	vec3 nsunlight = normalize(mix(pow(sunlight,vec3(2.2)),vec3(0.25,0.3,0.4),rainStrength));
	sky_color = normalize(mix(sky_color,vec3(0.25,0.3,0.4),rainStrength)); //normalize colors in order to don't change luminance
	
	#ifdef InverseTonemap
	Lighting_Darkness = max(Lighting_Darkness-0.1,0.0);
	#endif
	
	float fresnel_pow = 5.0;
	
	vec3 color = texture2D(gcolor, newtc.st).rgb + vec3(0.001);
	color = pow(color,vec3(2.2))*(1.0+translucent*0.3)*Lighting_TextureMult;
	
	#ifdef EmissiveRecolor
	if (hand > 0.9 && emissiveRecolor > 0.9){
		float ec = clamp(pow(length(color),1.4),0,1);
		color = clamp(ec*pow(TorchColor,vec3(1.6))+ec/4,vec3(0),vec3(1));
		}
	#endif
	if (hand > 0.9){
		color *= 1+handItemMult*4;
		handlight = handItemMult;
		}
		
	float NdotL = dot(lightVector,normal);
	float NdotUp = dot(normal,upVec);
	
	vec4 fragposition = gbufferProjectionInverse * vec4(newtc.s * 2.0f - 1.0f, newtc.t * 2.0f - 1.0f, 2.0f * pixeldepth - 1.0f, 1.0f);
	fragposition /= fragposition.w;
	
		vec4 worldposition = vec4(0.0);
		vec4 worldpositionraw = vec4(0.0);
		worldposition = gbufferModelViewInverse * fragposition;	
		float xzDistanceSquared = worldposition.x * worldposition.x + worldposition.z * worldposition.z;
		float yDistanceSquared  = worldposition.y * worldposition.y;
		worldpositionraw = worldposition;
		
	
	vec3 uPos = vec3(0.0);
	vec3 refract = vec3(0.0);
	vec3 posxz = worldposition.xyz+cameraPosition;
	posxz.x += sin(posxz.z+frametime)*0.4;
	posxz.z += cos(posxz.x+frametime*0.5)*0.4;
	float h0 = 0.0;
	float h1 = 0.0;
	float h2 = 0.0;
	float h3 = 0.0;
	float h4 = 0.0;
	float xDelta = 0.0;
	float yDelta = 0.0;
	float deltaPos = 0.4;
	
	if (iswater > 0.9) {
	h0 = waterH(posxz);
	h1 = waterH(posxz + vec3(deltaPos,0.0,0.0));
	h2 = waterH(posxz + vec3(-deltaPos,0.0,0.0));
	h3 = waterH(posxz + vec3(0.0,0.0,deltaPos));
	h4 = waterH(posxz + vec3(0.0,0.0,-deltaPos));
	
	xDelta = ((h1-h0)+(h0-h2))/deltaPos;
	yDelta = ((h3-h0)+(h0-h4))/deltaPos;

	
	float refMult = (0.0005-dot(normal,normalize(fragposition).xyz)*0.0015)*2;
	
	refract = normalize(vec3(xDelta,yDelta,1.0-xDelta*xDelta-yDelta*yDelta));
	vec4 rA = texture2D(gcolor, newtc.st + refract.xy*refMult);
	rA.rgb = pow(rA.rgb,vec3(2.2));
	vec4 rB = texture2D(gcolor, newtc.st);
	rB.rgb = pow(rB.rgb,vec3(2.2));
	float mask = texture2D(gaux1, newtc.st + refract.xy*refMult).g;
	mask =  float(mask > 0.04 && mask < 0.07)*(1-isEyeInWater);
	newtc = (newtc.st + refract.xy*refMult)*mask + texcoord.xy*(1-mask);
	float uDepth = texture2D(depthtex1,newtc.xy).x;
	color.rgb = pow(texture2D(gcolor,newtc.xy).rgb,vec3(2.2));
	uPos  = nvec3(gbufferProjectionInverse * nvec4(vec3(newtc.xy,uDepth) * 2.0 - 1.0));	
	}
	
	
	if (land > 0.9) {
		#ifdef Shadow
		float dist = length(fragposition.xyz);
		float distof = clamp(1.0-dist/shadowDistance,0.0,1.0);
		float distof2 = clamp(1.0-pow(dist/(shadowDistance*0.75),2.0),0.0,1.0);
		//float shadow_fade = clamp(distof*12.0,0.0,1.0);
		float shadow_fade = sqrt(clamp(1.0 - xzDistanceSquared / (shadowDistance*shadowDistance*0.5), 0.0, 1.0) * clamp(1.0 - yDistanceSquared / (shadowDistance*shadowDistance*0.5), 0.0, 1.0));

		
		/*--reprojecting into shadow space --*/
		worldposition = shadowModelView * worldposition;
		float comparedepth = abs(worldposition.z);
		worldposition = shadowProjection * worldposition;
		worldposition /= worldposition.w;
		float distb = sqrt(worldposition.x * worldposition.x + worldposition.y * worldposition.y);
		float distortFactor = (1.0f - SHADOW_MAP_BIAS) + distb * SHADOW_MAP_BIAS;
		worldposition.xy *= 1.0f / distortFactor;
		worldposition = worldposition * 0.5f + 0.5f;
		/*---------------------------------*/
		
		
		float step = 0.625/shadowMapResolution*(1.0+rainStrength*5.0);
		//shadow_fade = 1.0-clamp((max(abs(worldposition.x-0.5),abs(worldposition.y-0.5))*2.0-0.9),0.0,0.1)*10.0;
		
		float NdotL = dot(normal, lightVector);
		float altsfix = max(translucent,reflectable-reflectopaque);
			  shadefix = clamp(NdotL*2*(1-altsfix) + altsfix,0,1);
		float diffthresh = (pow(distortFactor*1.2,2.0)*(0.5/128.0)*(tan(acos(abs(NdotL)))) + (0.05/128.0))*(1.0+iswater*2.0);
		diffthresh = mix(diffthresh,0.0005,translucent);
		
		if (dimread == 0){
		if (comparedepth > 0.01 &&	worldposition.s < 0.99 && worldposition.s > 0.01 && worldposition.t < 0.99 && worldposition.t > 0.01 ) {
			if (NdotL < 0.0 && altsfix < 0.1){
					shading = 0.0;
				}
			
			else {
			#ifdef ShadowTranslucent
			step = 0.625/shadowMapResolution*(1.0+rainStrength*5.0+altsfix*2.0);
			#else
			step = 0.625/shadowMapResolution*(1.0+rainStrength*5.0);
			#endif
			
			#ifdef ShadowHQFilter
			float weight = 0.0;
			float totalweight = 0.0;
			float sigma = 0.25;
			float A = 1.0/sqrt(2.0*3.14159265359*sigma);
			
			for(int i = 0; i < 60; i++){
					float dist = length(shadow_offsets[i]);
					float weight = A*exp(-(dist*dist)/(2.0*sigma));
					shading += shadow2D(shadow,vec3(worldposition.st + shadow_offsets[i]*step, worldposition.z-diffthresh*(2.0-weight))).x;
					totalweight += 1;
				}
			shading /= totalweight;
			#else
			#ifdef ShadowFilter
			shading  = shadow2D(shadow,vec3(worldposition.st, worldposition.z-diffthresh)).x;
			shading += shadow2D(shadow,vec3(worldposition.st + vec2(step,0), worldposition.z-diffthresh)).x;
			shading += shadow2D(shadow,vec3(worldposition.st + vec2(-step,0), worldposition.z-diffthresh)).x;
			shading += shadow2D(shadow,vec3(worldposition.st + vec2(0,step), worldposition.z-diffthresh)).x;
			shading += shadow2D(shadow,vec3(worldposition.st + vec2(0,-step), worldposition.z-diffthresh)).x;
			shading += shadow2D(shadow,vec3(worldposition.st + vec2(step,step)*0.7, worldposition.z-diffthresh)).x;
			shading += shadow2D(shadow,vec3(worldposition.st + vec2(-step,step)*0.7, worldposition.z-diffthresh)).x;
			shading += shadow2D(shadow,vec3(worldposition.st + vec2(step,-step)*0.7, worldposition.z-diffthresh)).x;
			shading += shadow2D(shadow,vec3(worldposition.st + vec2(-step,-step)*0.7, worldposition.z-diffthresh)).x;
			shading = shading/9.0;
			#else
			shading  = shadow2D(shadow,vec3(worldposition.st, worldposition.z-diffthresh)).x;
			#endif
			#endif
			
			shading = shading*transition_fading;
			}
			
			#ifdef ShadowFix
			float shadowfixarea = clamp(pow(1-sky_lightmap*4,2.2)*4,0.0,1.0);
			shading *= clamp(eyeBrightnessSmooth.y/120.0-1.0,0.0,1.0)*shadowfixarea + (1-shadowfixarea);
			#endif
		}
		
		else shading = 1.0;
		}
		
		float wldfade = 1.0;
		if (dimread == -1 || dimread == 1) wldfade = 0.0;
		shading = shading * shadow_fade + (1-shadow_fade)*wldfade;
		#else
			#ifdef CelLighting
			shading = floor(clamp((sky_lightmap-0.8)*1024,0,1))*transition_fading;
			#else
			shading = clamp((sky_lightmap-0.8)*7,0,1)*transition_fading;
			#endif
		#endif
		
		if (particle > 0.9) shading = sky_lightmap;
		if (emissivecolored > 0.9) shading *= 0.5;
		
		float shadowshading = 0;
		#ifdef Shadow
		#ifdef ShadowShading
		step = ShadowShadingSpread/shadowMapResolution*(1.0+rainStrength*5.0);
		//diffthresh = 0.0018f * diffthresh * (0.5+(1.0-NdotL)*5.0*(1.0-translucent));
		float weight;
		float totalweight = 0.0;
		float sigma = 0.25;
		float A = 1.0/sqrt(2.0*3.14159265359*sigma);
		
		for(int i = 0; i < 60; i++){
			float dist = length(shadow_offsets[i]);
			float weight = A*exp(-(dist*dist)/(2.0*sigma));
			shadowshading += shadow2D(shadow,vec3(worldposition.st + shadow_offsets[i]*step, worldposition.z-diffthresh*(2.0-weight))).x;
			totalweight += 1;
			}
		shadowshading /= totalweight;
		shadowshading *= ShadowShadingStrength;
		#endif
		#endif
			
		float ao = 1.0;
		#ifdef SSAO
		
		if (land > 0.9 && iswater < 0.9 && hand < 0.9 && particle < 0.9) {
			float pi = 3.1415927;
			vec3 norm = texture2D(gnormal,texcoord.xy).rgb*2.0-1.0;
			float aopixeldepth = texture2D(depthtex0,texcoord.xy).x;
			vec3 projpos = convertScreenSpaceToWorldSpace(texcoord.xy,aopixeldepth); 
			vec2 noiseAO = vec2(getnoise(texcoord.xy),getnoise(vec2(texcoord.x,-texcoord.y)))*2-1;
			
			float rprogress = 0.0;
			float sprogress = 1.0;
			ao = 0.0;
		
			float aosize = SSAO_Size*pw*viewWidth/1280;
			float projrad = clamp(distance(convertCameraSpaceToScreenSpace(projpos + vec3(ssaorad,ssaorad,ssaorad)).xy,texcoord.xy),aosize/2,aosize);
			noiseAO = noiseAO*projrad/(SSAO_Depth*sqrt(SSAO_Side))*viewWidth/1280*ssaonoise;
			
				for (int i = 0; i < SSAO_Depth; i++) {
					for (int j = 0; j < SSAO_Side; j++) {
						vec2 samplecoord = vec2(cos(rprogress*pi/180),sin(rprogress*pi/180))*(sprogress*projrad*vec2(1,aspectRatio)) + texcoord.xy + noiseAO;
						float sample = texture2D(depthtex1,samplecoord).x;
						vec3 sprojpos = convertScreenSpaceToWorldSpace(samplecoord,sample);
						float angle = pow(min(1.0-dot(norm,normalize(sprojpos-projpos)),1.0),2.0);
						float dist = pow(min(abs(ld(sample)-ld(aopixeldepth)),0.015)/0.015,2.0);
						float temp = min(dist+angle,1.0);
						ao += pow(temp,3.0);
						rprogress += 360/SSAO_Side;
					}
					sprogress = (i+1)/SSAO_Depth;
					rprogress += 90/SSAO_Side;
				}

				ao /= SSAO_Side*SSAO_Depth;
				ao = pow(ao,SSAO_Strength);
			}
		#endif
		
		vec3 npos = normalize(fragposition.xyz);

		float diffuse = max(dot(lightVector,normal),0.0);
		
		diffuse = mix(diffuse,1.0,translucent*0.3);
		float sss = 0;
		#ifdef Shadow
		sss = subSurfaceScattering(fragposition.xyz,30.0)*Lighting_SunlightVal*2.0;
		sss = (mix(0.0,sss,max(shadow_fade-0.5,0.0)*2.0)*0.5+0.5)*translucent;
		#endif
		
		float handLight = (handlight*5)/pow(1.0+length(fragposition.xyz/2.2),2.0)*sqrt(dot(normalize(fragposition.xyz), -normal)*0.5+0.51);
		#ifdef CelLighting
		handLight = floor(handLight*4)/4;
		#endif
		
		//Apply different lightmaps to image
		shading *= 1-isEyeInWater;
		float lmshading = shading*shadefix+shadowshading*(1-shading);
		vec3 colshading = vec3(lmshading);
		float cshadingmult = 1.0;
		#ifdef ShadowColor
		#ifdef ShadowHQFilter
		for(int i = 0; i < 60; i++){
			colshading += shadow2D(shadowcolor,vec3(worldposition.st+shadow_offsets[i]*step, worldposition.z-diffthresh)).rgb;
			}
		colshading /= 60;
		
		for(int i = 0; i < 60; i++){
			cshadingmult += shadow2D(shadowtex1,vec3(worldposition.st+shadow_offsets[i]*step, worldposition.z-diffthresh)).r;
			}
		cshadingmult /= 60;
		#else
		#ifdef ShadowFilter
		colshading = shadow2D(shadowcolor,vec3(worldposition.st, worldposition.z-diffthresh)).rgb;
		colshading+= shadow2D(shadowcolor,vec3(worldposition.st + vec2(step,0), worldposition.z-diffthresh)).rgb;
		colshading+= shadow2D(shadowcolor,vec3(worldposition.st + vec2(-step,0), worldposition.z-diffthresh)).rgb;
		colshading+= shadow2D(shadowcolor,vec3(worldposition.st + vec2(0,step), worldposition.z-diffthresh)).rgb;
		colshading+= shadow2D(shadowcolor,vec3(worldposition.st + vec2(0,-step), worldposition.z-diffthresh)).rgb;
		colshading /= 5.0;
		
		cshadingmult = shadow2D(shadowtex1,vec3(worldposition.st, worldposition.z-diffthresh)).r;
		cshadingmult+= shadow2D(shadowtex1,vec3(worldposition.st + vec2(step,0), worldposition.z-diffthresh)).r;
		cshadingmult+= shadow2D(shadowtex1,vec3(worldposition.st + vec2(-step,0), worldposition.z-diffthresh)).r;
		cshadingmult+= shadow2D(shadowtex1,vec3(worldposition.st + vec2(0,step), worldposition.z-diffthresh)).r;
		cshadingmult+= shadow2D(shadowtex1,vec3(worldposition.st + vec2(0,-step), worldposition.z-diffthresh)).r;
		cshadingmult = cshadingmult / 5.0;
		#else
		colshading = shadow2D(shadowcolor,vec3(worldposition.st, worldposition.z-diffthresh)).rgb;
		
		cshadingmult = shadow2D(shadowtex1,vec3(worldposition.st, worldposition.z-diffthresh)).r;
		#endif
		#endif
		cshadingmult *= mix(NdotL,1.0,reflectable-reflectopaque)*(1-reflectopaque);
		
		colshading = mix(colshading*(4.0-2.0*(reflectable-reflectopaque))*cshadingmult,vec3(1),lmshading);
		#endif
		
		vec3 light_col =  mix(pow(sunlight,vec3(2.2)),moonlight*2*Lighting_MoonlightVal,moonVisibility)*(eyeAdapt*2)*(1-rainStrength*0.8) * (1-moonVisibility*0.8) * (1+lmshading)/2 * Lighting_SunlightVal;
		light_col = mix(light_col,vec3(length(light_col))*0.3,rainStrength*0.9);
		vec3 Sunlight_lightmap = light_col*colshading*(1.0-rainStrength*0.95)*Lighting_SunlightVal *diffuse*transition_fading;

		//underwater position
		vec3 uVec = fragposition.xyz-uPos;
		float UNdotUP = abs(dot(normalize(uVec),normal));
		float depth = length(uVec)*UNdotUP;
		float sky_absorbance = mix(mix(1.0,exp(-depth/2.5),iswater),1.0,isEyeInWater);
		
		#ifdef WaterFoam
		if (iswater > 0.9){
		vec3 posxz1 = posxz * 0.5;
		h0 = waterH(posxz1);
		h1 = waterH(posxz1 + vec3(deltaPos,0.0,0.0));
		h2 = waterH(posxz1 + vec3(-deltaPos,0.0,0.0));
		h3 = waterH(posxz1 + vec3(0.0,0.0,deltaPos));
		h4 = waterH(posxz1 + vec3(0.0,0.0,-deltaPos));
	
		xDelta = ((h1-h0)+(h0-h2))/deltaPos;
		yDelta = ((h3-h0)+(h0-h4))/deltaPos;
		if (isEyeInWater < 0.9 && particle < 0.9){
			float foam = clamp(0.5-xDelta*0.5+yDelta*0.5,0.0,1.0)*exp(-depth*10);
			color += clamp(color*pow(foam,1.2)*128.0,vec3(0),vec3(1))*(0.2+lmshading*0.8);
			color = mix(color,color*0.1+0.9,foam);
			}
		}
		#endif
		
		vec3 causticcol = vec3(0);
		#ifdef WaterCaustic
		float caustic = 0;
		float csmask = mix(iswater,1-iswater,isEyeInWater)*(1-rainStrength);
		float cstorchlm = max(1-sky_lightmap*1.2*(1-night*0.5)*(lmshading*0.5+0.25),0.0)*(max(torch_lightmap-0.1,0.0)+pow(handLight*0.9,2.2)*4)*10;
		cstorchlm *= csmask;
		csmask*= max(lmshading,sky_lightmap*0.2)*(1-night*0.95);
		caustic += texture2D(noisetex,(posxz.xz+posxz.y)/1024+vec2(frametime,frametime)*0.001).r;
		caustic += texture2D(noisetex,(posxz.xz+posxz.y)/1024+pow(100,0.5)+vec2(-frametime,frametime)*0.001).r;
		caustic += texture2D(noisetex,(posxz.xz+posxz.y)/1024+pow(200,0.5)+vec2(frametime,-frametime)*0.001).r;
		caustic += texture2D(noisetex,(posxz.xz+posxz.y)/1024+pow(300,0.5)+vec2(-frametime,-frametime)*0.001).r;
		caustic = pow(caustic/4,2.2);
		causticcol = caustic*((1+color)*csmask+TorchColor*cstorchlm);
		#endif
		
		float visibility = sky_lightmap;
		float bouncefactor = sqrt((NdotUp*0.4+0.61) * pow(1.01-NdotL*NdotL,2.0)+0.5)*0.66;
		float cfBounce = (-NdotL*0.45+0.56);
		timebrightness = pow(timebrightness,0.5);
		float avglightstr = (Lighting_Brightness + Lighting_Darkness)/2;
		float skylightstr = Lighting_Brightness;
		float shdlightstr = (Lighting_Darkness*(1-shadowshading)+Lighting_Brightness*shadowshading)+(1-eyeBrightnessSmooth.y/240.0)*0.3;
		skylightstr = mix(mix(avglightstr,skylightstr,sky_lightmap),avglightstr*2,rainStrength);
		shdlightstr = mix(shdlightstr,avglightstr*2,rainStrength);
		
		vec3 emissivecol = (length(color)*(emissive+islava*4)+(2.0-length(color)*1.0)*emissivecolored)*color*6.0;
		if (particle > 0.9) color *= 2;
		
		vec3 bounceSunlight = 0.6*cfBounce*light_col*pow(sky_lightmap,3.0)*(skylightstr*colshading) * (1-rainStrength*0.9);
		
		float tL = (lightS.x*pow(sky_lightmap,2.2) + lightS.y)/5.5;
		float tLMoon = (lightS.z + lightS.w)/3.;
		
		vec3 skycolor = mix((sky_color), nsunlight,1-exp(-0.11*tL*(1-rainStrength*0.8)))*tL*sunVisibility*(1-rainStrength*0.8)*(2.0-lmshading*(1-rainStrength)-rainStrength) + tLMoon*moonVisibility*moonlight;

		vec3 sky_light = (skylightstr*lmshading+shdlightstr*(1-lmshading))*skycolor*visibility*bouncefactor*(0.3+(moonVisibility+timebrightness*0.25)*0.7);
			 sky_light+= vec3(1)*pow(sky_lightmap,0.5)*0.5*(1-rainStrength)*(1-moonVisibility)*(0.25+lmshading*0.75) * (1+eyeAdapt)/2;
		
		vec3 torchcolor = vec3(TorchColor);
		//torchcolor = torchcolor*(1-sky_lightmap) + sky_lightmap;
		vec3 color_torchlight = (torch_lightmap+handLight)*torchcolor + (moonlight*(1+sunVisibility)*2)*(1+eyeAdapt)/2;
		
		#ifdef DarkDesaturation
		float sata1 = max(sky_lightmap*1.1*(1-pow(rainStrength,2.0)*0.3)*(sunVisibility*0.8+0.2),lmshading*sunVisibility*(1-rainStrength));
		float sata2 = (torch_lightmap+handLight)*4.0;
		float sata = clamp(sata1*mix(3.0-moonVisibility,1.0,rainStrength) + sata2,0.1,1.0);
		vec3 satb1 = vec3(0);
		vec3 satb2 = vec3(0);
		if (dimread == 0){
		satb1 = vec3(0.6,0.8,1);
		satb1 = mix(satb1,vec3(length(satb1)*0.5),rainStrength);
		satb2 = vec3(0.5);
		}
		if (dimread == -1){
		satb1 = vec3(1,0.3,0.1);
		satb2 = satb1;
		}
		if (dimread ==  1){
		satb1 = vec3(0.8,0.6,1);
		satb2 = satb1;
		}
		vec3 satc = vec3(satb1)*sky_lightmap+satb2*(1-sky_lightmap);
		vec3 satd = (color.r+color.g+color.b)/3*satc;
		color = color*sata + satd*(1-sata);
		#endif
		
		float blockspec = 0.0;
		if (land > 0.9 && iswater < 0.9){
			if ((reflectable-reflectopaque) < 0.9)blockspec = clamp(Blinn_Phong(fragposition.xyz,lightVector,normal,fresnel_pow,1,shading*diffuse,4) * (1-isEyeInWater) * transition_fading,0.0,1.0);
			else blockspec = clamp(Blinn_Phong(fragposition.xyz,lightVector,normal,fresnel_pow,1,shading*diffuse*(reflectable-reflectnogloss),6) * (1-isEyeInWater) * transition_fading * 0.5,0.0,1.0);
			}
		vec3 lightspec = vec3(0);
		#ifdef Gloss
		vec3 glosscol = mix(pow(sunlight,vec3(0.7))*0.5*Lighting_SunlightVal,moonlight*Lighting_MoonlightVal,moonVisibility)*2;
		lightspec = blockspec*glosscol*(1+night*7)*(1-rainStrength)*(1+timebrightness)/2;
		#endif
		
		vec3 ssscol = sss * light_col * shading *(1.0-rainStrength*0.9)*transition_fading;
		
		#ifdef Lighting_NoTexture
		color = vec3(0.5);
		#endif
		#ifdef InverseTonemap
		color = inverseUncharted2Tonemap(color);
		#endif
		
		vec3 lighting = (bounceSunlight + sky_light + Sunlight_lightmap + color_torchlight + ssscol + emissivecol + lightspec + (1-sky_lightmap)*SkylightBrightness*0.2 + causticcol);
		color = lighting*color*sky_absorbance*ao*Lighting_FinalMult;
		if (iswater > 0.9) color = mix(watercolor*pow(length(ambient_color),0.2)*0.05,color,exp(-depth/32));
		
		spec = Blinn_Phong(fragposition.xyz,lightVector,normal,fresnel_pow,1,pow(shading*diffuse,4),11 + night) * iswater * (1.0-isEyeInWater)*transition_fading;
		spec += blockspec;
	}
	
	else {
	color = color*4;
	
	#ifdef DarkDesaturation
	float sata = (1-night);
	vec3 satb = vec3(0.3,0.6,1);
	vec3 satd = vec3(color.r+color.g+color.b)/3*satb;
	color = color*sata + satd*(1-sata);
	#endif
	
	if (dimread == -1 || dimread == 1) color = vec3(0);
	}

	

float gr = 0.0;
if (dimread == 0 && isEyeInWater == 0){
	#ifdef Godrays
		vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
		tpos = vec4(tpos.xyz/tpos.w,1.0);
		vec2 pos1 = tpos.xy/tpos.z;
		vec2 lightPos = pos1*0.5+0.5;
		

			vec2 deltaTextCoord = vec2( newtc.st - lightPos.xy );
			vec2 textCoord = newtc.st;
			deltaTextCoord *= 1.0 /  float(NUM_SAMPLES) * density;
			float avgdecay = 0.0;
			float distx = abs(newtc.x*aspectRatio-lightPos.x*aspectRatio);
			float disty = abs(newtc.y-lightPos.y);
			float noise = getnoise(texcoord.xy);
			float falloff = 1.0;
			
			for(int i=0; i < NUM_SAMPLES ; i++) {			
				textCoord -= deltaTextCoord;
				float sample = step(texture2DLod(gaux1, textCoord+ deltaTextCoord*noise*grnoise,1).g,0.01);
				falloff *= 0.9;
				
				gr += sample*falloff;
			}
	gr /= NUM_SAMPLES;
	#endif

	#ifdef VolLight
	float vldepth = texture2D(depthtex0,texcoord.xy).x;
	gr = pow(GetVolumetricRays(vldepth)*2.0,2.2-1.2*eyeBrightnessSmooth.y/240.0);
	#endif
}

#ifdef EDO
	if (iswater < 0.9 && islava < 0.9) color = edo(color);
#endif

	color = clamp(pow(color/MAX_COLOR_RANGE,vec3(1.0/2.2)),1.0/255.0,1.0);
	
/* DRAWBUFFERS:31 */
	gl_FragData[0] = vec4(color, spec);
	gl_FragData[1] = vec4(vec3(gr),1.0);
}
