#version 120
#define MAX_COLOR_RANGE 48.0

//Triliton`s shaders derive from Chocapic13`s v4
//disabling is done by adding "//" to the beginning of a line.

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

//#define VIGNETTE
	#define VIGNETTE_STRENGTH 1.2

	#define LensFlare
		#define Lens_Strength 0.8

#define Bloom								//do the "fog blur" in the same time

//#define DOF								//enable depth of field (blur on non-focused objects)
	#define CIRCLE_BOKEH					//enabled : circular blur shape
	//#define HEXAGONAL_BOKEH				//enabled : hexagonal blur shape
	//#define LOW_BOKEH					//enabled : low quality circular blur shape
	//#define TILT_SHIFT 					//to let everything look small more for cinematic purposes
	#define TILT_SHIFT_MULT 1.0;
	#define DOF_MULT 2.0
	const float MAX_BLUR_SIZE = 2.0;

#define CONTRAST 0.2

//#define GLARE
	#define GLARE_INTENSITY 0.1
	#define GLARE_OFFSET 1.0
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES


const bool gaux2MipmapEnabled = true;
varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 lightVector;
uniform sampler2D depthtex0;
uniform sampler2D gaux1;
uniform sampler2D gaux2;
uniform sampler2D gaux4;
uniform sampler2D texture;
uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D composite;
uniform sampler2D noisetex;
uniform sampler2D gnormal;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 sunPosition;
varying vec3 ambient_color;
varying vec3 moonlight;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform ivec2 eyeBrightness;
uniform int isEyeInWater;
uniform int worldTime;
uniform float aspectRatio;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
varying float moonVisibility;
vec3 sunPos = sunPosition;
uniform int fogMode;
float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float timefract = worldTime;

//Raining
float rainx = clamp(rainStrength, 0.0f, 1.0f)/1.0f;
float wetx  = clamp(wetness, 0.0f, 1.0f);

//Calculate Time of Day
float TimeSunrise  = ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0) + (1.0 - (clamp(timefract, 0.0, 4000.0)/4000.0));
float TimeNoon     = ((clamp(timefract, 0.0, 4000.0)) / 4000.0) - ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0);
float TimeSunset   = ((clamp(timefract, 8000.0, 12000.0) - 8000.0) / 4000.0) - ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);

float matflag = texture2D(gaux1,texcoord.xy).g;
vec3 aux = texture2D(gaux1, texcoord.st).xyz;

float sky_lightmap = pow(aux.x, 1.0);

// Standard depth function.
float getDepth(float depth) {
    return 2.0 * near * far / (far + near - (2.0 * depth - 1.0) * (far - near));
}

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

float luma(vec3 color) {
	return dot(color,vec3(0.299, 0.587, 0.114));
}

#ifdef BLOOM
	#ifdef B_SAMPLER
		const vec2 offsets_1[25] = vec2[25](vec2(-0.4894566f,-0.3586783f),
									vec2(-0.1717194f,0.6272162f),
									vec2(-0.4709477f,-0.01774091f),
									vec2(-0.9910634f,0.03831699f),
									vec2(-0.2101292f,0.2034733f),
									vec2(-0.7889516f,-0.5671548f),
									vec2(-0.1037751f,-0.1583221f),
									vec2(-0.5728408f,0.3416965f),
									vec2(-0.1863332f,0.5697952f),
									vec2(0.3561834f,0.007138769f),
									vec2(0.2868255f,-0.5463203f),
									vec2(-0.4640967f,-0.8804076f),
									vec2(0.1969438f,0.6236954f),
									vec2(0.6999109f,0.6357007f),
									vec2(-0.3462536f,0.8966291f),
									vec2(0.172607f,0.2832828f),
									vec2(0.4149241f,0.8816f),
									vec2(0.136898f,-0.9716249f),
									vec2(-0.6272043f,0.6721309f),
									vec2(-0.8974028f,0.4271871f),
									vec2(0.5551881f,0.324069f),
									vec2(0.9487136f,0.2605085f),
									vec2(0.7140148f,-0.312601f),
									vec2(0.0440252f,0.9363738f),
									vec2(0.620311f,-0.6673451f)
									);
	#endif

#endif

#ifdef TILT_SHIFT
const float focal = 2.0;
float aperture = 0.15;
const float sizemult = 0.25*TILT_SHIFT_MULT;
#else
const float focal = 0.015;
float aperture = 0.009;
const float sizemult = 50.0*DOF_MULT;
#endif


#ifdef DOF

//hexagon pattern
	const vec2 hex_offsets[60] = vec2[60] (	vec2(  0.2165,  0.1250 ),
											vec2(  0.0000,  0.2500 ),
											vec2( -0.2165,  0.1250 ),
											vec2( -0.2165, -0.1250 ),
											vec2( -0.0000, -0.2500 ),
											vec2(  0.2165, -0.1250 ),
											vec2(  0.4330,  0.2500 ),
											vec2(  0.0000,  0.5000 ),
											vec2( -0.4330,  0.2500 ),
											vec2( -0.4330, -0.2500 ),
											vec2( -0.0000, -0.5000 ),
											vec2(  0.4330, -0.2500 ),
											vec2(  0.6495,  0.3750 ),
											vec2(  0.0000,  0.7500 ),
											vec2( -0.6495,  0.3750 ),
											vec2( -0.6495, -0.3750 ),
											vec2( -0.0000, -0.7500 ),
											vec2(  0.6495, -0.3750 ),
											vec2(  0.8660,  0.5000 ),
											vec2(  0.0000,  1.0000 ),
											vec2( -0.8660,  0.5000 ),
											vec2( -0.8660, -0.5000 ),
											vec2( -0.0000, -1.0000 ),
											vec2(  0.8660, -0.5000 ),
											vec2(  0.2163,  0.3754 ),
											vec2( -0.2170,  0.3750 ),
											vec2( -0.4333, -0.0004 ),
											vec2( -0.2163, -0.3754 ),
											vec2(  0.2170, -0.3750 ),
											vec2(  0.4333,  0.0004 ),
											vec2(  0.4328,  0.5004 ),
											vec2( -0.2170,  0.6250 ),
											vec2( -0.6498,  0.1246 ),
											vec2( -0.4328, -0.5004 ),
											vec2(  0.2170, -0.6250 ),
											vec2(  0.6498, -0.1246 ),
											vec2(  0.6493,  0.6254 ),
											vec2( -0.2170,  0.8750 ),
											vec2( -0.8663,  0.2496 ),
											vec2( -0.6493, -0.6254 ),
											vec2(  0.2170, -0.8750 ),
											vec2(  0.8663, -0.2496 ),
											vec2(  0.2160,  0.6259 ),
											vec2( -0.4340,  0.5000 ),
											vec2( -0.6500, -0.1259 ),
											vec2( -0.2160, -0.6259 ),
											vec2(  0.4340, -0.5000 ),
											vec2(  0.6500,  0.1259 ),
											vec2(  0.4325,  0.7509 ),
											vec2( -0.4340,  0.7500 ),
											vec2( -0.8665, -0.0009 ),
											vec2( -0.4325, -0.7509 ),
											vec2(  0.4340, -0.7500 ),
											vec2(  0.8665,  0.0009 ),
											vec2(  0.2158,  0.8763 ),
											vec2( -0.6510,  0.6250 ),
											vec2( -0.8668, -0.2513 ),
											vec2( -0.2158, -0.8763 ),
											vec2(  0.6510, -0.6250 ),
											vec2(  0.8668,  0.2513 ));

	const vec2 offsets[60] = vec2[60]  (  vec2( 0.0000, 0.2500 ),
									vec2( -0.2165, 0.1250 ),
									vec2( -0.2165, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2( 0.2165, -0.1250 ),
									vec2( 0.2165, 0.1250 ),
									vec2( 0.0000, 0.5000 ),
									vec2( -0.2500, 0.4330 ),
									vec2( -0.4330, 0.2500 ),
									vec2( -0.5000, 0.0000 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.2500, -0.4330 ),
									vec2( -0.0000, -0.5000 ),
									vec2( 0.2500, -0.4330 ),
									vec2( 0.4330, -0.2500 ),
									vec2( 0.5000, -0.0000 ),
									vec2( 0.4330, 0.2500 ),
									vec2( 0.2500, 0.4330 ),
									vec2( 0.0000, 0.7500 ),
									vec2( -0.2565, 0.7048 ),
									vec2( -0.4821, 0.5745 ),
									vec2( -0.6495, 0.3750 ),
									vec2( -0.7386, 0.1302 ),
									vec2( -0.7386, -0.1302 ),
									vec2( -0.6495, -0.3750 ),
									vec2( -0.4821, -0.5745 ),
									vec2( -0.2565, -0.7048 ),
									vec2( -0.0000, -0.7500 ),
									vec2( 0.2565, -0.7048 ),
									vec2( 0.4821, -0.5745 ),
									vec2( 0.6495, -0.3750 ),
									vec2( 0.7386, -0.1302 ),
									vec2( 0.7386, 0.1302 ),
									vec2( 0.6495, 0.3750 ),
									vec2( 0.4821, 0.5745 ),
									vec2( 0.2565, 0.7048 ),
									vec2( 0.0000, 1.0000 ),
									vec2( -0.2588, 0.9659 ),
									vec2( -0.5000, 0.8660 ),
									vec2( -0.7071, 0.7071 ),
									vec2( -0.8660, 0.5000 ),
									vec2( -0.9659, 0.2588 ),
									vec2( -1.0000, 0.0000 ),
									vec2( -0.9659, -0.2588 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.7071, -0.7071 ),
									vec2( -0.5000, -0.8660 ),
									vec2( -0.2588, -0.9659 ),
									vec2( -0.0000, -1.0000 ),
									vec2( 0.2588, -0.9659 ),
									vec2( 0.5000, -0.8660 ),
									vec2( 0.7071, -0.7071 ),
									vec2( 0.8660, -0.5000 ),
									vec2( 0.9659, -0.2588 ),
									vec2( 1.0000, -0.0000 ),
									vec2( 0.9659, 0.2588 ),
									vec2( 0.8660, 0.5000 ),
									vec2( 0.7071, 0.7071 ),
									vec2( 0.5000, 0.8660 ),
									vec2( 0.2588, 0.9659 ));
const vec2 fast_offsets[20] = vec2[20](vec2(1,0),
									vec2(-1,0),
									vec2(0,1),
									vec2(0,-1),
									vec2(0.7,0.7),
									vec2(-0.7,0.7),
									vec2(0.7,-0.7),
									vec2(-0.7,-0.7),
									vec2(0.5,0),
									vec2(-0.5,0),
									vec2(0,0.5),
									vec2(0,-0.5),
									vec2(0.35,0.35),
									vec2(-0.35,0.35),
									vec2(0.35,-0.35),
									vec2(-0.35,-0.35),
									vec2(0.25,0),
									vec2(-0.25,0),
									vec2(0,0.25),
									vec2(0,-0.25)
									);
#endif

float A = 1.0;		//brightness multiplier
float B = 0.34;		//black level (lower means darker and more constrasted, higher make the image whiter and less constrasted)
float C = 0.1;		//constrast level

vec3 Uncharted2Tonemap(vec3 x) {
	float D = 0.09;
	float E = 0.02;
	float F = 0.3;
	float W = MAX_COLOR_RANGE;
	/*--------------------------------*/
	return ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;
}


int hand  = int(matflag > 0.75 && matflag < 0.85);
int land  = int(matflag > 0.04);

float distratio(vec2 pos, vec2 pos2, float ratio) {
float xvect = pos.x*ratio-pos2.x*ratio;
float yvect = pos.y-pos2.y;
return sqrt(xvect*xvect + yvect*yvect);
}

//circle position pattern (vec2 coordinate, size)
const vec3 pattern[16] = vec3[16](	vec3(0.1,0.1,0.02),
								vec3(-0.12,0.07,0.02),
								vec3(-0.11,-0.13,0.02),
								vec3(0.1,-0.1,0.02),

								vec3(0.07,0.15,0.02),
								vec3(-0.08,0.17,0.02),
								vec3(-0.14,-0.07,0.02),
								vec3(0.15,-0.19,0.02),

								vec3(0.012,0.15,0.02),
								vec3(-0.08,0.17,0.02),
								vec3(-0.14,-0.07,0.02),
								vec3(0.02,-0.17,0.021),

								vec3(0.10,0.05,0.02),
								vec3(-0.13,0.09,0.02),
								vec3(-0.05,-0.1,0.02),
								vec3(0.1,0.01,0.02)
								);

float gen_circular_lens(vec2 center, float size) {
return 1.0-pow(min(distratio(texcoord.xy,center,aspectRatio),size)/size,3.0);
}

vec2 noisepattern(vec2 pos) {
return vec2(abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f)),abs(fract(sin(dot(pos.yx ,vec2(18.9898f,28.633f))) * 4378.5453f)));
}

float waterDrop (vec2 tc) {
	vec2 drop = vec2(0.0,fract(frameTimeCounter/750.0));
	tc.x *= 10;
	float noise = texture2D(noisetex,(tc+drop)/2).x;
	noise += texture2D(noisetex,(tc+drop)).x/2;
	noise += texture2D(noisetex,(tc+drop)*2).x/4;
	noise += texture2D(noisetex,(tc+drop)*4).x/8;
	noise += texture2D(noisetex,(tc+drop*0.5)).x/2;
	noise += texture2D(noisetex,(tc+drop*0.5)*2).x/4;
	noise += texture2D(noisetex,(tc+drop*0.5)*4).x/8;
	float dropstrength = max(noise-1.8,0.0);
	float wdrop = 0.1;
	float waterD = (1.0 - (pow(wdrop,dropstrength)));
	waterD *= clamp((eyeBrightness.y-220)/15.0,0.0,1.0)*rainStrength;
	return waterD;
}
/*

float pent(in vec2 p){
    vec2 q = abs(p);
    return max(max(q.x*1.176-p.y*0.385, q.x*0.727+p.y), -p.y*1.237)*1.;
}

vec3 flare2(vec2 p, vec2 pos)
{
	vec2 q = p-pos;
    vec2 pds = p*(length(p))*0.75;
	float a = atan(q.x,q.y);

    float rz = 0.0; //Spokes

    rz += max(1.0/(1.0+32.0*pent(pds+0.8*pos)),.0)*00.2;
    vec2 p2 = mix(p,pds,-.5); //Reverse distort
	rz += max(0.01-pow(pent(p2 + 0.4*pos),2.2),.0)*3.0;
	rz += max(0.01-pow(pent(p2 + 0.2*pos),5.5),.0)*3.0;
	rz += max(0.01-pow(pent(p2 - 0.1*pos),1.6),.0)*4.0;
    rz += max(0.01-pow(pent(-(p2 + 1.*pos)),2.5),.0)*5.0;
    rz += max(0.01-pow(pent(-(p2 - .5*pos)),2.),.0)*4.0;
    rz += max(0.01-pow(pent(-(p2 + .7*pos)),5.),.0)*3.0;

    return vec3(clamp(rz,0.,1.));
}
*/

vec3 flare(vec2 uv,vec2 pos)
{
	vec2 main = uv-pos;
	vec2 uvd = uv*(length(uv));

	float ang = atan(main.x,main.y);
	float dist=length(main); dist = pow(dist,.1);

	float f0 = 1.0/(length(uv-pos)*16.0+1.0);
	float f1 = max(0.01-pow(length(uv+1.2*pos),1.9),.0)*7.0;

	float f2 = max(1.0/(1.0+32.0*pow(length(uvd+0.8*pos),1.0)),.0)*00.25;
	float f22 = max(1.0/(1.0+32.0*pow(length(uvd+0.83*pos),1.0)),.0)*00.23;
	float f23 = max(1.0/(1.0+32.0*pow(length(uvd+0.87*pos),1.0)),.0)*00.21;

	vec2 uvx = mix(uv,uvd,-0.5);

	float f4 = max(0.01-pow(length(uvx+0.4*pos),1.4),.0)*6.0;
	float f42 = max(0.01-pow(length(uvx+0.43*pos),1.4),.0)*5.0;
	float f43 = max(0.01-pow(length(uvx+0.47*pos),1.4),.0)*3.0;

	uvx = mix(uv,uvd,-.4);

	float f5 = max(0.01-pow(length(uvx+0.3*pos),3.5),.0)*2.0;
	float f52 = max(0.01-pow(length(uvx+0.35*pos),3.5),.0)*2.0;
	float f53 = max(0.01-pow(length(uvx+0.4*pos),3.5),.0)*2.0;

	uvx = mix(uv,uvd,-0.5);

	float f6 = max(0.01-pow(length(uvx-0.3*pos),0.6),.0)*6.0;
	float f62 = max(0.01-pow(length(uvx-0.325*pos),0.6),.0)*3.0;
	float f63 = max(0.01-pow(length(uvx-0.35*pos),0.6),.0)*5.0;

	vec3 c = vec3(.0);

	c.r+=f2+f4+f5+f6; c.g+=f22+f42+f52+f62; c.b+=f23+f43+f53+f63;
	c = c*1.3 - vec3(length(uvd)*.05);
	c+=vec3(0);

	return c;
}

vec3 cc(vec3 color, float factor,float factor2) // color modifier
{
	float w = color.x+color.y+color.z;
	return mix(color,vec3(w)*factor,w*factor2);
}


float smoothCircleDist (in float lensDist) {

 vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	 tpos = vec4(tpos.xyz/tpos.w,1.0);
 vec2 lightPos = tpos.xy/tpos.z*lensDist;
	 lightPos = (lightPos + 1.0f)/2.0f;

 return distratio(lightPos.xy, texcoord.xy, aspectRatio);
}


void robobo1221sTonemap(inout vec3 color){

	vec3 x = color - 0.07453525;
	vec3 tonemap = ((4.0*x+0.4824124214) / (3.7*x+0.6236954f) - 0.5124124214) * 1.7753525;
		tonemap = pow(tonemap, vec3(2.2));

	color = tonemap;

}

void convertFinalToHDR(inout vec3 color){

	vec3 MaxExp = color * 4.0;
	vec3 MinExp = color / 4.0;


	vec3 getHDR = mix(MinExp,MaxExp,color.rgb);

	color = getHDR;
}

vec3 getColorCorrection(vec3 color){

	//Color changes depends on time//

	color.b += color.b*0.3*TimeNoon*(1-rainx);
	color.r -= color.r*0.3*TimeNoon*(1-rainx);

	/////////////////////////////////////////////////////////////////

	color.bg += color.bg*.15;

	return color.rgb;
}
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

void main() {
	vec2 fake_refract = vec2(sin(frameTimeCounter*0.5 + texcoord.x*0.0 + texcoord.y*0.0),cos(frameTimeCounter*0.5 + texcoord.y*0.0 + texcoord.x*0.0)) *isEyeInWater ;

	vec2 fake_refract2 = vec2(sin(frameTimeCounter*6.0 + texcoord.x*0.0 + texcoord.y*50.0),cos(frameTimeCounter*0.0 + texcoord.y*0.0 + texcoord.x*100.0));

	vec3 color = texture2D(gaux2, texcoord.st + fake_refract * 0.01 + (fake_refract2 * 0.09 *waterDrop(texcoord.xy/100))).rgb;

float pcoc = 0;
#ifdef DOF
	float z = ld(texture2D(depthtex0, texcoord.st).r)*far;
	float focus = ld(texture2D(depthtex0, vec2(0.5)).r)*far;
	float blursize = MAX_BLUR_SIZE*viewWidth/1280;
	pcoc = min(abs(aperture * (focal * (z - focus)) / (z * (focus - focal)))*sizemult,pw*blursize);

	#ifdef DISTANT_BLUR
	if (land > 0.9)
	pcoc = min(fog*pw*sizemult,pw*blursize);
	else
	pcoc = min(fog*pw*sizemult,pw*blursize)*(fog*(1-rainStrength)+rainStrength);
	#endif

	#ifdef DUAL_BLUR
	pcoc = min((abs(aperture * (focal * (z - focus)) / (z * (focus - focal)))+fog*pw*land)*sizemult,pw*blursize);
	#endif

	#ifndef HAND_BLUR
	pcoc = pcoc*(1-hand);
	#endif


	vec4 sample = vec4(0.0);
	vec3 bcolor = color/MAX_COLOR_RANGE;
	float nb = 0.0;
	vec2 bcoord = vec2(0.0);

{
	if (pcoc > pw) {
	#ifdef HEXAGONAL_BOKEH

		for ( int i = 0; i < 60; i++) {
			bcolor += texture2D(gaux2, texcoord.xy + hex_offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb;

		}
		color.rgb = pow(bcolor/60,vec3(1.0));
	#endif
	#ifdef LOW_BOKEH
	for ( int i = 0; i < 20; i++) {
		bcolor += texture2D(gaux2, texcoord.xy + fast_offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb;
		}
		color.rgb = pow(bcolor/(20),vec3(1.0));
	#endif
	#ifdef CIRCLE_BOKEH
	for ( int i = 0; i < 60; i++) {
		bcolor += texture2D(gaux2, texcoord.xy + offsets[i]*pcoc*vec2(1.0,aspectRatio)).rgb;
		}
		color.rgb = pow(bcolor/60,vec3(1.0));
	#endif
	}
	}
#endif

	float plum = luma(color.rgb);

#ifdef Bloom
vec3 blur = vec3(0);
vec2 bloomcoord = texcoord.xy;

	vec3 blur1 = pow(texture2D(composite,bloomcoord/pow(2.0,2.0) + vec2(0.0,0.0)).rgb,vec3(2.2))*pow(7.0,1.0);
	vec3 blur2 = pow(texture2D(composite,bloomcoord/pow(2.0,3.0) + vec2(0.3,0.0)).rgb,vec3(2.2))*pow(6.0,1.0);
	vec3 blur3 = pow(texture2D(composite,bloomcoord/pow(2.0,4.0) + vec2(0.0,0.3)).rgb,vec3(2.2))*pow(5.0,1.0);
	vec3 blur4 = pow(texture2D(composite,bloomcoord/pow(2.0,5.0) + vec2(0.1,0.3)).rgb,vec3(2.2))*pow(4.0,1.0);
	vec3 blur5 = pow(texture2D(composite,bloomcoord/pow(2.0,6.0) + vec2(0.2,0.3)).rgb,vec3(2.2))*pow(3.0,1.0);
	vec3 blur6 = pow(texture2D(composite,bloomcoord/pow(2.0,7.0) + vec2(0.3,0.3)).rgb,vec3(2.2))*pow(2.0,1.0);
	
	blur = blur1 + blur2 + blur3 + blur4 + blur5 + blur6;
	
color.rgb = mix(color,blur*MAX_COLOR_RANGE,0.0006);
#endif


color.rgb += texture2D(gaux4,texcoord.xy).rgb*sqrt(texture2D(gaux4,texcoord.xy).a);

#ifdef LensFlare
vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
vec2 lightPos = tpos.xy/tpos.z;
	lightPos = (lightPos + 1.0f)/2.0f;
	float truepos = pow(clamp(dot(-lightVector,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.25);
	float time = float(worldTime);
	float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13000.0)/300.0,0.0,1.0) + clamp((time-22800.0)/200.0,0.0,1.0)-clamp((time-23400.0)/200.0,0.0,1.0));
	float distof = min(min(1.0-lightPos.x,lightPos.x),min(1.0-lightPos.y,lightPos.y));
	float fading = clamp(1.0-step(distof,0.1)+pow(distof*10.0,5.0),0.0,1.0);
	float fade = clamp(1.0-step(distof,0.08),0.0,1.0);
	float sunvisibility = min(texture2D(gaux2,vec2(0.0)).a*2.5,1.0) * (1.0-rainStrength*0.9) * fading * transition_fading;
	float sun = sunvisibility*Lens_Strength;
	float visibility = max(pow(max(1.0 - smoothCircleDist(1)/.75,.1),2)-.1,0);
	float h = TimeMidnight, r = rainStrength;
	vec3 L = lightVector;
	float tp = pow(clamp(dot(-L,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.25);
	float x = abs(lightPos.x-texcoord.x);
	float y = abs(lightPos.y-texcoord.y);


	if (sun*fade > 0.05) {
color += vec3(1.4,1.2,1.0)*flare(texcoord.st - 0.5,sunPosition.xy/100)*(1-h) * truepos * sun * (1-r);
//color += vec3(1.4,1.2,1.0)*flare2(texcoord.st - 0.5,sunPosition.xy/100)*(1-h) * (1-r);
	//Anamorphic Lens
	float a_l = exp(-y*y/0.0001)*exp(-x*x/0.1)*sun*(1-h*0.9) * (1-r);
	color.rgb += (vec3(0.0,1.08,1.4)*a_l)* tp;

	}
#endif


#ifdef GLARE

	color = color * 1.0;

	float radius = 0.002*GLARE_OFFSET;
	float radiusv = 0.002;
	float bloomintensity = 0.1*GLARE_INTENSITY;

	vec4 clr = vec4(0.0);

	clr += texture2D(gaux2, texcoord.st);



	clr += texture2D(gaux2, texcoord.st + (vec2(10.0,0.0))*radius)*10.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(9.0,0.0))*radius)*11.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(8.0,0.0))*radius)*12.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(7.0,0.0))*radius)*13.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(6.0,0.0))*radius)*14.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(5.0,0.0))*radius)*15.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(4.0,0.0))*radius)*16.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(3.0,0.0))*radius)*17.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(2.0,0.0))*radius)*18.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(1.0,0.0))*radius)*19.0;

	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,0.0))*radius)*20.0;

	clr += texture2D(gaux2, texcoord.st + (vec2(-1.0,0.0))*radius)*19.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(-2.0,0.0))*radius)*18.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(-3.0,0.0))*radius)*17.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(-4.0,0.0))*radius)*16.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(-5.0,0.0))*radius)*15.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(-6.0,0.0))*radius)*14.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(-7.0,0.0))*radius)*13.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(-8.0,0.0))*radius)*12.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(-9.0,0.0))*radius)*11.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(-10.0,0.0))*radius)*10.0;


	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,10.0))*radius)*10.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,9.0))*radius)*11.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,8.0))*radius)*12.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,7.0))*radius)*13.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,6.0))*radius)*14.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,5.0))*radius)*15.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,4.0))*radius)*16.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,3.0))*radius)*17.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,2.0))*radius)*18.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,1.0))*radius)*19.0;


	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,-10.0))*radius)*10.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,-9.0))*radius)*11.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,-8.0))*radius)*12.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,-7.0))*radius)*13.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,-6.0))*radius)*14.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,-5.0))*radius)*15.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,-4.0))*radius)*16.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,-3.0))*radius)*17.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,-2.0))*radius)*18.0;
	clr += texture2D(gaux2, texcoord.st + (vec2(0.0,-1.0))*radius)*19.0;



	clr = (clr/20.0)/5.0;
	clr.r = pow(clr.r, 1.2)*1.6 - (clr.g + clr.b)*0.6;
	clr.g = pow(clr.g, 1.2)*1.6 - (clr.r + clr.b)*0.6;
	clr.b = pow(clr.b, 1.2)*1.9 - (clr.r + clr.g)*0.9;

	clr = clamp((clr), 0.0, 1.0);

	color.r = color.r + (clr.r*1.5)*bloomintensity;
	color.g = color.g + (clr.g*1.5)*bloomintensity;
	color.b = color.b + (clr.b*1.5)*bloomintensity;
	color = max(color, 0.0);
	//color = color*1.05 - 0.05;



#endif

#ifdef VIGNETTE

float dv = distance(texcoord.st, vec2(0.5, 0.5));

dv *= VIGNETTE_STRENGTH;

dv = 0.9 - dv;

dv = pow(dv, 0.25);

dv *= 2.3;
dv -= 0.9;

color *= dv;
#endif




float Brightness = .1;

 color.rgb += normalize(color.rgb/clamp(color,Brightness,1.0)+Brightness*pow(color,vec3(Brightness)))*Brightness*clamp(color,1.0,Brightness)*pow(color,vec3(Brightness));

 color = clamp(color,0.0,1.0);

 float white = luma(color);
 color = color*(1.0+pow(white,CONTRAST))/(2.0-CONTRAST);

 color = pow(color,vec3(1.75));


	vec3 curr = Uncharted2Tonemap(color);
	vec3 whiteScale = 1.0f/Uncharted2Tonemap(vec3(1.0));
	//color = pow(curr*whiteScale,vec3(1/0.5*0.5));

		convertFinalToHDR(color);
		robobo1221sTonemap(color);


	//vec2 poss = (texcoord.xy);

	//poss *= 500.0;

	//poss += (1.0* (frameTimeCounter/0.5) / pos.x);

	//color += vec3(cos((poss.x-0.5) * 3.14259) * sin(poss.y * 3.14259))*1.0;

	color = getColorCorrection(color);

	color = clamp(pow(color,vec3(1.0/2.2)),0.0,1.0);

	     color.r = color.r*1.0;
         color.g = color.g*1.0;
         color.b = color.b*1.0;

	gl_FragColor = vec4(color,1.0);

}
