/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.internal;

import com.google.common.base.Splitter;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.FMLIndexedMessageToMessageCodec;
import net.minecraftforge.fml.common.network.FMLNetworkException;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class FMLRuntimeCodec
extends FMLIndexedMessageToMessageCodec<FMLMessage> {
    public FMLRuntimeCodec() {
        this.addDiscriminator(0, FMLMessage.CompleteHandshake.class);
        this.addDiscriminator(1, FMLMessage.OpenGui.class);
        this.addDiscriminator(2, FMLMessage.EntitySpawnMessage.class);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, FMLMessage msg, ByteBuf target) throws Exception {
        msg.toBytes(target);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, FMLMessage msg) {
        msg.fromBytes(source);
    }

    @Override
    protected void testMessageValidity(FMLProxyPacket msg) {
        if (msg.payload().getByte(0) == 0 && msg.payload().readableBytes() > 2) {
            FMLLog.log.fatal("The connection appears to have sent an invalid FML packet of type 0, this is likely because it think's it's talking to 1.6.4 FML");
            FMLLog.log.info("Bad data :");
            for (String l2 : Splitter.on((char)'\n').split((CharSequence)ByteBufUtils.getContentDump(msg.payload()))) {
                FMLLog.log.info("\t{}", (Object)l2);
            }
            throw new FMLNetworkException("Invalid FML packet");
        }
    }
}

