/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.List;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketLoggingHandler {
    public static void register(gw manager) {
        ChannelPipeline pipeline = manager.channel().pipeline();
        final hu direction = manager.getDirection();
        if (manager.c()) {
            pipeline.addBefore("packet_handler", "splitter", (ChannelHandler)new SimpleChannelInboundHandler<ht<?>>(){
                String prefix;
                {
                    this.prefix = direction == hu.a ? "SERVER: C->S" : "CLIENT: S->C";
                }

                protected void channelRead0(ChannelHandlerContext ctx, ht<?> msg) throws Exception {
                    gy buf = new gy(Unpooled.buffer());
                    msg.b(buf);
                    FMLLog.log.debug("{} {}:\n{}", (Object)this.prefix, (Object)msg.getClass().getSimpleName(), (Object)ByteBufUtils.getContentDump((ByteBuf)buf));
                    ctx.fireChannelRead(msg);
                }
            });
            pipeline.addBefore("splitter", "prepender", (ChannelHandler)new ChannelOutboundHandlerAdapter(){
                String prefix;
                {
                    this.prefix = direction == hu.a ? "SERVER: S->C" : "CLIENT: C->S";
                }

                public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                    if (msg instanceof ht) {
                        gy buf = new gy(Unpooled.buffer());
                        ((ht)msg).b(buf);
                        FMLLog.log.debug("{} {}:\n{}", (Object)this.prefix, (Object)msg.getClass().getSimpleName(), (Object)ByteBufUtils.getContentDump((ByteBuf)buf));
                    }
                    ctx.write(msg, promise);
                }
            });
        } else {
            pipeline.replace("splitter", "splitter", (ChannelHandler)new hc(){
                String prefix;
                {
                    this.prefix = direction == hu.a ? "SERVER: C->S" : "CLIENT: S->C";
                }

                protected void decode(ChannelHandlerContext context, ByteBuf input, List<Object> output) throws Exception {
                    super.decode(context, input, output);
                    for (ByteBuf byteBuf : output) {
                        byteBuf.markReaderIndex();
                        FMLLog.log.debug("{}:\n{}", (Object)this.prefix, (Object)ByteBufUtils.getContentDump(byteBuf));
                        byteBuf.resetReaderIndex();
                    }
                }
            });
            pipeline.replace("prepender", "prepender", (ChannelHandler)new hd(){
                String prefix;
                {
                    this.prefix = direction == hu.a ? "SERVER: S->C" : "CLIENT: C->S";
                }

                protected void a(ChannelHandlerContext context, ByteBuf input, ByteBuf output) throws Exception {
                    input.markReaderIndex();
                    FMLLog.log.debug("{}:\n{}", (Object)this.prefix, (Object)ByteBufUtils.getContentDump(input));
                    input.resetReaderIndex();
                    super.a(context, input, output);
                }
            });
        }
    }
}

