/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.util;

import com.google.common.collect.Lists;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.ilexiconn.llibrary.LLibrary;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.Tuple;

public class WebUtils {
    public static final String PASTEBIN_URL_PREFIX = "http://pastebin.com/raw.php?i=";
    private static final Queue<Tuple<String, Consumer<String>>> DOWNLOAD_QUEUE = new LinkedBlockingDeque<Tuple<String, Consumer<String>>>();

    public static String readPastebin(String pasteID) {
        return WebUtils.readURL(PASTEBIN_URL_PREFIX + pasteID);
    }

    public static List<String> readPastebinAsList(String pasteID) {
        return WebUtils.readURLAsList(PASTEBIN_URL_PREFIX + pasteID);
    }

    public static String readURL(String url) {
        try {
            String currentLine;
            String text = "";
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(url).openStream()));
            while ((currentLine = reader.readLine()) != null) {
                text = text + currentLine + "\r\n";
            }
            reader.close();
            return text;
        }
        catch (IOException e) {
            LLibrary.LOGGER.error(CrashReport.func_85055_a((Throwable)e, (String)("Failed to receive data from URL: " + url)).func_71502_e());
            return null;
        }
    }

    public static List<String> readURLAsList(String url) {
        try {
            String currentLine;
            ArrayList text = Lists.newArrayList();
            BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(url).openStream()));
            while ((currentLine = reader.readLine()) != null) {
                text.add(currentLine);
            }
            reader.close();
            return text;
        }
        catch (IOException e) {
            LLibrary.LOGGER.error(CrashReport.func_85055_a((Throwable)e, (String)("Failed to receive data from URL: " + url)).func_71502_e());
            return null;
        }
    }

    public static BufferedImage downloadImage(String url) {
        try {
            return ImageIO.read(new BufferedInputStream(new URL(url).openStream()));
        }
        catch (IOException e) {
            LLibrary.LOGGER.error(CrashReport.func_85055_a((Throwable)e, (String)("Failed to receive data from URL: " + url)).func_71502_e());
            return null;
        }
    }

    public static void readURLAsync(String url, Consumer<String> callback) {
        DOWNLOAD_QUEUE.add((Tuple<String, Consumer<String>>)new Tuple((Object)url, callback));
    }

    public static void readURLAsListAsync(String url, Consumer<List<String>> callback) {
        DOWNLOAD_QUEUE.add((Tuple<String, Consumer<String>>)new Tuple((Object)url, text -> {
            Object[] lines = text.split("\r\n");
            callback.accept(Lists.newArrayList((Object[])lines));
        }));
    }

    public static void readPastebinAsync(String pasteID, Consumer<String> callback) {
        WebUtils.readURLAsync(PASTEBIN_URL_PREFIX + pasteID, callback);
    }

    public static void readPastebinAsListAsync(String pasteID, Consumer<String> callback) {
        WebUtils.readURLAsync(PASTEBIN_URL_PREFIX + pasteID, callback);
    }

    static {
        Thread downloadThread = new Thread(() -> {
            while (true) {
                try {
                    while (true) {
                        if (!DOWNLOAD_QUEUE.isEmpty()) {
                            Tuple<String, Consumer<String>> request = DOWNLOAD_QUEUE.poll();
                            String url = (String)request.func_76341_a();
                            Consumer callback = (Consumer)request.func_76340_b();
                            String downloaded = WebUtils.readURL(url);
                            callback.accept(downloaded);
                        }
                        Thread.sleep(10L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        });
        downloadThread.setName("LLibrary Download Thread");
        downloadThread.setDaemon(true);
        downloadThread.start();
    }
}

