/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.network;

import com.google.common.collect.SetMultimap;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.server.network.AbstractMessage;
import net.ilexiconn.llibrary.server.network.NetworkWrapper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModClassLoader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public enum NetworkHandler {
    INSTANCE;

    private Map<SimpleNetworkWrapper, Integer> idMap = new HashMap<SimpleNetworkWrapper, Integer>();

    public <T extends AbstractMessage<T>> void registerMessage(SimpleNetworkWrapper networkWrapper, Class<T> clazz) {
        try {
            AbstractMessage message = (AbstractMessage)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (message.registerOnSide(Side.CLIENT)) {
                this.registerMessage(networkWrapper, clazz, Side.CLIENT);
            }
            if (message.registerOnSide(Side.SERVER)) {
                this.registerMessage(networkWrapper, clazz, Side.SERVER);
            }
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public <T extends AbstractMessage<T>> void registerMessage(SimpleNetworkWrapper networkWrapper, Class<T> clazz, Side side) {
        int id = 0;
        if (this.idMap.containsKey(networkWrapper)) {
            id = this.idMap.get(networkWrapper);
        }
        networkWrapper.registerMessage(clazz, clazz, id, side);
        this.idMap.put(networkWrapper, id + 1);
    }

    public void injectNetworkWrapper(ModContainer mod, ASMDataTable data) {
        SetMultimap annotations = data.getAnnotationsFor(mod);
        if (annotations != null) {
            Set targetList = annotations.get((Object)NetworkWrapper.class.getName());
            ModClassLoader classLoader = Loader.instance().getModClassLoader();
            for (ASMDataTable.ASMData target : targetList) {
                try {
                    Class<?> targetClass = Class.forName(target.getClassName(), true, (ClassLoader)classLoader);
                    Field field = targetClass.getDeclaredField(target.getObjectName());
                    field.setAccessible(true);
                    NetworkWrapper annotation = field.getAnnotation(NetworkWrapper.class);
                    SimpleNetworkWrapper networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel(mod.getModId());
                    field.set(null, networkWrapper);
                    for (Class<? extends AbstractMessage<?>> messageClass : annotation.value()) {
                        this.registerMessage(networkWrapper, messageClass);
                    }
                }
                catch (Exception e) {
                    LLibrary.LOGGER.fatal("Failed to inject network wrapper for mod container " + mod, (Throwable)e);
                }
            }
        }
    }
}

