/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.nbt.parser;

import net.ilexiconn.llibrary.server.nbt.parser.INBTParser;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;

public enum NBTParsers implements INBTParser
{
    BOOLEAN{

        public Object parseTag(NBTBase tag) {
            return ((NBTTagByte)tag).func_150290_f() != 0;
        }

        public NBTBase parseValue(Object value) {
            return new NBTTagByte((byte)((Boolean)value != false ? 1 : 0));
        }
    }
    ,
    BYTE{

        public Object parseTag(NBTBase tag) {
            return ((NBTTagByte)tag).func_150290_f();
        }

        public NBTBase parseValue(Object value) {
            return new NBTTagByte(((Byte)value).byteValue());
        }
    }
    ,
    CHAR{

        public Object parseTag(NBTBase tag) {
            return Character.valueOf((char)((NBTTagShort)tag).func_150289_e());
        }

        public NBTBase parseValue(Object value) {
            return new NBTTagShort((short)((Character)value).charValue());
        }
    }
    ,
    SHORT{

        public Object parseTag(NBTBase tag) {
            return ((NBTTagShort)tag).func_150289_e();
        }

        public NBTBase parseValue(Object value) {
            return new NBTTagShort(((Short)value).shortValue());
        }
    }
    ,
    INTEGER{

        public Object parseTag(NBTBase tag) {
            return ((NBTTagInt)tag).func_150287_d();
        }

        public NBTBase parseValue(Object value) {
            return new NBTTagInt(((Integer)value).intValue());
        }
    }
    ,
    FLOAT{

        public Object parseTag(NBTBase tag) {
            return Float.valueOf(((NBTTagFloat)tag).func_150288_h());
        }

        public NBTBase parseValue(Object value) {
            return new NBTTagFloat(((Float)value).floatValue());
        }
    }
    ,
    LONG{

        public Object parseTag(NBTBase tag) {
            return ((NBTTagLong)tag).func_150291_c();
        }

        public NBTBase parseValue(Object value) {
            return new NBTTagLong(((Long)value).longValue());
        }
    }
    ,
    DOUBLE{

        public Object parseTag(NBTBase tag) {
            return ((NBTTagDouble)tag).func_150286_g();
        }

        public NBTBase parseValue(Object value) {
            return new NBTTagDouble(((Double)value).doubleValue());
        }
    }
    ,
    STRING{

        public Object parseTag(NBTBase tag) {
            return ((NBTTagString)tag).func_150285_a_();
        }

        public NBTBase parseValue(Object value) {
            return new NBTTagString((String)value);
        }
    }
    ,
    BOOLEAN_ARRAY{

        public Object parseTag(NBTBase tag) {
            NBTTagCompound list = (NBTTagCompound)tag;
            Boolean[] boolArray = new Boolean[list.func_74762_e("length")];
            byte[] boolList = list.func_74770_j("array");
            for (int i = 0; i < boolArray.length; ++i) {
                boolArray[i] = (boolList[i / 8] >>> i % 8 & 1) != 0;
            }
            return boolArray;
        }

        public NBTBase parseValue(Object value) {
            Boolean[] valueBoolArray = (Boolean[])value;
            byte[] valueByteArray = new byte[(valueBoolArray.length + 7) / 8];
            for (int i = 0; i < valueBoolArray.length; ++i) {
                int n = i / 8;
                valueByteArray[n] = (byte)(valueByteArray[n] | (byte)((valueBoolArray[i] != false ? 1 : 0) << i % 8));
            }
            NBTTagCompound byteArrayCompound = new NBTTagCompound();
            byteArrayCompound.func_74768_a("length", valueBoolArray.length);
            byteArrayCompound.func_74773_a("array", valueByteArray);
            return byteArrayCompound;
        }
    }
    ,
    BOOLEAN_ARRAY_PRIM{

        public Object parseTag(NBTBase tag) {
            NBTTagCompound list = (NBTTagCompound)tag;
            boolean[] boolArray = new boolean[list.func_74762_e("length")];
            byte[] boolList = list.func_74770_j("array");
            for (int i = 0; i < boolArray.length; ++i) {
                boolArray[i] = (boolList[i / 8] >>> i % 8 & 1) != 0;
            }
            return boolArray;
        }

        public NBTBase parseValue(Object value) {
            boolean[] valueBoolArray = (boolean[])value;
            byte[] valueByteArray = new byte[(valueBoolArray.length + 7) / 8];
            for (int i = 0; i < valueBoolArray.length; ++i) {
                int n = i / 8;
                valueByteArray[n] = (byte)(valueByteArray[n] | (byte)((valueBoolArray[i] ? 1 : 0) << i % 8));
            }
            NBTTagCompound byteArrayCompound = new NBTTagCompound();
            byteArrayCompound.func_74768_a("length", valueBoolArray.length);
            byteArrayCompound.func_74773_a("array", valueByteArray);
            return byteArrayCompound;
        }
    }
    ,
    BYTE_ARRAY{

        public Object parseTag(NBTBase tag) {
            byte[] bytePrimArray = ((NBTTagByteArray)tag).func_150292_c();
            Byte[] byteArray = new Byte[bytePrimArray.length];
            for (int i = 0; i < byteArray.length; ++i) {
                byteArray[i] = bytePrimArray[i];
            }
            return byteArray;
        }

        public NBTBase parseValue(Object value) {
            Byte[] valueByteArray = (Byte[])value;
            byte[] valuePrimByteArray = new byte[valueByteArray.length];
            for (int i = 0; i < valueByteArray.length; ++i) {
                valuePrimByteArray[i] = valueByteArray[i];
            }
            return new NBTTagByteArray(valuePrimByteArray);
        }
    }
    ,
    BYTE_ARRAY_PRIM{

        public Object parseTag(NBTBase tag) {
            return ((NBTTagByteArray)tag).func_150292_c();
        }

        public NBTBase parseValue(Object value) {
            return new NBTTagByteArray((byte[])value);
        }
    }
    ,
    CHAR_ARRAY{

        public Object parseTag(NBTBase tag) {
            NBTTagList charList = (NBTTagList)tag;
            Character[] charArray = new Character[charList.func_74745_c()];
            for (int i = 0; i < charArray.length; ++i) {
                charArray[i] = Character.valueOf((char)((NBTTagShort)charList.func_179238_g(i)).func_150289_e());
            }
            return charArray;
        }

        public NBTBase parseValue(Object value) {
            Character[] valueCharArray = (Character[])value;
            NBTTagList list = new NBTTagList();
            for (Character aValueCharArray : valueCharArray) {
                list.func_74742_a((NBTBase)new NBTTagShort((short)aValueCharArray.charValue()));
            }
            return list;
        }
    }
    ,
    CHAR_ARRAY_PRIM{

        public Object parseTag(NBTBase tag) {
            NBTTagList charList = (NBTTagList)tag;
            char[] charArray = new char[charList.func_74745_c()];
            for (int i = 0; i < charArray.length; ++i) {
                charArray[i] = (char)((NBTTagShort)charList.func_179238_g(i)).func_150289_e();
            }
            return charArray;
        }

        public NBTBase parseValue(Object value) {
            char[] valueCharArray = (char[])value;
            NBTTagList list = new NBTTagList();
            char[] cArray = valueCharArray;
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character aValueCharArray = Character.valueOf(cArray[i]);
                list.func_74742_a((NBTBase)new NBTTagShort((short)aValueCharArray.charValue()));
            }
            return list;
        }
    }
    ,
    SHORT_ARRAY{

        public Object parseTag(NBTBase tag) {
            NBTTagList charList = (NBTTagList)tag;
            Short[] charArray = new Short[charList.func_74745_c()];
            for (int i = 0; i < charArray.length; ++i) {
                charArray[i] = ((NBTTagShort)charList.func_179238_g(i)).func_150289_e();
            }
            return charArray;
        }

        public NBTBase parseValue(Object value) {
            Short[] valueShortArray = (Short[])value;
            NBTTagList list = new NBTTagList();
            for (Short aValueShortArray : valueShortArray) {
                list.func_74742_a((NBTBase)new NBTTagShort(aValueShortArray.shortValue()));
            }
            return list;
        }
    }
    ,
    SHORT_ARRAY_PRIM{

        public Object parseTag(NBTBase tag) {
            NBTTagList charList = (NBTTagList)tag;
            short[] charArray = new short[charList.func_74745_c()];
            for (int i = 0; i < charArray.length; ++i) {
                charArray[i] = ((NBTTagShort)charList.func_179238_g(i)).func_150289_e();
            }
            return charArray;
        }

        public NBTBase parseValue(Object value) {
            short[] valueShortArray = (short[])value;
            NBTTagList list = new NBTTagList();
            short[] sArray = valueShortArray;
            int n = sArray.length;
            for (int i = 0; i < n; ++i) {
                Short aValueShortArray = sArray[i];
                list.func_74742_a((NBTBase)new NBTTagShort(aValueShortArray.shortValue()));
            }
            return list;
        }
    }
    ,
    INTEGER_ARRAY{

        public Object parseTag(NBTBase tag) {
            NBTTagIntArray intList = (NBTTagIntArray)tag;
            int[] intPrimArray = intList.func_150302_c();
            Integer[] intArray = new Integer[intPrimArray.length];
            for (int i = 0; i < intArray.length; ++i) {
                intArray[i] = intPrimArray[i];
            }
            return intArray;
        }

        public NBTBase parseValue(Object value) {
            Integer[] valueIntArray = (Integer[])value;
            int[] valuePrimIntArray = new int[valueIntArray.length];
            for (int i = 0; i < valueIntArray.length; ++i) {
                valuePrimIntArray[i] = valueIntArray[i];
            }
            return new NBTTagIntArray(valuePrimIntArray);
        }
    }
    ,
    INTEGER_ARRAY_PRIM{

        public Object parseTag(NBTBase tag) {
            return ((NBTTagIntArray)tag).func_150302_c();
        }

        public NBTBase parseValue(Object value) {
            return new NBTTagIntArray((int[])value);
        }
    }
    ,
    FLOAT_ARRAY{

        public Object parseTag(NBTBase tag) {
            NBTTagList floatList = (NBTTagList)tag;
            Float[] floatArray = new Float[floatList.func_74745_c()];
            for (int i = 0; i < floatArray.length; ++i) {
                floatArray[i] = Float.valueOf(((NBTTagFloat)floatList.func_179238_g(i)).func_150288_h());
            }
            return floatArray;
        }

        public NBTBase parseValue(Object value) {
            Float[] valueFloatArray = (Float[])value;
            NBTTagList list = new NBTTagList();
            for (Float aValueFloatArray : valueFloatArray) {
                list.func_74742_a((NBTBase)new NBTTagFloat(aValueFloatArray.floatValue()));
            }
            return list;
        }
    }
    ,
    FLOAT_ARRAY_PRIM{

        public Object parseTag(NBTBase tag) {
            NBTTagList floatList = (NBTTagList)tag;
            float[] floatArray = new float[floatList.func_74745_c()];
            for (int i = 0; i < floatArray.length; ++i) {
                floatArray[i] = ((NBTTagFloat)floatList.func_179238_g(i)).func_150288_h();
            }
            return floatArray;
        }

        public NBTBase parseValue(Object value) {
            float[] valueFloatArray = (float[])value;
            NBTTagList list = new NBTTagList();
            for (float aValueFloatArray : valueFloatArray) {
                list.func_74742_a((NBTBase)new NBTTagFloat(aValueFloatArray));
            }
            return list;
        }
    }
    ,
    LONG_ARRAY{

        public Object parseTag(NBTBase tag) {
            NBTTagList longList = (NBTTagList)tag;
            Long[] longArray = new Long[longList.func_74745_c()];
            for (int i = 0; i < longArray.length; ++i) {
                longArray[i] = ((NBTTagLong)longList.func_179238_g(i)).func_150291_c();
            }
            return longArray;
        }

        public NBTBase parseValue(Object value) {
            Long[] valueLongArray = (Long[])value;
            NBTTagList list = new NBTTagList();
            for (Long aValueLongArray : valueLongArray) {
                list.func_74742_a((NBTBase)new NBTTagLong(aValueLongArray.longValue()));
            }
            return list;
        }
    }
    ,
    LONG_ARRAY_PRIM{

        public Object parseTag(NBTBase tag) {
            NBTTagList longList = (NBTTagList)tag;
            long[] longArray = new long[longList.func_74745_c()];
            for (int i = 0; i < longArray.length; ++i) {
                longArray[i] = ((NBTTagLong)longList.func_179238_g(i)).func_150291_c();
            }
            return longArray;
        }

        public NBTBase parseValue(Object value) {
            long[] valueLongArray = (long[])value;
            NBTTagList list = new NBTTagList();
            for (long aValueLongArray : valueLongArray) {
                list.func_74742_a((NBTBase)new NBTTagLong(aValueLongArray));
            }
            return list;
        }
    }
    ,
    DOUBLE_ARRAY{

        public Object parseTag(NBTBase tag) {
            NBTTagList doubleList = (NBTTagList)tag;
            Double[] doubleArray = new Double[doubleList.func_74745_c()];
            for (int i = 0; i < doubleArray.length; ++i) {
                doubleArray[i] = ((NBTTagDouble)doubleList.func_179238_g(i)).func_150286_g();
            }
            return doubleArray;
        }

        public NBTBase parseValue(Object value) {
            Double[] valueDoubleArray = (Double[])value;
            NBTTagList list = new NBTTagList();
            for (Double aValueDoubleArray : valueDoubleArray) {
                list.func_74742_a((NBTBase)new NBTTagDouble(aValueDoubleArray.doubleValue()));
            }
            return list;
        }
    }
    ,
    DOUBLE_ARRAY_PRIM{

        public Object parseTag(NBTBase tag) {
            NBTTagList doubleList = (NBTTagList)tag;
            double[] doubleArray = new double[doubleList.func_74745_c()];
            for (int i = 0; i < doubleArray.length; ++i) {
                doubleArray[i] = ((NBTTagDouble)doubleList.func_179238_g(i)).func_150286_g();
            }
            return doubleArray;
        }

        public NBTBase parseValue(Object value) {
            double[] valueDoubleArray = (double[])value;
            NBTTagList list = new NBTTagList();
            for (double aValueDoubleArray : valueDoubleArray) {
                list.func_74742_a((NBTBase)new NBTTagDouble(aValueDoubleArray));
            }
            return list;
        }
    }
    ,
    STRING_ARRAY{

        public Object parseTag(NBTBase tag) {
            NBTTagList stringList = (NBTTagList)tag;
            String[] stringArray = new String[stringList.func_74745_c()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = ((NBTTagString)stringList.func_179238_g(i)).func_150285_a_();
            }
            return stringArray;
        }

        public NBTBase parseValue(Object value) {
            String[] valueStringArray = (String[])value;
            NBTTagList list = new NBTTagList();
            for (String aValueStringArray : valueStringArray) {
                list.func_74742_a((NBTBase)new NBTTagString(aValueStringArray));
            }
            return list;
        }
    }
    ,
    ITEM_STACK{

        public Object parseTag(NBTBase tag) {
            return ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)tag));
        }

        public NBTBase parseValue(Object value) {
            NBTTagCompound itemStackCompound = new NBTTagCompound();
            ((ItemStack)value).func_77955_b(itemStackCompound);
            return itemStackCompound;
        }
    }
    ,
    BLOCK_POS{

        public Object parseTag(NBTBase tag) {
            NBTTagCompound blockPosCompound = (NBTTagCompound)tag;
            return new BlockPos(blockPosCompound.func_74762_e("x"), blockPosCompound.func_74762_e("y"), blockPosCompound.func_74762_e("z"));
        }

        public NBTBase parseValue(Object value) {
            NBTTagCompound blockPosCompound = new NBTTagCompound();
            blockPosCompound.func_74768_a("x", ((BlockPos)value).func_177958_n());
            blockPosCompound.func_74768_a("y", ((BlockPos)value).func_177956_o());
            blockPosCompound.func_74768_a("z", ((BlockPos)value).func_177952_p());
            return blockPosCompound;
        }
    };


    public static <V, T extends NBTBase> INBTParser<V, T> getBuiltinParser(Class<V> type) {
        if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
            return BOOLEAN;
        }
        if (Byte.class.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type)) {
            return BYTE;
        }
        if (Character.class.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type)) {
            return CHAR;
        }
        if (Short.class.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type)) {
            return SHORT;
        }
        if (Integer.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type)) {
            return INTEGER;
        }
        if (Float.class.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type)) {
            return FLOAT;
        }
        if (Long.class.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type)) {
            return LONG;
        }
        if (Double.class.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type)) {
            return DOUBLE;
        }
        if (String.class.isAssignableFrom(type)) {
            return STRING;
        }
        if (Boolean[].class.isAssignableFrom(type)) {
            return BOOLEAN_ARRAY;
        }
        if (Byte[].class.isAssignableFrom(type)) {
            return BYTE_ARRAY;
        }
        if (Character[].class.isAssignableFrom(type)) {
            return CHAR_ARRAY;
        }
        if (Short[].class.isAssignableFrom(type)) {
            return SHORT_ARRAY;
        }
        if (Integer[].class.isAssignableFrom(type)) {
            return INTEGER_ARRAY;
        }
        if (Float[].class.isAssignableFrom(type)) {
            return FLOAT_ARRAY;
        }
        if (Long[].class.isAssignableFrom(type)) {
            return LONG_ARRAY;
        }
        if (Double[].class.isAssignableFrom(type)) {
            return DOUBLE_ARRAY;
        }
        if (boolean[].class.isAssignableFrom(type)) {
            return BOOLEAN_ARRAY_PRIM;
        }
        if (byte[].class.isAssignableFrom(type)) {
            return BYTE_ARRAY_PRIM;
        }
        if (char[].class.isAssignableFrom(type)) {
            return CHAR_ARRAY_PRIM;
        }
        if (short[].class.isAssignableFrom(type)) {
            return SHORT_ARRAY_PRIM;
        }
        if (int[].class.isAssignableFrom(type)) {
            return INTEGER_ARRAY_PRIM;
        }
        if (float[].class.isAssignableFrom(type)) {
            return FLOAT_ARRAY_PRIM;
        }
        if (long[].class.isAssignableFrom(type)) {
            return LONG_ARRAY_PRIM;
        }
        if (double[].class.isAssignableFrom(type)) {
            return DOUBLE_ARRAY_PRIM;
        }
        if (String[].class.isAssignableFrom(type)) {
            return STRING_ARRAY;
        }
        if (type == ItemStack.class) {
            return ITEM_STACK;
        }
        if (type == BlockPos.class) {
            return BLOCK_POS;
        }
        return null;
    }
}

