/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.server.asm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.ilexiconn.llibrary.server.asm.MappingHandler;
import net.ilexiconn.llibrary.server.asm.Method;
import net.ilexiconn.llibrary.server.asm.MethodPatcher;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassPatcher {
    private static final Map<String, String> PRIMITIVE_NAMES = new HashMap<String, String>();
    private String cls;
    private Map<String, MethodPatcher> patcherMap = new HashMap<String, MethodPatcher>();
    private Map<String, Consumer<Method>> creationMap = new HashMap<String, Consumer<Method>>();
    private List<String> removeList = new ArrayList<String>();

    public ClassPatcher(String cls) {
        this.cls = cls;
    }

    void handlePatches(ClassNode classNode) {
        String method;
        FMLRelaunchLog.info((String)("Patching class " + this.cls), (Object[])new Object[0]);
        for (Map.Entry<String, Consumer<Method>> entry : this.creationMap.entrySet()) {
            FMLRelaunchLog.info((String)("   Adding method " + entry.getKey()), (Object[])new Object[0]);
            method = entry.getKey().substring(0, entry.getKey().indexOf("("));
            String desc = entry.getKey().substring(method.length());
            MethodNode methodNode = new MethodNode(1, method, desc, null, null);
            Method m = new Method(this, null);
            entry.getValue().accept(m);
            methodNode.instructions.add(m.insnList);
            classNode.methods.add(methodNode);
        }
        for (MethodNode methodNode : new ArrayList(classNode.methods)) {
            method = methodNode.name + methodNode.desc;
            if (this.removeList.contains(method)) {
                FMLRelaunchLog.info((String)("   Removing method " + method), (Object[])new Object[0]);
                classNode.methods.remove(methodNode);
                continue;
            }
            MethodPatcher patcher = this.patcherMap.get(method);
            if (patcher == null) continue;
            patcher.handlePatches(methodNode);
        }
    }

    public MethodPatcher patchMethod(String method, Object ... params) {
        String desc = MappingHandler.INSTANCE.getClassMapping(this.methodDesc(params));
        method = MappingHandler.INSTANCE.getMethodMapping(this.cls, method, desc) + desc;
        MethodPatcher patcher = new MethodPatcher(this, this.cls, method);
        this.patcherMap.put(method, patcher);
        return patcher;
    }

    public ClassPatcher createMethod(String method, Object[] params, Consumer<Method> consumer) {
        String desc = MappingHandler.INSTANCE.getClassMapping(this.methodDesc(params));
        method = MappingHandler.INSTANCE.getMethodMapping(this.cls, method, desc) + desc;
        this.creationMap.put(method, consumer);
        return this;
    }

    public ClassPatcher removeMethod(String method, Object ... params) {
        String desc = MappingHandler.INSTANCE.getClassMapping(this.methodDesc(params));
        method = MappingHandler.INSTANCE.getMethodMapping(this.cls, method, desc) + desc;
        this.removeList.add(method);
        return this;
    }

    String methodDesc(Object ... params) {
        if (params.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder("(");
        for (int i = 0; i < params.length - 1; ++i) {
            Object obj = params[i];
            if (obj instanceof Integer) {
                String desc = this.fieldDesc(params[++i]);
                int k = (Integer)obj;
                for (int j = 0; j < k; ++j) {
                    builder.append(desc);
                }
                continue;
            }
            builder.append(this.fieldDesc(obj));
        }
        builder.append(")").append(this.fieldDesc(params[params.length - 1]));
        return builder.toString();
    }

    String fieldDesc(Object obj) {
        Object cls;
        String result = "";
        String suffix = "";
        if (obj instanceof String) {
            cls = MappingHandler.INSTANCE.getClassMapping((String)obj);
            result = PRIMITIVE_NAMES.get(cls);
            if (result == null) {
                result = "L" + (String)cls;
                suffix = ";";
            }
        } else if (obj instanceof Class && (result = PRIMITIVE_NAMES.get(((Class)(cls = (Class)obj)).getName())) == null) {
            if (!((Class)cls).isArray()) {
                return "L" + ((Class)cls).getName() + ";";
            }
            return ((Class)cls).getName();
        }
        while (result.endsWith("[]")) {
            result = "[" + result.substring(0, result.length() - 2);
        }
        return result + suffix;
    }

    public String toString() {
        return "class:" + this.cls + this.patcherMap.values();
    }

    static {
        PRIMITIVE_NAMES.put("void", "V");
        PRIMITIVE_NAMES.put("boolean", "Z");
        PRIMITIVE_NAMES.put("char", "C");
        PRIMITIVE_NAMES.put("byte", "B");
        PRIMITIVE_NAMES.put("short", "S");
        PRIMITIVE_NAMES.put("int", "I");
        PRIMITIVE_NAMES.put("float", "F");
        PRIMITIVE_NAMES.put("long", "J");
        PRIMITIVE_NAMES.put("double", "D");
    }
}

