/*
 * Decompiled with CFR 0.152.
 */
package net.ilexiconn.llibrary.client.gui.element;

import net.ilexiconn.llibrary.LLibrary;
import net.ilexiconn.llibrary.client.ClientProxy;
import net.ilexiconn.llibrary.client.gui.element.Element;
import net.ilexiconn.llibrary.client.gui.element.IElementGUI;
import net.ilexiconn.llibrary.client.gui.element.InputElementBase;
import net.ilexiconn.llibrary.client.gui.element.PropertyInputElement;
import net.ilexiconn.llibrary.server.property.IFloatRangeProperty;
import net.ilexiconn.llibrary.server.property.IStringProperty;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SliderElement<T extends IElementGUI, P extends IFloatRangeProperty & IStringProperty>
extends Element<T> {
    private final P value;
    private float step;
    private boolean hasSlider;
    private float sliderWidth;
    private boolean editable = true;
    private boolean dragging;
    private PropertyInputElement<T> inputElement;

    public SliderElement(T gui, float posX, float posY, P value, float step) {
        this(gui, posX, posY, 0.0f, value, step);
    }

    public SliderElement(T gui, float posX, float posY, float sliderWidth, P value, float step) {
        super(gui, posX, posY, (int)(38.0f + sliderWidth), 12);
        this.value = value;
        this.step = step;
        this.hasSlider = sliderWidth > 0.0f;
        this.sliderWidth = sliderWidth;
    }

    @Override
    public void init() {
        this.inputElement = (PropertyInputElement)new PropertyInputElement<IElementGUI>(this.gui, -1.0f, 0.0f, 28, (IStringProperty)this.value).withParent(this);
    }

    @Override
    public void render(float mouseX, float mouseY, float partialTicks) {
        float posX = this.getPosX();
        float posY = this.getPosY();
        int width = this.getWidth();
        int height = this.getHeight();
        this.drawRectangle(posX, posY, width, height, this.editable ? LLibrary.CONFIG.getSecondaryColor() : LLibrary.CONFIG.getSecondarySubcolor());
        boolean selected = this.isSelected(mouseX, mouseY);
        boolean upperSelected = this.editable && selected && mouseX >= posX + (float)width - this.sliderWidth - 11.0f && mouseY < posY + 6.0f && mouseX < posX + (float)width - this.sliderWidth;
        boolean lowerSelected = this.editable && selected && mouseX >= posX + (float)width - this.sliderWidth - 11.0f && mouseY > posY + 6.0f && mouseX < posX + (float)width - this.sliderWidth;
        this.drawRectangle(posX + (float)width - 11.0f - this.sliderWidth, posY, 11.0, 6.0, this.editable ? (upperSelected ? LLibrary.CONFIG.getDarkAccentColor() : LLibrary.CONFIG.getAccentColor()) : LLibrary.CONFIG.getTertiaryColor());
        this.drawRectangle(posX + (float)width - 11.0f - this.sliderWidth, posY + 6.0f, 11.0, 6.0, this.editable ? (lowerSelected ? LLibrary.CONFIG.getDarkAccentColor() : LLibrary.CONFIG.getAccentColor()) : LLibrary.CONFIG.getTertiaryColor());
        int textColor = LLibrary.CONFIG.getTextColor();
        this.drawRectangle(posX + (float)width - 8.0f - this.sliderWidth, posY + 4.0f, 5.0, 1.0, textColor);
        this.drawRectangle(posX + (float)width - 7.0f - this.sliderWidth, posY + 3.0f, 3.0, 1.0, textColor);
        this.drawRectangle(posX + (float)width - 6.0f - this.sliderWidth, posY + 2.0f, 1.0, 1.0, textColor);
        this.drawRectangle(posX + (float)width - 8.0f - this.sliderWidth, posY + 7.0f, 5.0, 1.0, textColor);
        this.drawRectangle(posX + (float)width - 7.0f - this.sliderWidth, posY + 8.0f, 3.0, 1.0, textColor);
        this.drawRectangle(posX + (float)width - 6.0f - this.sliderWidth, posY + 9.0f, 1.0, 1.0, textColor);
        GL11.glEnable((int)3089);
        float scaleFactor = new ScaledResolution(ClientProxy.MINECRAFT).func_78325_e();
        GL11.glScissor((int)((int)(posX * scaleFactor)), (int)((int)(((float)this.gui.getHeight() - (posY + (float)height)) * scaleFactor)), (int)((int)((float)(width - 11) * scaleFactor)), (int)((int)((float)height * scaleFactor)));
        GL11.glDisable((int)3089);
        if (this.hasSlider) {
            float offsetX = (this.sliderWidth - 4.0f) * (this.getValue() - this.value.getMinFloatValue()) / this.value.getFloatValueRange();
            boolean indicatorSelected = this.editable && selected && mouseX >= this.getPosX() + 38.0f + offsetX && mouseX <= this.getPosX() + 38.0f + offsetX + 4.0f;
            this.drawRectangle(this.getPosX() + 38.0f + offsetX, this.getPosY(), 4.0, this.getHeight(), this.editable ? (indicatorSelected ? LLibrary.CONFIG.getDarkAccentColor() : LLibrary.CONFIG.getAccentColor()) : LLibrary.CONFIG.getTertiaryColor());
        }
    }

    private boolean trySetValue(float value) {
        if (this.value.trySetFloat(value)) {
            this.inputElement.readValue();
            return true;
        }
        return false;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.inputElement.setEditable(editable);
    }

    @Deprecated
    public SliderElement<T, P> withValue(float value) {
        this.trySetValue(value);
        return this;
    }

    @Override
    public boolean mouseClicked(float mouseX, float mouseY, int button) {
        boolean lowerSelected;
        if (!this.editable) {
            return super.mouseClicked(mouseX, mouseY, button);
        }
        float offsetX = (this.sliderWidth - 4.0f) * (this.getValue() - this.value.getMinFloatValue()) / this.value.getFloatValueRange();
        boolean selected = this.isSelected(mouseX, mouseY);
        boolean indicatorSelected = selected && mouseX >= this.getPosX() + 38.0f + offsetX && mouseX <= this.getPosX() + 38.0f + offsetX + 4.0f;
        boolean upperSelected = selected && mouseX >= this.getPosX() + (float)this.getWidth() - this.sliderWidth - 11.0f && mouseY < this.getPosY() + 6.0f && mouseX < this.getPosX() + (float)this.getWidth() - this.sliderWidth;
        boolean bl = lowerSelected = selected && mouseX >= this.getPosX() + (float)this.getWidth() - this.sliderWidth - 11.0f && mouseY > this.getPosY() + 6.0f && mouseX < this.getPosX() + (float)this.getWidth() - this.sliderWidth;
        if (!indicatorSelected) {
            if (upperSelected || lowerSelected) {
                float delta = 0.0f;
                if (upperSelected) {
                    delta += this.step;
                }
                if (lowerSelected) {
                    delta -= this.step;
                }
                if (GuiScreen.func_146272_n()) {
                    delta *= 10.0f;
                }
                if (this.trySetValue(this.value.getFloat() + delta)) {
                    this.gui.playClickSound();
                    return true;
                }
            }
        } else {
            this.dragging = true;
            this.gui.playClickSound();
            return true;
        }
        return false;
    }

    private float getValue() {
        return this.value.getFloat();
    }

    @Override
    public boolean mouseDragged(float mouseX, float mouseY, int button, long timeSinceClick) {
        if (this.dragging) {
            float newValue = (mouseX - (this.getPosX() + 38.0f)) / ((float)this.getWidth() - 38.0f - 4.0f) * this.value.getFloatValueRange() + this.value.getMinFloatValue();
            if (newValue > this.value.getMaxFloatValue()) {
                newValue = this.value.getMaxFloatValue();
            }
            if (newValue < this.value.getMinFloatValue()) {
                newValue = this.value.getMinFloatValue();
            }
            this.trySetValue(newValue);
        }
        return this.dragging;
    }

    @Override
    public boolean mouseReleased(float mouseX, float mouseY, int button) {
        if (this.dragging) {
            this.gui.playClickSound();
        }
        this.dragging = false;
        return false;
    }

    public InputElementBase getValueInput() {
        return this.inputElement;
    }
}

