/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.item.crafting;

import com.attributestudios.wolfarmor.item.ItemWolfArmor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;

public class RecipeWolfArmorDyes
implements IRecipe {
    public boolean func_77569_a(@Nonnull InventoryCrafting inventoryCrafting, @Nonnull World world) {
        ItemStack armorItem = null;
        ArrayList<ItemStack> dyes = new ArrayList<ItemStack>();
        for (int slotIndex = 0; slotIndex < inventoryCrafting.func_70302_i_(); ++slotIndex) {
            ItemStack stackInSlot = inventoryCrafting.func_70301_a(slotIndex);
            if (stackInSlot == null) continue;
            if (stackInSlot.func_77973_b() instanceof ItemWolfArmor) {
                ItemWolfArmor wolfArmorItem = (ItemWolfArmor)stackInSlot.func_77973_b();
                if (!wolfArmorItem.getMaterial().getIsDyeable() || armorItem != null) {
                    return false;
                }
                armorItem = stackInSlot;
                continue;
            }
            if (this.getDyeEquivalent(stackInSlot) < 0) {
                return false;
            }
            dyes.add(stackInSlot);
        }
        return armorItem != null && !dyes.isEmpty();
    }

    private int getDyeEquivalent(@Nullable ItemStack stack) {
        int dyeEquivalent = -1;
        if (stack != null) {
            int[] oreIds;
            block0: for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
                String oreName = OreDictionary.getOreName((int)oreId);
                List ores = OreDictionary.getOres((String)oreName);
                for (ItemStack oreStack : ores) {
                    if (oreStack.func_77973_b() != Items.field_151100_aR || oreStack.func_77952_i() == Short.MAX_VALUE) continue;
                    dyeEquivalent = oreStack.func_77952_i();
                    continue block0;
                }
            }
        }
        return dyeEquivalent;
    }

    @Nullable
    public ItemStack func_77572_b(@Nonnull InventoryCrafting inventoryCrafting) {
        int rgb;
        ItemStack stack = null;
        int[] color = new int[3];
        int rgbMax = 0;
        int count = 0;
        ItemWolfArmor itemArmor = null;
        for (int slotIndex = 0; slotIndex < inventoryCrafting.func_70302_i_(); ++slotIndex) {
            ItemStack stackInSlot = inventoryCrafting.func_70301_a(slotIndex);
            if (stackInSlot == null) continue;
            if (stackInSlot.func_77973_b() instanceof ItemWolfArmor) {
                itemArmor = (ItemWolfArmor)stackInSlot.func_77973_b();
                if (!itemArmor.getMaterial().getIsDyeable() || stack != null) {
                    return null;
                }
                stack = stackInSlot.func_77946_l();
                stack.field_77994_a = 1;
                if (!itemArmor.getHasColor(stackInSlot)) continue;
                rgb = itemArmor.getColor(stackInSlot);
                float[] existingColor = new float[]{(float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
                rgbMax = (int)((float)rgbMax + Math.max(existingColor[0], Math.max(existingColor[1], existingColor[2])) * 255.0f);
                color[0] = (int)((float)color[0] + existingColor[0] * 255.0f);
                color[1] = (int)((float)color[1] + existingColor[1] * 255.0f);
                color[2] = (int)((float)color[2] + existingColor[2] * 255.0f);
                ++count;
                continue;
            }
            int dyeEquivalent = this.getDyeEquivalent(stackInSlot);
            if (dyeEquivalent < 0) {
                return null;
            }
            float[] fleeceColor = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176766_a((int)dyeEquivalent));
            int[] dye = new int[]{(int)(fleeceColor[0] * 255.0f), (int)(fleeceColor[1] * 255.0f), (int)(fleeceColor[2] * 255.0f)};
            rgbMax += Math.max(dye[0], Math.max(dye[1], dye[2]));
            color[0] = color[0] + dye[0];
            color[1] = color[1] + dye[1];
            color[2] = color[2] + dye[2];
            ++count;
        }
        if (itemArmor == null) {
            return null;
        }
        int redAvg = color[0] / count;
        int greenAvg = color[1] / count;
        int blueAvg = color[2] / count;
        float rgbAvg = (float)rgbMax / (float)count;
        float rgbAvgMax = Math.max(redAvg, Math.max(greenAvg, blueAvg));
        int red = (int)((float)redAvg * rgbAvg / rgbAvgMax);
        int green = (int)((float)greenAvg * rgbAvg / rgbAvgMax);
        int blue = (int)((float)blueAvg * rgbAvg / rgbAvgMax);
        rgb = ((red << 8) + green << 8) + blue;
        itemArmor.setColor(stack, rgb);
        return stack;
    }

    @Nonnegative
    public int func_77570_a() {
        return 10;
    }

    @Nullable
    public ItemStack func_77571_b() {
        return null;
    }

    @Nonnull
    public ItemStack[] func_179532_b(@Nonnull InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }
}

