/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.item;

import com.attributestudios.wolfarmor.entity.passive.EntityWolfArmored;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWolfArmor
extends Item {
    private static final String NBT_TAG_DISPLAY = "display";
    private static final String NBT_TAG_COLOR = "color";
    private static final IBehaviorDispenseItem DISPENSE_ITEM = new BehaviorDefaultDispenseItem(){

        @Nonnull
        protected ItemStack func_82487_b(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
            ItemStack itemStack = ItemWolfArmor.dispenseWolfArmor(source, stack);
            return itemStack != null ? itemStack : super.func_82487_b(source, stack);
        }
    };
    private final WolfArmorMaterial material;

    public ItemWolfArmor(@Nonnull WolfArmorMaterial material) {
        this.material = material;
        this.field_77777_bU = 1;
        this.canRepair = true;
        this.func_77656_e(material.getDurability());
        this.func_77637_a(CreativeTabs.field_78026_f);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)DISPENSE_ITEM);
    }

    public void removeColor(@Nullable ItemStack stack) {
        NBTTagCompound stackCompound;
        if (stack != null && this.material.getIsDyeable() && this.getHasColor(stack) && (stackCompound = stack.func_77978_p()) != null) {
            stackCompound.func_74775_l(NBT_TAG_DISPLAY).func_82580_o(NBT_TAG_COLOR);
        }
    }

    @Nullable
    private static ItemStack dispenseWolfArmor(@Nonnull IBlockSource source, @Nonnull ItemStack stack) {
        BlockPos blockPos = source.func_180699_d().func_177972_a((EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a));
        List wolves = source.func_82618_k().func_72872_a(EntityWolfArmored.class, new AxisAlignedBB(blockPos));
        if (!wolves.isEmpty()) {
            EntityWolfArmored wolf = null;
            for (EntityWolfArmored entity : wolves) {
                if (!entity.func_70909_n() || entity.func_70631_g_()) continue;
                wolf = entity;
                break;
            }
            if (wolf != null) {
                ItemStack copyStack = stack.func_77946_l();
                copyStack.field_77994_a = 1;
                if (!wolf.equipArmor(copyStack)) {
                    return null;
                }
                --stack.field_77994_a;
            }
        }
        return stack;
    }

    public int func_77619_b() {
        return this.getMaterial().getEnchantability();
    }

    public boolean func_82789_a(@Nonnull ItemStack originalStack, @Nonnull ItemStack repairStack) {
        return this.getMaterial().getRepairItem() == repairStack.func_77973_b() || super.func_82789_a(originalStack, repairStack);
    }

    public boolean getHasOverlay(@Nullable ItemStack stack) {
        return this.getMaterial().getHasOverlay() || this.getColor(stack) != -1;
    }

    public boolean getHasColor(@Nullable ItemStack stack) {
        NBTTagCompound tagCompound;
        if (stack != null && this.getMaterial().getIsDyeable() && stack.func_77942_o() && (tagCompound = stack.func_77978_p()) != null && tagCompound.func_74764_b(NBT_TAG_DISPLAY)) {
            NBTTagCompound display = tagCompound.func_74775_l(NBT_TAG_DISPLAY);
            return display.func_74764_b(NBT_TAG_COLOR);
        }
        return false;
    }

    public int getColor(@Nullable ItemStack stack) {
        NBTTagCompound display;
        if (!this.getMaterial().getIsDyeable() || stack == null) {
            return -1;
        }
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && (display = tagCompound.func_74775_l(NBT_TAG_DISPLAY)).func_74764_b(NBT_TAG_COLOR)) {
            return display.func_74762_e(NBT_TAG_COLOR);
        }
        return this.getMaterial().getDefaultColor();
    }

    public void setColor(@Nullable ItemStack stack, int color) {
        if (!this.material.getIsDyeable()) {
            throw new UnsupportedOperationException("Wolf armor material is not dyeable!");
        }
        if (stack != null) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound == null) {
                tagCompound = new NBTTagCompound();
                stack.func_77982_d(tagCompound);
            }
            NBTTagCompound display = tagCompound.func_74775_l(NBT_TAG_DISPLAY);
            if (!tagCompound.func_74764_b(NBT_TAG_DISPLAY)) {
                tagCompound.func_74782_a(NBT_TAG_DISPLAY, (NBTBase)display);
            }
            display.func_74768_a(NBT_TAG_COLOR, color);
        }
    }

    public WolfArmorMaterial getMaterial() {
        return this.material;
    }

    public int getDamageReductionAmount() {
        return this.getMaterial().getDamageReductionAmount();
    }

    public static enum WolfArmorMaterial {
        CLOTH("leather", 80, 6, 15, true, 10511680, SoundEvents.field_187728_s, true),
        CHAINMAIL("chain", 240, 12, 12, false, 0xFFFFFF, SoundEvents.field_187713_n, false),
        IRON("iron", 240, 15, 9, false, 0xFFFFFF, SoundEvents.field_187725_r, false),
        GOLD("gold", 112, 12, 25, false, 0xFFFFFF, SoundEvents.field_187722_q, false),
        DIAMOND("diamond", 528, 20, 10, false, 0xFFFFFF, SoundEvents.field_187716_o, false);

        private final String name;
        private final int defaultColor;
        private final int durability;
        private final int damageReductionAmount;
        private final int enchantability;
        private final boolean isDyeable;
        private final boolean hasOverlay;
        private final SoundEvent equipSound;

        private WolfArmorMaterial(String name, int durability, int damageReductionAmount, int enchantability, @Nonnull boolean isDyeable, int defaultColor, SoundEvent equipSound, boolean hasOverlay) {
            this.name = name;
            this.durability = durability;
            this.damageReductionAmount = damageReductionAmount;
            this.enchantability = enchantability;
            this.isDyeable = isDyeable;
            this.defaultColor = defaultColor;
            this.equipSound = equipSound;
            this.hasOverlay = hasOverlay;
        }

        public int getDefaultColor() {
            return this.defaultColor;
        }

        @Nonnull
        public SoundEvent getEquipSound() {
            return this.equipSound;
        }

        public int getDurability() {
            return this.durability;
        }

        public int getDamageReductionAmount() {
            return this.damageReductionAmount;
        }

        public int getEnchantability() {
            return this.enchantability;
        }

        public boolean getIsDyeable() {
            return this.isDyeable;
        }

        public boolean getHasOverlay() {
            return this.hasOverlay;
        }

        @SideOnly(value=Side.CLIENT)
        @Nonnull
        public String getName() {
            return this.name;
        }

        public static int getMaxArmorValue() {
            int damageReduce = 0;
            for (WolfArmorMaterial wolfArmorMaterial : WolfArmorMaterial.values()) {
                damageReduce = Math.max(damageReduce, wolfArmorMaterial.damageReductionAmount);
            }
            return damageReduce;
        }

        @Nullable
        public Item getRepairItem() {
            switch (this) {
                case CLOTH: {
                    return Items.field_151116_aA;
                }
                case CHAINMAIL: 
                case IRON: {
                    return Items.field_151042_j;
                }
                case GOLD: {
                    return Items.field_151043_k;
                }
                case DIAMOND: {
                    return Items.field_151045_i;
                }
            }
            return null;
        }
    }
}

