/*
 * Decompiled with CFR 0.152.
 */
package com.attributestudios.wolfarmor.entity.passive;

import com.attributestudios.wolfarmor.WolfArmorMod;
import com.attributestudios.wolfarmor.item.ItemWolfArmor;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIBeg;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.AnimalChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityWolfArmored
extends EntityWolf
implements IInventoryChangedListener {
    private AnimalChest inventory;
    private static final String NBT_TAG_HAS_CHEST = "hasChest";
    private static final String NBT_TAG_SLOT = "slot";
    private static final String NBT_TAG_INVENTORY = "inventory";
    private static final String NBT_TAG_ARMOR_ITEM = "armorItem";
    private static final int INVENTORY_WOLF_MAX_SIZE = 7;
    private static final DataParameter<Byte> HAS_CHEST = EntityDataManager.func_187226_a(EntityWolfArmored.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Optional<ItemStack>> ARMOR_ITEM = EntityDataManager.func_187226_a(EntityWolfArmored.class, (DataSerializer)DataSerializers.field_187196_f);

    public EntityWolfArmored(@Nonnull World world) {
        super(world);
        this.inventoryInit();
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIBeg((EntityWolf)this, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetNonTamed((EntityTameable)this, EntityAnimal.class, false, (Predicate)new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity instanceof EntitySheep || entity instanceof EntityRabbit;
            }
        }));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntitySkeleton.class, false));
    }

    protected void inventoryInit() {
        AnimalChest inventoryExisting = this.inventory;
        this.inventory = new AnimalChest("container.wolfarmor.wolf", this.getMaxSizeInventory());
        String customName = this.func_95999_t();
        if (!customName.isEmpty()) {
            this.inventory.func_110133_a(customName);
        }
        if (inventoryExisting != null) {
            inventoryExisting.func_110132_b((IInventoryChangedListener)this);
            int numberOfItemsExisting = Math.min(this.inventory.func_70302_i_(), inventoryExisting.func_70302_i_());
            for (int slotIndex = 0; slotIndex < numberOfItemsExisting; ++slotIndex) {
                ItemStack stackInSlot = inventoryExisting.func_70301_a(slotIndex);
                if (stackInSlot == null) continue;
                this.inventory.func_70299_a(slotIndex, stackInSlot.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.inventory.func_70296_d();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HAS_CHEST, (Object)0);
        this.field_70180_af.func_187214_a(ARMOR_ITEM, (Object)Optional.absent());
    }

    public void func_70014_b(@Nonnull NBTTagCompound tags) {
        super.func_70014_b(tags);
        boolean entityHasChest = this.getHasChest();
        boolean entityHasArmor = this.getHasArmor();
        tags.func_74757_a(NBT_TAG_HAS_CHEST, entityHasChest);
        if (entityHasChest) {
            NBTTagList inventoryItemsTagList = new NBTTagList();
            for (byte slotIndex = 0; slotIndex < this.getInventory().func_70302_i_(); slotIndex = (byte)((byte)(slotIndex + 1))) {
                ItemStack stackInSlot = this.getInventory().func_70301_a((int)slotIndex);
                if (stackInSlot == null) continue;
                NBTTagCompound slotTag = new NBTTagCompound();
                slotTag.func_74774_a(NBT_TAG_SLOT, slotIndex);
                stackInSlot.func_77955_b(slotTag);
                inventoryItemsTagList.func_74742_a((NBTBase)slotTag);
            }
            tags.func_74782_a(NBT_TAG_INVENTORY, (NBTBase)inventoryItemsTagList);
        }
        if (entityHasArmor) {
            ItemStack armorItem = this.getArmorItemStack();
            if (armorItem != null) {
                tags.func_74782_a(NBT_TAG_ARMOR_ITEM, (NBTBase)armorItem.func_77955_b(new NBTTagCompound()));
            } else {
                tags.func_82580_o(NBT_TAG_ARMOR_ITEM);
            }
        }
    }

    public void func_70037_a(@Nonnull NBTTagCompound tags) {
        NBTTagCompound armorTags;
        super.func_70037_a(tags);
        boolean entityHasChest = tags.func_150297_b(NBT_TAG_HAS_CHEST, 1) && tags.func_74767_n(NBT_TAG_HAS_CHEST);
        this.setHasChest(entityHasChest);
        if (entityHasChest) {
            this.inventoryInit();
            NBTTagList inventoryItemsTagList = tags.func_150295_c(NBT_TAG_INVENTORY, 10);
            for (int tagIndex = 0; tagIndex < inventoryItemsTagList.func_74745_c(); ++tagIndex) {
                NBTTagCompound itemTag = inventoryItemsTagList.func_150305_b(tagIndex);
                byte slotIndex = itemTag.func_74771_c(NBT_TAG_SLOT);
                if (slotIndex >= this.inventory.func_70302_i_()) continue;
                this.inventory.func_70299_a((int)slotIndex, ItemStack.func_77949_a((NBTTagCompound)itemTag));
            }
        }
        if (!(armorTags = tags.func_74775_l(NBT_TAG_ARMOR_ITEM)).func_82582_d()) {
            ItemStack armorItemStack = ItemStack.func_77949_a((NBTTagCompound)armorTags);
            this.equipArmor(armorItemStack);
        }
    }

    public void func_76316_a(@Nonnull InventoryBasic inventory) {
        ItemStack armor = inventory.func_70301_a(0);
        this.setArmorItemStack(armor);
    }

    public int func_70658_aO() {
        ItemStack armorItemStack;
        int totalArmor = super.func_70658_aO();
        if (this.getHasArmor() && (armorItemStack = this.getArmorItemStack()) != null && EntityWolfArmored.getIsValidWolfArmorItem(armorItemStack.func_77973_b())) {
            totalArmor += ((ItemWolfArmor)armorItemStack.func_77973_b()).getDamageReductionAmount();
        }
        return totalArmor;
    }

    public void func_82160_b(boolean killedByPlayer, int lootingModifier) {
        ItemStack armorItem;
        if (this.getHasArmor() && (armorItem = this.getArmorItemStack()) != null) {
            this.func_70099_a(armorItem, 0.0f);
            this.inventory.func_70299_a(0, null);
        }
        if (this.getHasChest()) {
            this.func_70099_a(new ItemStack((Block)Blocks.field_150486_ae, 1), 0.0f);
            for (int slotIndex = 1; slotIndex < this.getMaxSizeInventory(); ++slotIndex) {
                ItemStack stack = this.inventory.func_70301_a(slotIndex);
                if (stack == null) continue;
                this.func_70099_a(stack, 0.0f);
                this.inventory.func_70299_a(slotIndex, null);
            }
        }
    }

    @Nullable
    public ItemStack func_184586_b(@Nonnull EnumHand hand) {
        switch (hand) {
            case MAIN_HAND: {
                return this.getArmorItemStack();
            }
        }
        return null;
    }

    public boolean func_184645_a(@Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nullable ItemStack stack) {
        if (stack != null && stack.func_77973_b() == Items.field_151063_bx) {
            if (!this.field_70170_p.field_72995_K) {
                return this.spawnEggInteract(player, stack) || super.func_184645_a(player, hand, stack);
            }
            return super.func_184645_a(player, hand, stack);
        }
        if (this.func_70909_n() && this.func_152114_e((EntityLivingBase)player) && !this.func_70631_g_()) {
            if (player.func_70093_af()) {
                this.openWolfGui(player);
                return true;
            }
            if (stack != null) {
                if (WolfArmorMod.getConfiguration().getIsWolfChestEnabled() && Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150486_ae && !this.getHasChest()) {
                    this.setHasChest(true);
                    this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.func_70681_au().nextFloat() - this.func_70681_au().nextFloat()) * 0.2f + 1.0f);
                    this.inventoryInit();
                    if (!player.field_71075_bZ.field_75098_d) {
                        --stack.field_77994_a;
                    }
                    return true;
                }
                if (EntityWolfArmored.getIsValidWolfArmorItem(stack)) {
                    this.openWolfGui(player);
                    return true;
                }
            }
        }
        return super.func_184645_a(player, hand, stack);
    }

    public void func_184606_a_(@Nullable ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemWolfArmor) {
            ItemWolfArmor armorItem = (ItemWolfArmor)stack.func_77973_b();
            SoundEvent sound = armorItem.getMaterial().getEquipSound();
            this.func_184185_a(sound, 1.0f, 1.0f);
        }
        super.func_184606_a_(stack);
    }

    @Nonnull
    public ItemStack getPickedResult(@Nonnull RayTraceResult rayTraceResult) {
        String name = EntityList.func_188430_a(EntityWolf.class);
        if (EntityList.field_75627_a.containsKey(name)) {
            ItemStack stack = new ItemStack(Items.field_151063_bx);
            ItemMonsterPlacer.func_185078_a((ItemStack)stack, (String)name);
            return stack;
        }
        return super.getPickedResult(rayTraceResult);
    }

    protected void func_70675_k(float damage) {
        ItemStack armorStack;
        if (this.getHasArmor() && (armorStack = this.inventory.func_70301_a(0)) != null && EntityWolfArmored.getIsValidWolfArmorItem(armorStack)) {
            armorStack.func_77972_a((int)Math.ceil(damage), (EntityLivingBase)this);
            if (armorStack.field_77994_a == 0) {
                this.equipArmor(null);
            }
        }
    }

    public boolean equipArmor(@Nullable ItemStack armorItemStack) {
        if (!EntityWolfArmored.getIsValidWolfArmorItem(armorItemStack) || this.getHasArmor() && armorItemStack != null) {
            return false;
        }
        this.inventory.func_70299_a(0, armorItemStack);
        return true;
    }

    public static boolean getIsValidWolfArmorItem(@Nullable Item item) {
        return item == null || item instanceof ItemWolfArmor;
    }

    public static boolean getIsValidWolfArmorItem(@Nullable ItemStack item) {
        return item == null || EntityWolfArmored.getIsValidWolfArmorItem(item.func_77973_b());
    }

    private void openWolfGui(@Nonnull EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70911_d.func_75270_a(true);
            player.openGui((Object)WolfArmorMod.instance, this.func_145782_y(), this.field_70170_p, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
        }
    }

    private boolean spawnEggInteract(@Nonnull EntityPlayer player, @Nonnull ItemStack stack) {
        Class clazz = (Class)EntityList.field_75625_b.get(ItemMonsterPlacer.func_185080_h((ItemStack)stack));
        if (clazz != null && (clazz == EntityWolf.class || clazz == EntityWolfArmored.class)) {
            EntityWolf child = this.func_90011_a((EntityAgeable)this);
            child.func_70873_a(-24000);
            child.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
            this.field_70170_p.func_72838_d((Entity)child);
            if (stack.func_82837_s()) {
                child.func_96094_a(stack.func_82833_r());
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    public boolean getHasChest() {
        return WolfArmorMod.getConfiguration().getIsWolfChestEnabled() && ((Byte)this.field_70180_af.func_187225_a(HAS_CHEST) & 2) != 0;
    }

    public void setHasChest(boolean value) {
        byte hasChest = (Byte)this.field_70180_af.func_187225_a(HAS_CHEST);
        if (value) {
            this.field_70180_af.func_187227_b(HAS_CHEST, (Object)((byte)(hasChest | 2)));
        } else {
            this.field_70180_af.func_187227_b(HAS_CHEST, (Object)((byte)(hasChest & 0xFFFFFFFD)));
        }
    }

    public boolean getHasArmor() {
        return this.getArmorItemStack() != null;
    }

    @Nonnull
    public IInventory getInventory() {
        return this.inventory;
    }

    @Nullable
    public ItemStack getArmorItemStack() {
        Optional itemStackOptional = (Optional)this.field_70180_af.func_187225_a(ARMOR_ITEM);
        if (itemStackOptional.isPresent()) {
            ItemStack armorItemStack = (ItemStack)itemStackOptional.get();
            if (!EntityWolfArmored.getIsValidWolfArmorItem(armorItemStack.func_77973_b()) || armorItemStack.field_77994_a == 0) {
                this.field_70180_af.func_187227_b(ARMOR_ITEM, (Object)Optional.absent());
                return null;
            }
            return armorItemStack;
        }
        return null;
    }

    public void setArmorItemStack(@Nullable ItemStack armorItemStack) {
        ItemStack previousItemStack = this.getArmorItemStack();
        if (armorItemStack != null && (previousItemStack == null || previousItemStack.func_77973_b() != armorItemStack.func_77973_b())) {
            this.func_184606_a_(armorItemStack);
        }
        Optional itemStackOptional = Optional.fromNullable((Object)armorItemStack);
        if (EntityWolfArmored.getIsValidWolfArmorItem(armorItemStack)) {
            this.field_70180_af.func_187227_b(ARMOR_ITEM, (Object)itemStackOptional);
        }
    }

    @Nonnegative
    protected int getMaxSizeInventory() {
        return 7;
    }
}

