/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.capability;

import java.util.List;
import mcp.mobius.waila.addons.HUDHandlerBase;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class HUDHandlerTank
extends HUDHandlerBase {
    static final IWailaDataProvider INSTANCE = new HUDHandlerTank();

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("capability.tankinfo")) {
            return currenttip;
        }
        TileEntity tile = accessor.getTileEntity();
        if (tile == null || !tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            return currenttip;
        }
        NBTTagList tanks = accessor.getNBTData().func_150295_c("tankInfo", 10);
        int fluidCount = 0;
        for (int i = 0; i < tanks.func_74745_c(); ++i) {
            NBTTagCompound tankInfo = tanks.func_150305_b(i);
            FluidStack contents = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tankInfo.func_74775_l("fluid"));
            int capacity = tankInfo.func_74762_e("capacity");
            if (fluidCount <= 5) {
                ((ITaggedList)currenttip).add(String.format("%s: %d / %d mB", contents.getLocalizedName(), contents.amount, capacity), "IFluidHandler");
                ++fluidCount;
                continue;
            }
            ((ITaggedList)currenttip).add(I18n.func_74838_a((String)"hud.msg.toomuch"), "IFluidHandler");
        }
        return currenttip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
            NBTTagList tanks = new NBTTagList();
            IFluidHandler fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
            for (IFluidTankProperties property : fluidHandler.getTankProperties()) {
                if (property.getContents() == null) continue;
                NBTTagCompound tankInfo = new NBTTagCompound();
                tankInfo.func_74782_a("fluid", (NBTBase)property.getContents().writeToNBT(new NBTTagCompound()));
                tankInfo.func_74768_a("capacity", property.getCapacity());
                tanks.func_74742_a((NBTBase)tankInfo);
            }
            tag.func_74782_a("tankInfo", (NBTBase)tanks);
        }
        return tag;
    }
}

