/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.addons.capability;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import mcp.mobius.waila.addons.HUDHandlerBase;
import mcp.mobius.waila.api.ITaggedList;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.SpecialChars;
import mcp.mobius.waila.utils.InventoryUtils;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class HUDHandlerInventory
extends HUDHandlerBase {
    private static final Set<String> INVENTORY_IGNORE = Sets.newHashSet((Object[])new String[]{"refinedstorage:disk_drive"});
    static final IWailaDataProvider INSTANCE = new HUDHandlerInventory();

    @Override
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        if (!config.getConfig("capability.inventoryinfo") || accessor.getTileEntity() == null || accessor.getTileEntity().getClass() == TileEntityFurnace.class) {
            return currenttip;
        }
        if (accessor.getNBTData().func_74764_b("handler")) {
            int handlerSize = accessor.getNBTData().func_74762_e("handlerSize");
            ItemStackHandler itemHandler = new ItemStackHandler();
            itemHandler.setSize(handlerSize);
            InventoryUtils.populateInv((IItemHandlerModifiable)itemHandler, accessor.getNBTData().func_150295_c("handler", 10));
            String renderString = "";
            int drawnCount = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack == null) continue;
                String name = stack.func_77973_b().getRegistryName().toString();
                if (drawnCount >= 5) {
                    currenttip.add(renderString);
                    renderString = "";
                    drawnCount = 0;
                }
                String nbt = "";
                if (stack.func_77942_o()) {
                    nbt = stack.func_77978_p().toString();
                }
                renderString = renderString + SpecialChars.getRenderString("waila.stack", "1", name, String.valueOf(stack.field_77994_a), String.valueOf(stack.func_77952_i()), nbt);
                ++drawnCount;
            }
            if (!Strings.isNullOrEmpty((String)renderString)) {
                ((ITaggedList)currenttip).add(renderString, "IItemHandler");
            }
        }
        return currenttip;
    }

    @Override
    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, BlockPos pos) {
        if (te != null && !INVENTORY_IGNORE.contains(tag.func_74779_i("id"))) {
            tag.func_82580_o("Items");
            if (te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler itemHandler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                tag.func_74782_a("handler", (NBTBase)InventoryUtils.invToNBT(itemHandler, player.func_70093_af() ? itemHandler.getSlots() : 5));
                tag.func_74768_a("handlerSize", player.func_70093_af() ? itemHandler.getSlots() : 5);
            } else if (te instanceof IInventory) {
                InvWrapper itemHandler = new InvWrapper((IInventory)te);
                tag.func_74782_a("handler", (NBTBase)InventoryUtils.invToNBT((IItemHandler)itemHandler, player.func_70093_af() ? itemHandler.getSlots() : 5));
                tag.func_74768_a("handlerSize", player.func_70093_af() ? itemHandler.getSlots() : 5);
            } else if (te instanceof TileEntityEnderChest) {
                InvWrapper itemHandler = new InvWrapper((IInventory)player.func_71005_bN());
                tag.func_74782_a("handler", (NBTBase)InventoryUtils.invToNBT((IItemHandler)itemHandler, player.func_70093_af() ? itemHandler.getSlots() : 5));
                tag.func_74768_a("handlerSize", player.func_70093_af() ? itemHandler.getSlots() : 5);
            }
        }
        return tag;
    }
}

