/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.tileentity;

import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import toughasnails.api.TANCapabilities;
import toughasnails.api.season.IDecayableCrop;
import toughasnails.api.stat.capability.ITemperature;
import toughasnails.api.temperature.ITemperatureRegulator;
import toughasnails.api.temperature.Temperature;

public class TileEntityTemperatureSpread
extends TileEntity
implements ITickable,
ITemperatureRegulator {
    public static final int MAX_SPREAD_DISTANCE = 50;
    public static final int RATE_MODIFIER = -500;
    public static final boolean ENABLE_DEBUG = false;
    private Set<Entity> spawnedEntities;
    private Set<BlockPos>[] filledPositions = new Set[51];
    private Set<BlockPos> obstructedPositions;
    private int updateTicks;
    private int temperatureModifier;
    private AxisAlignedBB maxSpreadBox;

    public TileEntityTemperatureSpread() {
        for (int i = 0; i < 51; ++i) {
            this.filledPositions[i] = Sets.newConcurrentHashSet();
        }
        this.obstructedPositions = Sets.newConcurrentHashSet();
    }

    public TileEntityTemperatureSpread(int temperatureModifier) {
        this();
        this.temperatureModifier = temperatureModifier;
    }

    public void func_73660_a() {
        World world = this.func_145831_w();
        if (++this.updateTicks % 20 == 0) {
            if (!this.verify()) {
                this.fill();
            }
            if (this.maxSpreadBox == null) {
                this.maxSpreadBox = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 50), (double)(this.field_174879_c.func_177956_o() - 50), (double)(this.field_174879_c.func_177952_p() - 50), (double)(this.field_174879_c.func_177958_n() + 50), (double)(this.field_174879_c.func_177956_o() + 50), (double)(this.field_174879_c.func_177952_p() + 50));
            }
            for (EntityPlayer player : world.func_72872_a(EntityPlayer.class, this.maxSpreadBox)) {
                BlockPos delta = player.func_180425_c().func_177973_b((Vec3i)this.func_174877_v());
                int distance = Math.abs(delta.func_177958_n()) + Math.abs(delta.func_177956_o()) + Math.abs(delta.func_177952_p());
                boolean collided = false;
                block1: for (int i = 50 - distance; i >= 0; --i) {
                    for (BlockPos pos : this.filledPositions[i]) {
                        if (!player.func_174813_aQ().func_186668_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 1.0)) continue;
                        collided = true;
                        break block1;
                    }
                }
                if (!collided) continue;
                ITemperature temperature = (ITemperature)player.getCapability(TANCapabilities.TEMPERATURE, null);
                temperature.applyModifier("Climatisation", this.temperatureModifier, -500, 100);
            }
        }
    }

    public void reset() {
        for (Set<BlockPos> set : this.filledPositions) {
            set.clear();
        }
        this.obstructedPositions.clear();
    }

    public void fill() {
        this.reset();
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos offsetPos = this.field_174879_c.func_177972_a(facing);
            if (!this.canFill(offsetPos)) continue;
            this.filledPositions[50].add(offsetPos);
        }
        this.runStage(49);
    }

    private void runStage(int strength) {
        if (strength > 0) {
            Iterator<BlockPos> iterator = this.filledPositions[strength + 1].iterator();
            while (iterator.hasNext()) {
                BlockPos trackedPosition;
                BlockPos pos = trackedPosition = iterator.next();
                this.spreadAroundPos(pos, strength);
            }
            this.runStage(strength - 1);
        }
    }

    private void setTrackedStrength(BlockPos pos, int strength) {
        if (this.canFill(pos)) {
            this.filledPositions[strength].add(pos);
        } else {
            this.obstructedPositions.add(pos);
        }
    }

    private void spreadAroundPos(BlockPos pos, int strength) {
        for (EnumFacing facing : EnumFacing.values()) {
            BlockPos offsetPos = pos.func_177972_a(facing);
            if (this.filledPositions[strength + 1].contains(offsetPos)) continue;
            this.setTrackedStrength(offsetPos, strength);
        }
    }

    public boolean verify() {
        for (Set<BlockPos> trackedPositions : this.filledPositions) {
            for (BlockPos pos : trackedPositions) {
                if (this.canFill(pos)) continue;
                return false;
            }
        }
        for (BlockPos pos : this.obstructedPositions) {
            if (!this.canFill(pos)) continue;
            return false;
        }
        return true;
    }

    private boolean canFill(BlockPos pos) {
        return !this.func_145831_w().func_175665_u(pos) && (!this.func_145831_w().func_175678_i(pos) || this.func_145831_w().func_180495_p(pos).func_177230_c() instanceof IDecayableCrop);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.maxSpreadBox = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 50), (double)(this.field_174879_c.func_177956_o() - 50), (double)(this.field_174879_c.func_177952_p() - 50), (double)(this.field_174879_c.func_177958_n() + 50), (double)(this.field_174879_c.func_177956_o() + 50), (double)(this.field_174879_c.func_177952_p() + 50));
        if (compound.func_74764_b("FilledPositions")) {
            this.temperatureModifier = compound.func_74762_e("TemperatureModifier");
            NBTTagCompound filledCompound = compound.func_74775_l("FilledPositions");
            for (int strength = 0; strength <= 50; ++strength) {
                if (!filledCompound.func_74764_b("Strength" + strength)) {
                    throw new IllegalArgumentException("Compound missing strength sub-compound Strength" + strength + "!");
                }
                NBTTagCompound strengthCompound = filledCompound.func_74775_l("Strength" + strength);
                this.filledPositions[strength] = this.readPosSet(strengthCompound);
            }
            this.spawnedEntities = Sets.newConcurrentHashSet();
            NBTTagCompound obstructedCompound = compound.func_74775_l("ObstructedPositions");
            this.obstructedPositions = this.readPosSet(obstructedCompound);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagCompound filledCompound = new NBTTagCompound();
        compound.func_74768_a("TemperatureModifier", this.temperatureModifier);
        for (int i = 0; i <= 50; ++i) {
            NBTTagCompound strengthCompound = new NBTTagCompound();
            this.writePosSet(strengthCompound, this.filledPositions[i]);
            filledCompound.func_74782_a("Strength" + i, (NBTBase)strengthCompound);
        }
        compound.func_74782_a("FilledPositions", (NBTBase)filledCompound);
        NBTTagCompound obstructedCompound = new NBTTagCompound();
        this.writePosSet(obstructedCompound, this.obstructedPositions);
        compound.func_74782_a("ObstructedPositions", (NBTBase)obstructedCompound);
        return compound;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private void writePosSet(NBTTagCompound compound, Set<BlockPos> posSet) {
        compound.func_74768_a("Count", posSet.size());
        int index = 0;
        for (BlockPos pos : posSet) {
            compound.func_74782_a("Pos" + index, (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
            ++index;
        }
    }

    private Set<BlockPos> readPosSet(NBTTagCompound compound) {
        if (!compound.func_74764_b("Count")) {
            throw new IllegalArgumentException("Compound is not a valid pos set");
        }
        int count = compound.func_74762_e("Count");
        Set posSet = Sets.newConcurrentHashSet();
        for (int i = 0; i < count; ++i) {
            BlockPos pos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("Pos" + i));
            if (pos == null) continue;
            posSet.add(pos);
        }
        return posSet;
    }

    @Override
    public Temperature getRegulatedTemperature() {
        return new Temperature(this.temperatureModifier);
    }

    @Override
    public boolean isPosRegulated(BlockPos pos) {
        for (int i = 0; i < 50; ++i) {
            Set<BlockPos> regulatedPositions = this.filledPositions[i];
            if (!regulatedPositions.contains(pos)) continue;
            return true;
        }
        return false;
    }
}

