/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature.modifier;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import toughasnails.api.temperature.Temperature;
import toughasnails.temperature.TemperatureDebugger;
import toughasnails.temperature.TemperatureTrend;
import toughasnails.temperature.modifier.TemperatureModifier;
import toughasnails.util.BiomeUtils;

public class TimeModifier
extends TemperatureModifier {
    public static final int TIME_TARGET_MODIFIER = 7;
    public static final float EXTREMITY_MULTIPLIER = 1.25f;

    public TimeModifier(TemperatureDebugger debugger) {
        super(debugger);
    }

    @Override
    public int modifyChangeRate(World world, EntityPlayer player, int changeRate, TemperatureTrend trend) {
        return changeRate;
    }

    @Override
    public Temperature modifyTarget(World world, EntityPlayer player, Temperature temperature) {
        int temperatureLevel;
        Biome biome = world.func_180494_b(player.func_180425_c());
        long worldTime = world.func_72820_D();
        float extremityModifier = BiomeUtils.getBiomeTempExtremity(biome);
        float timeNorm = (-Math.abs((float)(worldTime + 6000L) % 24000.0f - 12000.0f) + 6000.0f) / 6000.0f;
        int newTemperatureLevel = temperatureLevel = temperature.getRawValue();
        this.debugger.start(TemperatureDebugger.Modifier.TIME_TARGET, newTemperatureLevel);
        if (world.field_73011_w.func_76569_d()) {
            newTemperatureLevel = (int)((float)newTemperatureLevel + 7.0f * timeNorm * Math.max(1.0f, extremityModifier * 1.25f));
        }
        this.debugger.end(newTemperatureLevel);
        return new Temperature(newTemperatureLevel);
    }
}

