/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.init;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import toughasnails.core.ToughAsNails;
import toughasnails.entities.EntityFreeze;
import toughasnails.entities.projectile.EntityIceball;

public class ModEntities {
    public static final Map<Integer, EntityList.EntityEggInfo> entityEggs = Maps.newLinkedHashMap();
    public static final Map<Integer, String> idToTANEntityName = Maps.newLinkedHashMap();
    private static int nextTANEntityId = 1;

    public static void init() {
        ModEntities.registerTANEntity(EntityIceball.class, "iceball", 80, 3, true);
        ModEntities.registerTANEntityWithSpawnEgg(EntityFreeze.class, "freeze", 80, 3, true, 15530740, 4431811, Biomes.field_76774_n, Biomes.field_76775_o);
    }

    public static int registerTANEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        int tanEntityId = nextTANEntityId++;
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)tanEntityId, (Object)ToughAsNails.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        idToTANEntityName.put(tanEntityId, entityName);
        return tanEntityId;
    }

    public static int registerTANEntityWithSpawnEgg(Class<? extends EntityLiving> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggBackgroundColor, int eggForegroundColor, Biome ... entityBiomes) {
        int tanEntityId = ModEntities.registerTANEntity(entityClass, entityName, trackingRange, updateFrequency, sendsVelocityUpdates);
        entityEggs.put(tanEntityId, new EntityList.EntityEggInfo(entityName, eggBackgroundColor, eggForegroundColor));
        EntityRegistry.addSpawn(entityClass, (int)3, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])entityBiomes);
        return tanEntityId;
    }

    public static Entity createEntityByID(int tanEntityId, World worldIn) {
        Entity entity = null;
        ModContainer mc = FMLCommonHandler.instance().findContainerFor((Object)ToughAsNails.instance);
        EntityRegistry.EntityRegistration er = EntityRegistry.instance().lookupModSpawn(mc, tanEntityId);
        if (er != null) {
            Class clazz = er.getEntityClass();
            try {
                if (clazz != null) {
                    entity = (Entity)clazz.getConstructor(World.class).newInstance(worldIn);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (entity == null) {
            ToughAsNails.logger.warn("Skipping TAN Entity with id " + tanEntityId);
        }
        return entity;
    }
}

