/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.handler.thirst;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import toughasnails.api.TANCapabilities;
import toughasnails.api.TANPotions;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.thirst.ThirstHandler;
import toughasnails.util.RenderUtils;

public class ThirstOverlayHandler {
    public static final ResourceLocation OVERLAY = new ResourceLocation("toughasnails:textures/gui/overlay.png");
    private final Random random = new Random();
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private int updateCounter;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !this.minecraft.func_147113_T()) {
            ++this.updateCounter;
        }
    }

    @SubscribeEvent
    public void onPreRenderOverlay(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR && SyncedConfig.getBooleanValue(GameplayOption.ENABLE_THIRST)) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)-10.0f, (float)0.0f);
        }
    }

    @SubscribeEvent
    public void onPostRenderOverlay(RenderGameOverlayEvent.Post event) {
        ScaledResolution resolution = event.getResolution();
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        ThirstHandler thirstStats = (ThirstHandler)player.getCapability(TANCapabilities.THIRST, null);
        int thirstLevel = thirstStats.getThirst();
        float thirstHydrationLevel = thirstStats.getHydration();
        this.random.setSeed(this.updateCounter * 312871);
        if (event.getType() == RenderGameOverlayEvent.ElementType.AIR && SyncedConfig.getBooleanValue(GameplayOption.ENABLE_THIRST)) {
            GlStateManager.func_179121_F();
        } else if (event.getType() == RenderGameOverlayEvent.ElementType.EXPERIENCE && SyncedConfig.getBooleanValue(GameplayOption.ENABLE_THIRST)) {
            this.minecraft.func_110434_K().func_110577_a(OVERLAY);
            if (this.minecraft.field_71442_b.func_78763_f()) {
                this.drawThirst(width, height, thirstLevel, thirstHydrationLevel);
            }
        }
    }

    private void drawThirst(int width, int height, int thirstLevel, float thirstHydrationLevel) {
        int left = width / 2 + 91;
        int top = height - 49;
        for (int i = 0; i < 10; ++i) {
            int dropletHalf = i * 2 + 1;
            int iconIndex = 0;
            int backgroundOffset = 0;
            int startX = left - i * 8 - 9;
            int startY = top;
            if (this.minecraft.field_71439_g.func_70644_a(TANPotions.thirst)) {
                iconIndex += 4;
                backgroundOffset += 117;
            }
            if (thirstHydrationLevel <= 0.0f && this.updateCounter % (thirstLevel * 3 + 1) == 0) {
                startY = top + (this.random.nextInt(3) - 1);
            }
            RenderUtils.drawTexturedModalRect(startX, startY, backgroundOffset, 16, 9, 9);
            if (thirstLevel > dropletHalf) {
                RenderUtils.drawTexturedModalRect(startX, startY, (iconIndex + 4) * 9, 16, 9, 9);
            }
            if (thirstLevel != dropletHalf) continue;
            RenderUtils.drawTexturedModalRect(startX, startY, (iconIndex + 5) * 9, 16, 9, 9);
        }
    }
}

