/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.handler.temperature;

import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toughasnails.api.TANCapabilities;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.temperature.TemperatureScale;
import toughasnails.temperature.TemperatureDebugger;
import toughasnails.temperature.TemperatureHandler;

public class TemperatureDebugOverlayHandler {
    @SubscribeEvent
    public void onPostRenderOverlay(RenderGameOverlayEvent.Post event) {
        ScaledResolution resolution = event.getResolution();
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        TemperatureHandler temperatureStats = (TemperatureHandler)player.getCapability(TANCapabilities.TEMPERATURE, null);
        TemperatureDebugger debugger = temperatureStats.debugger;
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL && debugger.isGuiVisible()) {
            this.drawModifierTable(width, height, temperatureStats.getTemperature(), debugger);
        }
    }

    private void drawModifierTable(int width, int height, Temperature temperature, TemperatureDebugger debugger) {
        Map<TemperatureDebugger.Modifier, Integer> rateModifiers = debugger.modifiers[0];
        Map<TemperatureDebugger.Modifier, Integer> targetModifiers = debugger.modifiers[1];
        if (targetModifiers != null && rateModifiers != null) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            int targetTableHeight = TemperatureDebugOverlayHandler.getTableHeight(targetModifiers);
            int totalTableHeight = targetTableHeight + TemperatureDebugOverlayHandler.getTableHeight(rateModifiers) + 2;
            int startY = height / 2 - totalTableHeight / 2;
            String targetProgress = "" + TextFormatting.RED + temperature.getRawValue() + "/" + debugger.targetTemperature + TemperatureDebugOverlayHandler.getCappedText(debugger.targetTemperature);
            String rateProgress = "" + TextFormatting.RED + debugger.temperatureTimer + "/" + debugger.changeTicks;
            TemperatureDebugOverlayHandler.drawTable("Target " + targetProgress, 1, startY, targetModifiers);
            TemperatureDebugOverlayHandler.drawTable("Rate " + rateProgress, 1, startY + targetTableHeight + 2, rateModifiers);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawTable(String title, int x, int y, Map<TemperatureDebugger.Modifier, Integer> contents) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int lineWidth = TemperatureDebugOverlayHandler.getLineWidth(title, contents);
        int textStart = x + 2;
        int textEnd = textStart + lineWidth;
        Iterator<Map.Entry<TemperatureDebugger.Modifier, Integer>> contentsIterator = contents.entrySet().iterator();
        for (int i = 0; i < contents.size() + 1; ++i) {
            int rowTopY = y + i * fontRenderer.field_78288_b + 1;
            int rowBottomY = rowTopY + fontRenderer.field_78288_b;
            if (i == 0) {
                Gui.func_73734_a((int)x, (int)(rowBottomY - 1), (int)textEnd, (int)y, (int)0x60000000);
                Gui.func_73734_a((int)x, (int)rowBottomY, (int)textEnd, (int)(rowBottomY - 1), (int)0x50000000);
                fontRenderer.func_78276_b(title, textStart + lineWidth / 2 - fontRenderer.func_78256_a(title) / 2, y + 1, 0x20FFFFFF);
                continue;
            }
            Map.Entry<TemperatureDebugger.Modifier, Integer> entry = contentsIterator.next();
            String string = entry.getKey().name;
            int value = entry.getValue();
            String formattedValue = TemperatureDebugOverlayHandler.getFormattedInt(value);
            Gui.func_73734_a((int)x, (int)rowBottomY, (int)textEnd, (int)rowTopY, (int)0x50000000);
            fontRenderer.func_78276_b(string, textStart, rowTopY, 0x20FFFFFF);
            fontRenderer.func_78276_b(formattedValue, textEnd - fontRenderer.func_78256_a(formattedValue), rowTopY, 0x20FFFFFF);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static int getTableHeight(Map contents) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        return (contents.size() + 1) * fontRenderer.field_78288_b + 1;
    }

    @SideOnly(value=Side.CLIENT)
    private static int getLineWidth(String title, Map<TemperatureDebugger.Modifier, Integer> elements) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int lineWidth = 0;
        for (Map.Entry<TemperatureDebugger.Modifier, Integer> entry : elements.entrySet()) {
            int i = entry.getValue();
            String string = entry.getKey().name + ": " + TemperatureDebugOverlayHandler.getFormattedInt(i);
            lineWidth = Math.max(fontRenderer.func_78256_a(string), lineWidth);
        }
        lineWidth = Math.max(fontRenderer.func_78256_a(title), lineWidth);
        return lineWidth;
    }

    private static String getCappedText(int targetTemperature) {
        return TextFormatting.BLUE + " " + (targetTemperature < 0 ? "(0)" : (targetTemperature > TemperatureScale.getScaleTotal() ? "(" + TemperatureScale.getScaleTotal() + ")" : ""));
    }

    private static String getFormattedInt(int i) {
        TextFormatting format = i > 0 ? TextFormatting.RED : (i < 0 ? TextFormatting.BLUE : TextFormatting.RESET);
        return "" + format + TemperatureDebugOverlayHandler.getNumberSign(i) + i;
    }

    private static char getNumberSign(int i) {
        return i > 0 ? (char)'+' : ' ';
    }
}

