/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import toughasnails.api.config.GameplayOption;
import toughasnails.api.config.SyncedConfig;
import toughasnails.core.ToughAsNails;

public class GameplayConfigurationHandler {
    public static final String SURVIVAL_SETTINGS = "Survival Settings";
    public static Configuration config;

    public static void init(File configFile) {
        if (config == null) {
            config = new Configuration(configFile);
            GameplayConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        try {
            GameplayConfigurationHandler.addSyncedBool(GameplayOption.ENABLE_LOWERED_STARTING_HEALTH, true, SURVIVAL_SETTINGS, "Players begin with a lowered maximum health.");
            GameplayConfigurationHandler.addSyncedBool(GameplayOption.ENABLE_SEASONS, true, SURVIVAL_SETTINGS, "Seasons progress as days increase");
            GameplayConfigurationHandler.addSyncedBool(GameplayOption.ENABLE_TEMPERATURE, true, SURVIVAL_SETTINGS, "Players are affected by temperature");
            GameplayConfigurationHandler.addSyncedBool(GameplayOption.ENABLE_THIRST, true, SURVIVAL_SETTINGS, "Players are affected by thirst");
        }
        catch (Exception e) {
            ToughAsNails.logger.error("Tough As Nails has encountered a problem loading gameplay.cfg", (Throwable)e);
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    private static void addSyncedBool(GameplayOption option, boolean defaultValue, String category, String comment) {
        boolean value = config.getBoolean(option.getOptionName(), category, defaultValue, comment);
        SyncedConfig.addOption(option, "" + value);
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("ToughAsNails")) {
            GameplayConfigurationHandler.loadConfiguration();
        }
    }
}

