/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toughasnails.api.ITANBlock;
import toughasnails.api.TANBlocks;
import toughasnails.api.achievement.TANAchievements;
import toughasnails.item.ItemTANBlock;

public class BlockTANCampfire
extends Block
implements ITANBlock {
    protected static final AxisAlignedBB SELECTION_BOX = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.6, 0.9);
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)7);
    public static final PropertyBool BURNING = PropertyBool.func_177716_a((String)"burning");

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemTANBlock.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[0];
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return "";
    }

    public BlockTANCampfire() {
        this(Material.field_151576_e);
    }

    public BlockTANCampfire(Material material) {
        super(material);
        this.func_149675_a(true);
        this.func_149711_c(0.7f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185851_d);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(worldIn, pos, state, rand);
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            if (worldIn.func_175727_C(pos)) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(15)), 2);
                worldIn.func_184133_a((EntityPlayer)null, pos, SoundEvents.field_187659_cY, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                for (int i = 0; i < 8; ++i) {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)((float)pos.func_177958_n() + 0.75f - rand.nextFloat() / 2.0f), (double)((float)pos.func_177956_o() + 0.9f), (double)((float)pos.func_177952_p() + 0.75f - rand.nextFloat() / 2.0f), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
                }
            }
            if (age < 7 && rand.nextInt(8) == 0) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)), 2);
            }
            if (age == 7 && rand.nextInt(8) == 0) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(false)), 2);
            }
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            return 15;
        }
        return 0;
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return SELECTION_BOX;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue() && entity instanceof EntityLivingBase) {
            entity.func_70015_d(1);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (playerIn.func_184586_b(hand) != null) {
            Item item = playerIn.func_184586_b(hand).func_77973_b();
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            if (age == 0 && !((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue() && !worldIn.func_175727_C(pos)) {
                if (item == Items.field_151055_y) {
                    if (worldIn.field_73012_v.nextInt(12) == 0) {
                        worldIn.func_175656_a(pos, TANBlocks.campfire.func_176223_P().func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(true)));
                        playerIn.func_71029_a((StatBase)TANAchievements.campfire_song);
                    }
                    if (item == Items.field_151055_y) {
                        --playerIn.func_184586_b((EnumHand)hand).field_77994_a;
                    }
                    return true;
                }
                if (item == Items.field_151033_d) {
                    worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.4f + 0.8f);
                    worldIn.func_175656_a(pos, TANBlocks.campfire.func_176223_P().func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf(true)));
                    playerIn.func_71029_a((StatBase)TANAchievements.campfire_song);
                    if (item == Items.field_151033_d) {
                        playerIn.func_184586_b(hand).func_77972_a(1, (EntityLivingBase)playerIn);
                    }
                    return true;
                }
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(state, worldIn, pos, rand);
        if (((Boolean)state.func_177229_b((IProperty)BURNING)).booleanValue()) {
            if (rand.nextInt(24) == 0) {
                worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
            }
            worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + 0.75f - rand.nextFloat() / 2.0f), (double)((float)pos.func_177956_o() + 0.25f + rand.nextFloat() / 2.0f), (double)((float)pos.func_177952_p() + 0.75f - rand.nextFloat() / 2.0f), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
            worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + 0.75f - rand.nextFloat() / 2.0f), (double)((float)pos.func_177956_o() + 0.25f + rand.nextFloat() / 2.0f), (double)((float)pos.func_177952_p() + 0.75f - rand.nextFloat() / 2.0f), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
            worldIn.func_175688_a(EnumParticleTypes.FLAME, (double)((float)pos.func_177958_n() + 0.75f - rand.nextFloat() / 2.0f), (double)((float)pos.func_177956_o() + 0.25f + rand.nextFloat() / 2.0f), (double)((float)pos.func_177952_p() + 0.75f - rand.nextFloat() / 2.0f), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + 0.75f - rand.nextFloat() / 2.0f), (double)((float)pos.func_177956_o() + 0.9f), (double)((float)pos.func_177952_p() + 0.75f - rand.nextFloat() / 2.0f), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
            if (rand.nextInt(2) == 0) {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)((float)pos.func_177958_n() + 0.75f - rand.nextFloat() / 2.0f), (double)((float)pos.func_177956_o() + 0.9f), (double)((float)pos.func_177952_p() + 0.75f - rand.nextFloat() / 2.0f), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
            }
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)worldIn, pos) && worldIn.func_180495_p(pos.func_177977_b()).isSideSolid((IBlockAccess)worldIn, pos, EnumFacing.UP);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta >> 1)).func_177226_a((IProperty)BURNING, (Comparable)Boolean.valueOf((meta & 1) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)AGE) << 1;
        return (Boolean)state.func_177229_b((IProperty)BURNING) != false ? meta | 1 : meta;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, BURNING});
    }
}

