/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.api.temperature;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import toughasnails.api.TANCapabilities;
import toughasnails.api.stat.capability.ITemperature;
import toughasnails.api.temperature.ITemperatureRegulator;
import toughasnails.api.temperature.Temperature;

public class TemperatureHelper {
    public static ITemperature getTemperatureData(EntityPlayer player) {
        return (ITemperature)player.getCapability(TANCapabilities.TEMPERATURE, null);
    }

    public static List<ITemperatureRegulator> getTemperatureRegulators(World world) {
        ArrayList list = Lists.newArrayList();
        for (TileEntity tileEntity : world.field_175730_i) {
            if (!(tileEntity instanceof ITemperatureRegulator)) continue;
            list.add((ITemperatureRegulator)tileEntity);
        }
        return list;
    }

    public static boolean isPosClimatisedForTemp(World world, BlockPos pos, Temperature temperature) {
        for (ITemperatureRegulator regulator : TemperatureHelper.getTemperatureRegulators(world)) {
            if (regulator.getRegulatedTemperature().getRawValue() < temperature.getRawValue() || !regulator.isPosRegulated(pos)) continue;
            return true;
        }
        return false;
    }
}

