/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.generator;

import biomesoplenty.api.block.BlockQueries;
import biomesoplenty.api.block.IBlockPosQuery;
import biomesoplenty.api.config.IConfigObj;
import biomesoplenty.api.generation.IGenerator;
import biomesoplenty.common.util.biome.GeneratorUtils;
import biomesoplenty.common.util.block.BlockQuery;
import biomesoplenty.common.world.generator.GeneratorReplacing;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class GeneratorWaterside
extends GeneratorReplacing {
    protected int maxRadius;

    public GeneratorWaterside(float amountPerChunk, IBlockPosQuery placeOn, IBlockPosQuery replace, IBlockState with, GeneratorUtils.ScatterYMethod scatterYMethod, int maxRadius) {
        super(amountPerChunk, placeOn, replace, with, scatterYMethod);
        this.maxRadius = maxRadius;
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a() != Material.field_151586_h) {
            return false;
        }
        int radius = random.nextInt(this.maxRadius - 2) + 2;
        int heightRadius = 2;
        for (int x = pos.func_177958_n() - radius; x <= pos.func_177958_n() + radius; ++x) {
            for (int z = pos.func_177952_p() - radius; z <= pos.func_177952_p() + radius; ++z) {
                int zDiff;
                int xDiff = x - pos.func_177958_n();
                if (xDiff * xDiff + (zDiff = z - pos.func_177952_p()) * zDiff > radius * radius) continue;
                for (int y = pos.func_177956_o() - heightRadius; y <= pos.func_177956_o() + heightRadius; ++y) {
                    BlockPos posToReplace = new BlockPos(x, y, z);
                    if (!this.replace.matches(world, posToReplace)) continue;
                    world.func_180501_a(posToReplace, this.with, 2);
                }
            }
        }
        return true;
    }

    @Override
    public void configure(IConfigObj conf) {
        this.amountPerChunk = conf.getFloat("amountPerChunk", Float.valueOf(this.amountPerChunk)).floatValue();
        this.replace = conf.getBlockPosQuery("replace", this.replace);
        this.with = conf.getBlockState("with", this.with);
        this.maxRadius = conf.getInt("maxRadius", this.maxRadius);
    }

    public static class Builder
    extends GeneratorReplacing.InnerBuilder<Builder, GeneratorWaterside>
    implements IGenerator.IGeneratorBuilder<GeneratorWaterside> {
        protected int maxRadius;

        public Builder maxRadius(int a) {
            this.maxRadius = a;
            return (Builder)this.self();
        }

        public Builder() {
            this.amountPerChunk = 1.0f;
            this.placeOn = BlockQueries.anything;
            this.replace = new BlockQuery.BlockQueryMaterial(Material.field_151577_b, Material.field_151578_c);
            this.with = Blocks.field_150351_n.func_176223_P();
            this.scatterYMethod = GeneratorUtils.ScatterYMethod.AT_GROUND;
            this.maxRadius = 7;
        }

        @Override
        public GeneratorWaterside create() {
            return new GeneratorWaterside(this.amountPerChunk, this.placeOn, this.replace, this.with, this.scatterYMethod, this.maxRadius);
        }
    }
}

