/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.handler;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.fluids.BloodFluid;
import biomesoplenty.common.fluids.HoneyFluid;
import biomesoplenty.common.fluids.PoisonFluid;
import biomesoplenty.common.fluids.QuicksandFluid;
import biomesoplenty.common.fluids.blocks.BlockBloodFluid;
import biomesoplenty.common.fluids.blocks.BlockHoneyFluid;
import biomesoplenty.common.fluids.blocks.BlockHotSpringWaterFluid;
import biomesoplenty.common.fluids.blocks.BlockPoisonFluid;
import biomesoplenty.common.fluids.blocks.BlockQuicksandFluid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BucketEventHandler {
    @SubscribeEvent
    public void onRightClickHoldingBucket(FillBucketEvent event) {
        if (event.getEmptyBucket().func_77973_b() != Items.field_151133_ar) {
            return;
        }
        if (event.getTarget() == null || event.getTarget().field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        BlockPos blockpos = event.getTarget().func_178782_a();
        if (!event.getWorld().func_175660_a(event.getEntityPlayer(), blockpos)) {
            return;
        }
        if (!event.getEntityPlayer().func_175151_a(blockpos.func_177972_a(event.getTarget().field_178784_b), event.getTarget().field_178784_b, event.getEmptyBucket())) {
            return;
        }
        IBlockState iblockstate = event.getWorld().func_180495_p(blockpos);
        Fluid filled_fluid = null;
        if (iblockstate.func_177230_c() == BOPBlocks.sand && (Integer)iblockstate.func_177229_b((IProperty)BlockQuicksandFluid.LEVEL) == 0) {
            filled_fluid = QuicksandFluid.instance;
        } else if (iblockstate.func_177230_c() == BOPBlocks.honey && (Integer)iblockstate.func_177229_b((IProperty)BlockHoneyFluid.LEVEL) == 0) {
            filled_fluid = HoneyFluid.instance;
        } else if (iblockstate.func_177230_c() == BOPBlocks.blood && (Integer)iblockstate.func_177229_b((IProperty)BlockBloodFluid.LEVEL) == 0) {
            filled_fluid = BloodFluid.instance;
        } else if (iblockstate.func_177230_c() == BOPBlocks.poison && (Integer)iblockstate.func_177229_b((IProperty)BlockPoisonFluid.LEVEL) == 0) {
            filled_fluid = PoisonFluid.instance;
        } else if (iblockstate.func_177230_c() == BOPBlocks.hot_spring_water && (Integer)iblockstate.func_177229_b((IProperty)BlockHotSpringWaterFluid.LEVEL) == 0) {
            filled_fluid = FluidRegistry.WATER;
        } else {
            return;
        }
        event.setResult(Event.Result.ALLOW);
        event.setFilledBucket(UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, (Fluid)filled_fluid));
        event.getWorld().func_175698_g(blockpos);
    }
}

