/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.biome.overworld;

import biomesoplenty.api.config.IBOPWorldSettings;
import biomesoplenty.api.enums.BOPClimates;
import biomesoplenty.api.enums.BOPFlowers;
import biomesoplenty.api.enums.BOPPlants;
import biomesoplenty.api.generation.GeneratorStage;
import biomesoplenty.common.biome.overworld.BOPBiome;
import biomesoplenty.common.world.generator.GeneratorFlora;
import biomesoplenty.common.world.generator.GeneratorGrass;
import biomesoplenty.common.world.generator.GeneratorOreSingle;
import biomesoplenty.common.world.generator.GeneratorWeighted;
import biomesoplenty.common.world.generator.tree.GeneratorBush;
import biomesoplenty.common.world.generator.tree.GeneratorMahoganyTree;
import biomesoplenty.common.world.generator.tree.GeneratorTwigletTree;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.init.Blocks;
import net.minecraft.world.biome.Biome;

public class BiomeGenOvergrownCliffs
extends BOPBiome {
    public BiomeGenOvergrownCliffs() {
        super("overgrown_cliffs", new BOPBiome.PropsBuilder("Overgrown Cliffs").withGuiColour(8373350).withTemperature(Float.valueOf(0.95f)).withRainfall(Float.valueOf(0.75f)));
        this.terrainSettings.avgHeight(70.0).heightVariation(5.0, 100.0).octaves(1.0, 1.0, 1.0, 1.0, 0.0, 0.0).sidewaysNoise(0.0);
        this.canGenerateRivers = false;
        this.canSpawnInBiome = false;
        this.canGenerateVillages = false;
        this.addWeight(BOPClimates.TROPICAL, 2);
        this.beachBiomeLocation = null;
        this.field_76762_K.clear();
        this.field_76761_J.add(new Biome.SpawnListEntry(EntityOcelot.class, 2, 1, 1));
        GeneratorWeighted treeGenerator = new GeneratorWeighted(40.0f);
        this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
        treeGenerator.add("mahogany", 1, ((GeneratorMahoganyTree.Builder)((GeneratorMahoganyTree.Builder)new GeneratorMahoganyTree.Builder().minHeight(5)).maxHeight(10)).create());
        treeGenerator.add("oak_bush", 8, ((GeneratorBush.Builder)new GeneratorBush.Builder().maxHeight(2)).create());
        treeGenerator.add("jungle_twiglet", 2, ((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)new GeneratorTwigletTree.Builder().minHeight(2)).maxHeight(2)).log(BlockPlanks.EnumType.JUNGLE)).leaves(BlockPlanks.EnumType.JUNGLE)).trunkFruit(Blocks.field_150375_by.func_176223_P())).create());
        this.addGenerator("shrubs", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.4f)).with(BOPPlants.SHRUB)).create());
        this.addGenerator("sprouts", GeneratorStage.FLOWERS, ((GeneratorFlora.Builder)((GeneratorFlora.Builder)new GeneratorFlora.Builder().amountPerChunk(0.5f)).with(BOPPlants.SPROUT)).create());
        GeneratorWeighted flowerGenerator = new GeneratorWeighted(1.5f);
        this.addGenerator("flowers", GeneratorStage.FLOWERS, flowerGenerator);
        flowerGenerator.add("orange_cosmos", 4, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BOPFlowers.ORANGE_COSMOS)).create());
        flowerGenerator.add("dandelion", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.DANDELION)).create());
        flowerGenerator.add("poppy", 1, ((GeneratorFlora.Builder)new GeneratorFlora.Builder().with(BlockFlower.EnumFlowerType.POPPY)).create());
        GeneratorWeighted grassGenerator = new GeneratorWeighted(2.0f);
        this.addGenerator("grass", GeneratorStage.GRASS, grassGenerator);
        grassGenerator.add("shortgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.SHORTGRASS)).create());
        grassGenerator.add("mediumgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.MEDIUMGRASS)).create());
        grassGenerator.add("dampgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BOPPlants.DAMPGRASS)).create());
        grassGenerator.add("tallgrass", 1, ((GeneratorGrass.Builder)new GeneratorGrass.Builder().with(BlockTallGrass.EnumType.GRASS)).create());
        this.addGenerator("emeralds", GeneratorStage.SAND, ((GeneratorOreSingle.Builder)((GeneratorOreSingle.Builder)new GeneratorOreSingle.Builder().amountPerChunk(12.0f)).with(Blocks.field_150412_bA.func_176223_P())).create());
    }

    @Override
    public void applySettings(IBOPWorldSettings settings) {
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.MUSHROOMS)) {
            this.removeGenerator("glowshrooms");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            this.removeGenerator("miners_delight");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.ROCK_FORMATIONS)) {
            this.removeGenerator("stone_formations");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.HOT_SPRINGS)) {
            this.removeGenerator("hot_springs");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FOLIAGE)) {
            this.removeGenerator("bushes");
            this.removeGenerator("koru");
            this.removeGenerator("shrubs");
            this.removeGenerator("leaf_piles");
            this.removeGenerator("dead_leaf_piles");
            this.removeGenerator("clover_patches");
            this.removeGenerator("sprouts");
        }
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.PLANTS)) {
            this.removeGenerator("cattail");
            this.removeGenerator("double_cattail");
            this.removeGenerator("river_cane");
            this.removeGenerator("tiny_cacti");
            this.removeGenerator("roots");
            this.removeGenerator("rafflesia");
            this.removeGenerator("desert_sprouts");
        }
        GeneratorWeighted treeGen = (GeneratorWeighted)this.getGenerator("trees");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.TREES)) {
            this.removeGenerator("trees");
            GeneratorWeighted treeGenerator = new GeneratorWeighted(40.0f);
            this.addGenerator("trees", GeneratorStage.TREE, treeGenerator);
            treeGenerator.add("mahogany", 1, ((GeneratorMahoganyTree.Builder)((GeneratorMahoganyTree.Builder)((GeneratorMahoganyTree.Builder)((GeneratorMahoganyTree.Builder)new GeneratorMahoganyTree.Builder().minHeight(5)).maxHeight(10)).log(BlockPlanks.EnumType.JUNGLE)).leaves(BlockPlanks.EnumType.JUNGLE)).create());
            treeGenerator.add("oak_bush", 8, ((GeneratorBush.Builder)new GeneratorBush.Builder().maxHeight(2)).create());
            treeGenerator.add("jungle_twiglet", 2, ((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)((GeneratorTwigletTree.Builder)new GeneratorTwigletTree.Builder().minHeight(2)).maxHeight(2)).log(BlockPlanks.EnumType.JUNGLE)).leaves(BlockPlanks.EnumType.JUNGLE)).trunkFruit(Blocks.field_150375_by.func_176223_P())).create());
        }
        GeneratorWeighted flowerGen = (GeneratorWeighted)this.getGenerator("flowers");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.FLOWERS)) {
            flowerGen.removeGenerator("bluebells");
            flowerGen.removeGenerator("clover");
            flowerGen.removeGenerator("swampflower");
            flowerGen.removeGenerator("deathbloom");
            flowerGen.removeGenerator("glowflower");
            flowerGen.removeGenerator("blue_hydrangeas");
            flowerGen.removeGenerator("pink_daffodil");
            flowerGen.removeGenerator("white_anemones");
            flowerGen.removeGenerator("orange_cosmos");
            flowerGen.removeGenerator("wildflowers");
            flowerGen.removeGenerator("violet");
            flowerGen.removeGenerator("hibiscus");
            flowerGen.removeGenerator("goldenrods");
            flowerGen.removeGenerator("icy_irises");
            flowerGen.removeGenerator("wilted_lily");
            flowerGen.removeGenerator("lily_of_the_valley");
            flowerGen.removeGenerator("bromeliad");
            this.removeGenerator("bromeliad");
        }
        GeneratorWeighted grassGen = (GeneratorWeighted)this.getGenerator("grass");
        if (!settings.isEnabled(IBOPWorldSettings.GeneratorType.GRASSES)) {
            grassGen.removeGenerator("shortgrass");
            grassGen.removeGenerator("mediumgrass");
            grassGen.removeGenerator("wheatgrass");
            grassGen.removeGenerator("dampgrass");
        }
    }
}

