/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.relauncher;

import com.google.common.base.Throwables;
import java.io.File;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.common.launcher.FMLTweaker;
import net.minecraftforge.fml.relauncher.CoreModManager;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.FMLRelaunchLog;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class FMLLaunchHandler {
    private static FMLLaunchHandler INSTANCE;
    static Side side;
    private LaunchClassLoader classLoader;
    private FMLTweaker tweaker;
    private File minecraftHome;

    public static void configureForClientLaunch(LaunchClassLoader loader, FMLTweaker tweaker) {
        FMLLaunchHandler.instance(loader, tweaker).setupClient();
    }

    public static void configureForServerLaunch(LaunchClassLoader loader, FMLTweaker tweaker) {
        FMLLaunchHandler.instance(loader, tweaker).setupServer();
    }

    private static FMLLaunchHandler instance(LaunchClassLoader launchLoader, FMLTweaker tweaker) {
        if (INSTANCE == null) {
            INSTANCE = new FMLLaunchHandler(launchLoader, tweaker);
        }
        return INSTANCE;
    }

    private FMLLaunchHandler(LaunchClassLoader launchLoader, FMLTweaker tweaker) {
        this.classLoader = launchLoader;
        this.tweaker = tweaker;
        this.minecraftHome = tweaker.getGameDir();
        this.classLoader.addClassLoaderExclusion("net.minecraftforge.fml.relauncher.");
        this.classLoader.addClassLoaderExclusion("net.minecraftforge.classloading.");
        this.classLoader.addTransformerExclusion("net.minecraftforge.fml.common.asm.transformers.");
        this.classLoader.addTransformerExclusion("net.minecraftforge.fml.common.patcher.");
        this.classLoader.addTransformerExclusion("net.minecraftforge.fml.repackage.");
        this.classLoader.addClassLoaderExclusion("org.apache.");
        this.classLoader.addClassLoaderExclusion("com.google.common.");
        this.classLoader.addClassLoaderExclusion("org.objectweb.asm.");
        this.classLoader.addClassLoaderExclusion("LZMA.");
    }

    private void setupClient() {
        FMLRelaunchLog.side = Side.CLIENT;
        side = Side.CLIENT;
        this.setupHome();
    }

    private void setupServer() {
        FMLRelaunchLog.side = Side.SERVER;
        side = Side.SERVER;
        this.setupHome();
    }

    private void setupHome() {
        FMLInjectionData.build(this.minecraftHome, this.classLoader);
        FMLRelaunchLog.minecraftHome = this.minecraftHome;
        FMLRelaunchLog.info("Forge Mod Loader version %s.%s.%s.%s for Minecraft %s loading", FMLInjectionData.major, FMLInjectionData.minor, FMLInjectionData.rev, FMLInjectionData.build, FMLInjectionData.mccversion, FMLInjectionData.mcpversion);
        FMLRelaunchLog.info("Java is %s, version %s, running on %s:%s:%s, installed at %s", System.getProperty("java.vm.name"), System.getProperty("java.version"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.home"));
        FMLRelaunchLog.fine("Java classpath at launch is %s", System.getProperty("java.class.path"));
        FMLRelaunchLog.fine("Java library path at launch is %s", System.getProperty("java.library.path"));
        try {
            CoreModManager.handleLaunch(this.minecraftHome, this.classLoader, this.tweaker);
        }
        catch (Throwable t) {
            t.printStackTrace();
            FMLRelaunchLog.log(Level.ERROR, t, "An error occurred trying to configure the minecraft home at %s for Forge Mod Loader", this.minecraftHome.getAbsolutePath());
            throw Throwables.propagate((Throwable)t);
        }
    }

    public static Side side() {
        return side;
    }

    private void injectPostfixTransformers() {
        CoreModManager.injectTransformers(this.classLoader);
    }

    public static void appendCoreMods() {
        INSTANCE.injectPostfixTransformers();
    }
}

