/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.handshake;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.FMLNetworkException;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.PacketLoggingHandler;
import net.minecraftforge.fml.common.network.handshake.ChannelRegistrationHandler;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeClientState;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeCodec;
import net.minecraftforge.fml.common.network.handshake.FMLHandshakeServerState;
import net.minecraftforge.fml.common.network.handshake.HandshakeInjector;
import net.minecraftforge.fml.common.network.handshake.HandshakeMessageHandler;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;

public class NetworkDispatcher
extends SimpleChannelInboundHandler<fj<?>>
implements ChannelOutboundHandler {
    private static boolean DEBUG_HANDSHAKE = Boolean.parseBoolean(System.getProperty("fml.debugNetworkHandshake", "false"));
    public static final AttributeKey<NetworkDispatcher> FML_DISPATCHER = AttributeKey.valueOf((String)"fml:dispatcher");
    public static final AttributeKey<Boolean> IS_LOCAL = AttributeKey.valueOf((String)"fml:isLocal");
    public static final AttributeKey<PersistentRegistryManager.GameDataSnapshot> FML_GAMEDATA_SNAPSHOT = AttributeKey.valueOf((String)"fml:gameDataSnapshot");
    public final eo manager;
    private final mp scm;
    private lu player;
    private ConnectionState state;
    private ConnectionType connectionType;
    private final Side side;
    private final EmbeddedChannel handshakeChannel;
    private me serverHandler;
    private et netHandler;
    private Map<String, String> modList;
    private int overrideLoginDim;
    private MultiPartCustomPayload multipart = null;

    public static NetworkDispatcher get(eo manager) {
        return (NetworkDispatcher)((Object)manager.channel().attr(FML_DISPATCHER).get());
    }

    public static NetworkDispatcher allocAndSet(eo manager) {
        NetworkDispatcher net = new NetworkDispatcher(manager);
        manager.channel().attr(FML_DISPATCHER).getAndSet((Object)net);
        return net;
    }

    public static NetworkDispatcher allocAndSet(eo manager, mp scm) {
        NetworkDispatcher net = new NetworkDispatcher(manager, scm);
        manager.channel().attr(FML_DISPATCHER).getAndSet((Object)net);
        return net;
    }

    public NetworkDispatcher(eo manager) {
        super(false);
        this.manager = manager;
        this.scm = null;
        this.side = Side.CLIENT;
        this.handshakeChannel = new EmbeddedChannel(new ChannelHandler[]{new HandshakeInjector(this), new ChannelRegistrationHandler(), new FMLHandshakeCodec(), new HandshakeMessageHandler<FMLHandshakeClientState>(FMLHandshakeClientState.class)});
        this.handshakeChannel.attr(FML_DISPATCHER).set((Object)this);
        this.handshakeChannel.attr(NetworkRegistry.CHANNEL_SOURCE).set((Object)Side.SERVER);
        this.handshakeChannel.attr(NetworkRegistry.FML_CHANNEL).set((Object)"FML|HS");
        this.handshakeChannel.attr(IS_LOCAL).set((Object)manager.c());
        if (DEBUG_HANDSHAKE) {
            PacketLoggingHandler.register(manager);
        }
    }

    public NetworkDispatcher(eo manager, mp scm) {
        super(false);
        this.manager = manager;
        this.scm = scm;
        this.side = Side.SERVER;
        this.handshakeChannel = new EmbeddedChannel(new ChannelHandler[]{new HandshakeInjector(this), new ChannelRegistrationHandler(), new FMLHandshakeCodec(), new HandshakeMessageHandler<FMLHandshakeServerState>(FMLHandshakeServerState.class)});
        this.handshakeChannel.attr(FML_DISPATCHER).set((Object)this);
        this.handshakeChannel.attr(NetworkRegistry.CHANNEL_SOURCE).set((Object)Side.CLIENT);
        this.handshakeChannel.attr(NetworkRegistry.FML_CHANNEL).set((Object)"FML|HS");
        this.handshakeChannel.attr(IS_LOCAL).set((Object)manager.c());
        if (DEBUG_HANDSHAKE) {
            PacketLoggingHandler.register(manager);
        }
    }

    public void serverToClientHandshake(lu player) {
        this.player = player;
        Boolean fml = (Boolean)this.manager.channel().attr(NetworkRegistry.FML_MARKER).get();
        if (fml != null && fml.booleanValue()) {
            this.insertIntoChannel();
        } else {
            this.serverInitiateHandshake();
            FMLLog.info("Connection received without FML marker, assuming vanilla.", new Object[0]);
            this.completeServerSideConnection(ConnectionType.VANILLA);
        }
    }

    protected void setModList(Map<String, String> modList) {
        this.modList = modList;
    }

    private void insertIntoChannel() {
        this.manager.channel().config().setAutoRead(false);
        this.manager.channel().pipeline().addBefore("packet_handler", "fml:packet_handler", (ChannelHandler)this);
    }

    public void clientToServerHandshake() {
        this.insertIntoChannel();
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (this.state != null) {
            FMLLog.getLogger().log(Level.INFO, "Opening channel which already seems to have a state set. This is a vanilla connection. Handshake handler will stop now");
            return;
        }
        FMLLog.getLogger().log(Level.TRACE, "Handshake channel activating");
        this.state = ConnectionState.OPENING;
        this.handshakeChannel.pipeline().fireUserEventTriggered((Object)this);
        this.manager.channel().config().setAutoRead(true);
    }

    int serverInitiateHandshake() {
        int dimension;
        this.state = ConnectionState.AWAITING_HANDSHAKE;
        this.serverHandler = new me(this.scm.c(), this.manager, this.player){

            public void E_() {
                if (NetworkDispatcher.this.state == ConnectionState.FINALIZING) {
                    NetworkDispatcher.this.completeServerSideConnection(ConnectionType.MODDED);
                }
                if (this.b.a != this) {
                    return;
                }
                super.E_();
            }
        };
        this.netHandler = this.serverHandler;
        this.player.a = null;
        this.manager.a(ep.b);
        dr playerNBT = this.scm.getPlayerNBT(this.player);
        if (playerNBT != null && DimensionManager.isDimensionRegistered(dimension = playerNBT.h("Dimension"))) {
            return dimension;
        }
        return 0;
    }

    void clientListenForServerHandshake() {
        this.manager.a(ep.b);
        this.netHandler = FMLCommonHandler.instance().getClientPlayHandler();
        this.state = ConnectionState.AWAITING_HANDSHAKE;
    }

    private void completeClientSideConnection(ConnectionType type) {
        this.connectionType = type;
        FMLLog.info("[%s] Client side %s connection established", Thread.currentThread().getName(), this.connectionType.name().toLowerCase(Locale.ENGLISH));
        this.state = ConnectionState.CONNECTED;
        MinecraftForge.EVENT_BUS.post(new FMLNetworkEvent.ClientConnectedToServerEvent(this.manager, this.connectionType.name()));
    }

    private synchronized void completeServerSideConnection(ConnectionType type) {
        this.connectionType = type;
        FMLLog.info("[%s] Server side %s connection established", Thread.currentThread().getName(), this.connectionType.name().toLowerCase(Locale.ENGLISH));
        this.state = ConnectionState.CONNECTED;
        MinecraftForge.EVENT_BUS.post(new FMLNetworkEvent.ServerConnectionFromClientEvent(this.manager));
        if (DEBUG_HANDSHAKE) {
            this.manager.a((ey)new fe("Handshake Complete review log file for details."));
        }
        this.scm.initializeConnectionToPlayer(this.manager, this.player, this.serverHandler);
    }

    protected void channelRead0(ChannelHandlerContext ctx, fj<?> msg) throws Exception {
        boolean handled = false;
        if (msg instanceof it) {
            handled = this.handleServerSideCustomPacket((it)msg, ctx);
        } else if (msg instanceof gl) {
            handled = this.handleClientSideCustomPacket((gl)msg, ctx);
        } else if (this.state != ConnectionState.CONNECTED && this.state != ConnectionState.HANDSHAKECOMPLETE) {
            handled = this.handleVanilla(msg);
        }
        if (!handled) {
            ctx.fireChannelRead(msg);
        }
    }

    private boolean handleVanilla(fj<?> msg) {
        if (this.state == ConnectionState.AWAITING_HANDSHAKE && msg instanceof gw) {
            this.handshakeChannel.pipeline().fireUserEventTriggered(msg);
        } else {
            FMLLog.info("Unexpected packet during modded negotiation - assuming vanilla or keepalives : %s", msg.getClass().getName());
        }
        return false;
    }

    public et getNetHandler() {
        return this.netHandler;
    }

    public Map<String, String> getModList() {
        return Collections.unmodifiableMap(this.modList);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof ConnectionType && this.side == Side.SERVER) {
            FMLLog.info("Timeout occurred, assuming a vanilla client", new Object[0]);
            this.kickVanilla();
        }
    }

    private void kickVanilla() {
        this.kickWithMessage("This is modded. No modded response received. Bye!");
    }

    private void kickWithMessage(String message) {
        final fe TextComponentString = new fe(message);
        if (this.side == Side.CLIENT) {
            this.manager.a((ey)TextComponentString);
        } else {
            this.manager.a((fj)new gn((ey)TextComponentString), (GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                public void operationComplete(Future<? super Void> result) {
                    NetworkDispatcher.this.manager.a((ey)TextComponentString);
                }
            }, (GenericFutureListener[])null);
        }
        this.manager.channel().config().setAutoRead(false);
    }

    private boolean handleClientSideCustomPacket(gl msg, ChannelHandlerContext context) {
        String channelName = msg.a();
        if ("FML|MP".equals(channelName)) {
            try {
                if (this.multipart == null) {
                    this.multipart = new MultiPartCustomPayload(msg.b());
                } else {
                    this.multipart.processPart(msg.b());
                }
            }
            catch (IOException e2) {
                this.kickWithMessage(e2.getMessage());
                this.multipart = null;
                return true;
            }
            if (this.multipart.isComplete()) {
                msg = this.multipart;
                channelName = msg.a();
                this.multipart = null;
            } else {
                return true;
            }
        }
        if ("FML|HS".equals(channelName) || "REGISTER".equals(channelName) || "UNREGISTER".equals(channelName)) {
            FMLProxyPacket proxy = new FMLProxyPacket(msg);
            proxy.setDispatcher(this);
            this.handshakeChannel.writeInbound(new Object[]{proxy});
            for (Object push : this.handshakeChannel.inboundMessages()) {
                List<FMLProxyPacket> messageResult = FMLNetworkHandler.forwardHandshake((FMLMessage.CompleteHandshake)push, this, Side.CLIENT);
                for (FMLProxyPacket result : messageResult) {
                    result.setTarget(Side.CLIENT);
                    result.payload().resetReaderIndex();
                    context.fireChannelRead((Object)result);
                }
            }
            this.handshakeChannel.inboundMessages().clear();
            return true;
        }
        if (NetworkRegistry.INSTANCE.hasChannel(channelName, Side.CLIENT)) {
            FMLProxyPacket proxy = new FMLProxyPacket(msg);
            proxy.setDispatcher(this);
            context.fireChannelRead((Object)proxy);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleServerSideCustomPacket(it msg, ChannelHandlerContext context) {
        String channelName;
        if (this.state == ConnectionState.AWAITING_HANDSHAKE) {
            NetworkDispatcher networkDispatcher = this;
            synchronized (networkDispatcher) {
                if (this.state == ConnectionState.AWAITING_HANDSHAKE) {
                    this.state = ConnectionState.HANDSHAKING;
                }
            }
        }
        if ("FML|HS".equals(channelName = msg.a()) || "REGISTER".equals(channelName) || "UNREGISTER".equals(channelName)) {
            FMLProxyPacket proxy = new FMLProxyPacket(msg);
            proxy.setDispatcher(this);
            this.handshakeChannel.writeInbound(new Object[]{proxy});
            for (Object push : this.handshakeChannel.inboundMessages()) {
                List<FMLProxyPacket> messageResult = FMLNetworkHandler.forwardHandshake((FMLMessage.CompleteHandshake)push, this, Side.SERVER);
                for (FMLProxyPacket result : messageResult) {
                    result.setTarget(Side.SERVER);
                    result.payload().resetReaderIndex();
                    context.fireChannelRead((Object)result);
                }
            }
            this.handshakeChannel.inboundMessages().clear();
            return true;
        }
        if (NetworkRegistry.INSTANCE.hasChannel(channelName, Side.SERVER)) {
            FMLProxyPacket proxy = new FMLProxyPacket(msg);
            proxy.setDispatcher(this);
            context.fireChannelRead((Object)proxy);
            return true;
        }
        return false;
    }

    public void sendProxy(FMLProxyPacket msg) {
        if (!this.manager.g()) {
            msg = msg.copy();
        }
        this.manager.a((fj)msg);
    }

    public void rejectHandshake(String result) {
        this.kickWithMessage(result);
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        ctx.connect(remoteAddress, localAddress, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (this.side == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.post(new FMLNetworkEvent.ClientDisconnectionFromServerEvent(this.manager));
        } else {
            MinecraftForge.EVENT_BUS.post(new FMLNetworkEvent.ServerDisconnectionFromClientEvent(this.manager));
        }
        this.cleanAttributes(ctx);
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (this.side == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.post(new FMLNetworkEvent.ClientDisconnectionFromServerEvent(this.manager));
        } else {
            MinecraftForge.EVENT_BUS.post(new FMLNetworkEvent.ServerDisconnectionFromClientEvent(this.manager));
        }
        this.cleanAttributes(ctx);
        ctx.close(promise);
    }

    @Deprecated
    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.deregister(promise);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        ctx.read();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof FMLProxyPacket) {
            if (this.side == Side.CLIENT) {
                ctx.write(((FMLProxyPacket)msg).toC17Packet(), promise);
            } else {
                List<fj<fm>> parts = ((FMLProxyPacket)msg).toS3FPackets();
                for (fj<fm> pkt : parts) {
                    ctx.write(pkt, promise);
                }
            }
        } else {
            ctx.write(msg, promise);
        }
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void completeHandshake(Side target) {
        if (this.state == ConnectionState.CONNECTED) {
            FMLLog.severe("Attempt to double complete the network connection!", new Object[0]);
            throw new FMLNetworkException("Attempt to double complete!");
        }
        if (this.side == Side.CLIENT) {
            this.completeClientSideConnection(ConnectionType.MODDED);
        } else {
            this.state = ConnectionState.FINALIZING;
        }
    }

    public void completeClientHandshake() {
        this.state = ConnectionState.HANDSHAKECOMPLETE;
    }

    public void abortClientHandshake(String type) {
        FMLLog.log(Level.INFO, "Aborting client handshake \"%s\"", type);
        this.completeClientSideConnection(ConnectionType.valueOf(type));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!(cause instanceof ClosedChannelException)) {
            if (cause.getMessage() != null && cause.getMessage().contains("Connection reset by peer")) {
                FMLLog.log(Level.DEBUG, cause, "Muted NetworkDispatcher exception", new Object[0]);
            } else {
                FMLLog.log(Level.ERROR, cause, "NetworkDispatcher exception", new Object[0]);
            }
        }
        super.exceptionCaught(ctx, cause);
    }

    private void cleanAttributes(ChannelHandlerContext ctx) {
        ctx.channel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).remove();
        ctx.channel().attr(NetworkRegistry.NET_HANDLER).remove();
        ctx.channel().attr(FML_DISPATCHER).remove();
        this.handshakeChannel.attr(FML_DISPATCHER).remove();
        this.manager.channel().attr(FML_DISPATCHER).remove();
    }

    public void setOverrideDimension(int overrideDim) {
        this.overrideLoginDim = overrideDim;
        FMLLog.fine("Received override dimension %d", overrideDim);
    }

    public int getOverrideDimension(gw packetIn) {
        FMLLog.fine("Overriding dimension: using %d", this.overrideLoginDim);
        return this.overrideLoginDim != 0 ? this.overrideLoginDim : packetIn.d();
    }

    private class MultiPartCustomPayload
    extends gl {
        private String channel;
        private byte[] data;
        private eq data_buf = null;
        private int part_count = 0;
        private int part_expected = 0;
        private int offset = 0;

        private MultiPartCustomPayload(eq preamble) throws IOException {
            this.channel = preamble.e(20);
            this.part_count = preamble.readUnsignedByte();
            int length = preamble.readInt();
            if (length <= 0 || length >= -16797616) {
                throw new IOException("The received FML MultiPart packet outside of valid length bounds, Max: -16797616, Received: " + length);
            }
            this.data = new byte[length];
            this.data_buf = new eq(Unpooled.wrappedBuffer((byte[])this.data));
        }

        public void processPart(eq input) throws IOException {
            int part = input.readByte() & 0xFF;
            if (part != this.part_expected) {
                throw new IOException("Received FML MultiPart packet out of order, Expected " + this.part_expected + " Got " + part);
            }
            int len = input.readableBytes() - 1;
            input.readBytes(this.data, this.offset, len);
            ++this.part_expected;
            this.offset += len;
        }

        public boolean isComplete() {
            return this.part_expected == this.part_count;
        }

        public String a() {
            return this.channel;
        }

        public eq b() {
            return this.data_buf;
        }
    }

    private static enum ConnectionType {
        MODDED,
        BUKKIT,
        VANILLA;

    }

    private static enum ConnectionState {
        OPENING,
        AWAITING_HANDSHAKE,
        HANDSHAKING,
        HANDSHAKECOMPLETE,
        FINALIZING,
        CONNECTED;

    }
}

