/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.network.handshake;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.common.registry.PersistentRegistryManager;

public abstract class FMLHandshakeMessage {
    public static FMLProxyPacket makeCustomChannelRegistration(Set<String> channels) {
        String salutation = Joiner.on((char)'\u0000').join(Iterables.concat(Arrays.asList("FML|HS", "FML", "FML|MP"), channels));
        FMLProxyPacket proxy = new FMLProxyPacket(new eq(Unpooled.wrappedBuffer((byte[])salutation.getBytes(Charsets.UTF_8))), "REGISTER");
        return proxy;
    }

    public void fromBytes(ByteBuf buffer) {
    }

    public void toBytes(ByteBuf buffer) {
    }

    public String toString(Class<? extends Enum<?>> side) {
        return this.getClass().getName().substring(this.getClass().getName().lastIndexOf(36));
    }

    public static class HandshakeReset
    extends FMLHandshakeMessage {
    }

    public static class HandshakeAck
    extends FMLHandshakeMessage {
        int phase;

        public HandshakeAck() {
        }

        HandshakeAck(int phase) {
            this.phase = phase;
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            this.phase = buffer.readByte();
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeByte(this.phase);
        }

        @Override
        public String toString(Class<? extends Enum<?>> side) {
            return super.toString(side) + ":{" + this.phase + "}";
        }
    }

    public static class RegistryData
    extends FMLHandshakeMessage {
        private boolean hasMore;
        private kn name;
        private Map<kn, Integer> ids;
        private Set<kn> substitutions;
        private Set<kn> dummied;

        public RegistryData() {
        }

        public RegistryData(boolean hasMore, kn name, PersistentRegistryManager.GameDataSnapshot.Entry entry) {
            this.hasMore = hasMore;
            this.name = name;
            this.ids = entry.ids;
            this.substitutions = entry.substitutions;
            this.dummied = entry.dummied;
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            int i;
            this.hasMore = buffer.readBoolean();
            this.name = new kn(ByteBufUtils.readUTF8String(buffer));
            int length = ByteBufUtils.readVarInt(buffer, 3);
            this.ids = Maps.newHashMap();
            for (i = 0; i < length; ++i) {
                this.ids.put(new kn(ByteBufUtils.readUTF8String(buffer)), ByteBufUtils.readVarInt(buffer, 3));
            }
            length = ByteBufUtils.readVarInt(buffer, 3);
            this.substitutions = Sets.newHashSet();
            for (i = 0; i < length; ++i) {
                this.substitutions.add(new kn(ByteBufUtils.readUTF8String(buffer)));
            }
            this.dummied = Sets.newHashSet();
            if (!buffer.isReadable()) {
                return;
            }
            length = ByteBufUtils.readVarInt(buffer, 3);
            for (i = 0; i < length; ++i) {
                this.dummied.add(new kn(ByteBufUtils.readUTF8String(buffer)));
            }
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeBoolean(this.hasMore);
            ByteBufUtils.writeUTF8String(buffer, this.name.toString());
            ByteBufUtils.writeVarInt(buffer, this.ids.size(), 3);
            for (Map.Entry<kn, Integer> entry : this.ids.entrySet()) {
                ByteBufUtils.writeUTF8String(buffer, entry.getKey().toString());
                ByteBufUtils.writeVarInt(buffer, entry.getValue(), 3);
            }
            ByteBufUtils.writeVarInt(buffer, this.substitutions.size(), 3);
            for (kn kn2 : this.substitutions) {
                ByteBufUtils.writeUTF8String(buffer, kn2.toString());
            }
            ByteBufUtils.writeVarInt(buffer, this.dummied.size(), 3);
            for (kn kn3 : this.dummied) {
                ByteBufUtils.writeUTF8String(buffer, kn3.toString());
            }
        }

        public Map<kn, Integer> getIdMap() {
            return this.ids;
        }

        public Set<kn> getSubstitutions() {
            return this.substitutions;
        }

        public Set<kn> getDummied() {
            return this.dummied;
        }

        public kn getName() {
            return this.name;
        }

        public boolean hasMore() {
            return this.hasMore;
        }

        @Override
        public String toString(Class<? extends Enum<?>> side) {
            return super.toString(side) + ":" + this.ids.size() + " mappings";
        }
    }

    public static class ModList
    extends FMLHandshakeMessage {
        private Map<String, String> modTags = Maps.newHashMap();

        public ModList() {
        }

        public ModList(List<ModContainer> modList) {
            for (ModContainer mod : modList) {
                this.modTags.put(mod.getModId(), mod.getVersion());
            }
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            super.toBytes(buffer);
            ByteBufUtils.writeVarInt(buffer, this.modTags.size(), 2);
            for (Map.Entry<String, String> modTag : this.modTags.entrySet()) {
                ByteBufUtils.writeUTF8String(buffer, modTag.getKey());
                ByteBufUtils.writeUTF8String(buffer, modTag.getValue());
            }
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            super.fromBytes(buffer);
            int modCount = ByteBufUtils.readVarInt(buffer, 2);
            for (int i = 0; i < modCount; ++i) {
                this.modTags.put(ByteBufUtils.readUTF8String(buffer), ByteBufUtils.readUTF8String(buffer));
            }
        }

        public String modListAsString() {
            return Joiner.on((char)',').withKeyValueSeparator("@").join(this.modTags);
        }

        public int modListSize() {
            return this.modTags.size();
        }

        public Map<String, String> modList() {
            return this.modTags;
        }

        @Override
        public String toString(Class<? extends Enum<?>> side) {
            return super.toString(side) + ":" + this.modTags.size() + " mods";
        }
    }

    public static class ClientHello
    extends FMLHandshakeMessage {
        private byte serverProtocolVersion;

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeByte(2);
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            this.serverProtocolVersion = buffer.readByte();
        }

        public byte protocolVersion() {
            return this.serverProtocolVersion;
        }
    }

    public static class ServerHello
    extends FMLHandshakeMessage {
        private byte serverProtocolVersion;
        private int overrideDimension;

        public ServerHello() {
        }

        public ServerHello(int overrideDim) {
            this.overrideDimension = overrideDim;
        }

        @Override
        public void toBytes(ByteBuf buffer) {
            buffer.writeByte(2);
            buffer.writeInt(this.overrideDimension);
        }

        @Override
        public void fromBytes(ByteBuf buffer) {
            this.serverProtocolVersion = buffer.readByte();
            if (this.serverProtocolVersion > 1) {
                this.overrideDimension = buffer.readInt();
                FMLLog.fine("Server FML protocol version %d, 4 byte dimension received %d", this.serverProtocolVersion, this.overrideDimension);
            } else {
                FMLLog.info("Server FML protocol version %d, no additional data received", this.serverProtocolVersion);
            }
        }

        public byte protocolVersion() {
            return this.serverProtocolVersion;
        }

        public int overrideDim() {
            return this.overrideDimension;
        }
    }
}

