/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;

public final class MultiLayerModel
implements IModelCustomData {
    public static final MultiLayerModel INSTANCE = new MultiLayerModel((ImmutableMap<Optional<ahv>, byq>)ImmutableMap.of());
    private final ImmutableMap<Optional<ahv>, byq> models;

    public MultiLayerModel(ImmutableMap<Optional<ahv>, byq> models) {
        this.models = models;
    }

    @Override
    public Collection<kn> getDependencies() {
        return ImmutableList.copyOf((Collection)this.models.values());
    }

    @Override
    public Collection<kn> getTextures() {
        return ImmutableList.of();
    }

    private static ImmutableMap<Optional<ahv>, byl> buildModels(ImmutableMap<Optional<ahv>, byq> models, IModelState state, bwo format, Function<kn, bwe> bakedTextureGetter) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Optional key : models.keySet()) {
            IModel model = ModelLoaderRegistry.getModelOrLogError((kn)models.get((Object)key), "Couldn't load MultiLayerModel dependency: " + models.get((Object)key));
            builder.put((Object)key, (Object)model.bake(new ModelStateComposition(state, model.getDefaultState()), format, bakedTextureGetter));
        }
        return builder.build();
    }

    @Override
    public byl bake(IModelState state, bwo format, Function<kn, bwe> bakedTextureGetter) {
        IModel missing = ModelLoaderRegistry.getMissingModel();
        return new MultiLayerBakedModel(MultiLayerModel.buildModels(this.models, state, format, bakedTextureGetter), missing.bake(missing.getDefaultState(), format, bakedTextureGetter), IPerspectiveAwareModel.MapWrapper.getTransforms(state));
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public MultiLayerModel process(ImmutableMap<String, String> customData) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String key : customData.keySet()) {
            if ("base".equals(key)) {
                builder.put((Object)Optional.absent(), (Object)this.getLocation((String)customData.get((Object)key)));
            }
            for (ahv layer : ahv.values()) {
                if (!layer.toString().equals(key)) continue;
                builder.put((Object)Optional.of((Object)layer), (Object)this.getLocation((String)customData.get((Object)key)));
            }
        }
        ImmutableMap models = builder.build();
        if (models.isEmpty()) {
            return INSTANCE;
        }
        return new MultiLayerModel((ImmutableMap<Optional<ahv>, byq>)models);
    }

    private byq getLocation(String json) {
        JsonElement e = new JsonParser().parse(json);
        if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isString()) {
            return new byq(e.getAsString());
        }
        FMLLog.severe("Expect ModelResourceLocation, got: ", json);
        return new byq("builtin/missing", "missing");
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        public void a(bxd resourceManager) {
        }

        @Override
        public boolean accepts(kn modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("multi-layer") || modelLocation.a().equals("models/block/multi-layer") || modelLocation.a().equals("models/item/multi-layer"));
        }

        @Override
        public IModel loadModel(kn modelLocation) {
            return INSTANCE;
        }
    }

    private static final class MultiLayerBakedModel
    implements IPerspectiveAwareModel {
        private final ImmutableMap<Optional<ahv>, byl> models;
        private final ImmutableMap<bpl.b, TRSRTransformation> cameraTransforms;
        private final byl base;
        private final byl missing;
        private final ImmutableMap<Optional<ct>, ImmutableList<boy>> quads;

        public MultiLayerBakedModel(ImmutableMap<Optional<ahv>, byl> models, byl missing, ImmutableMap<bpl.b, TRSRTransformation> cameraTransforms) {
            this.models = models;
            this.cameraTransforms = cameraTransforms;
            this.missing = missing;
            this.base = models.containsKey((Object)Optional.absent()) ? (byl)models.get((Object)Optional.absent()) : missing;
            ImmutableMap.Builder quadBuilder = ImmutableMap.builder();
            quadBuilder.put((Object)Optional.absent(), MultiLayerBakedModel.buildQuads(models, (Optional<ct>)Optional.absent()));
            for (ct side : ct.values()) {
                quadBuilder.put((Object)Optional.of((Object)side), MultiLayerBakedModel.buildQuads(models, (Optional<ct>)Optional.of((Object)side)));
            }
            this.quads = quadBuilder.build();
        }

        private static ImmutableList<boy> buildQuads(ImmutableMap<Optional<ahv>, byl> models, Optional<ct> side) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (byl model : models.values()) {
                builder.addAll((Iterable)model.a(null, (ct)side.orNull(), 0L));
            }
            return builder.build();
        }

        public List<boy> a(ars state, ct side, long rand) {
            ahv layer = MinecraftForgeClient.getRenderLayer();
            if (layer == null) {
                return (List)this.quads.get((Object)Optional.fromNullable((Object)side));
            }
            byl model = !this.models.containsKey((Object)Optional.of((Object)layer)) ? this.missing : (byl)this.models.get((Object)Optional.of((Object)layer));
            return model.a(state, side, rand);
        }

        public boolean a() {
            return this.base.a();
        }

        public boolean b() {
            return this.base.b();
        }

        public boolean c() {
            return this.base.c();
        }

        public bwe d() {
            return this.base.d();
        }

        public bpl e() {
            return bpl.a;
        }

        @Override
        public Pair<? extends byl, Matrix4f> handlePerspective(bpl.b cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((byl)this, this.cameraTransforms, cameraTransformType);
        }

        public bpj f() {
            return bpj.a;
        }
    }
}

