/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.BitSet;
import java.util.concurrent.TimeUnit;
import net.minecraftforge.client.ForgeHooksClient;
import org.apache.commons.lang3.tuple.Pair;

public class MinecraftForgeClient {
    private static BitSet stencilBits = new BitSet(8);
    private static final LoadingCache<Pair<aid, cm>, aim> regionCache;

    public static int getRenderPass() {
        return ForgeHooksClient.renderPass;
    }

    public static ahv getRenderLayer() {
        return ForgeHooksClient.renderLayer.get();
    }

    public static int reserveStencilBit() {
        int bit = stencilBits.nextSetBit(0);
        if (bit >= 0) {
            stencilBits.clear(bit);
        }
        return bit;
    }

    public static void releaseStencilBit(int bit) {
        if (bit >= 0 && bit < stencilBits.length()) {
            stencilBits.set(bit);
        }
    }

    public static void onRebuildChunk(aid world, cm position, aim cache) {
        regionCache.put((Object)Pair.of((Object)world, (Object)position), (Object)cache);
    }

    public static aim getRegionRenderCache(aid world, cm pos) {
        int x = pos.p() & 0xFFFFFFF0;
        int y = pos.q() & 0xFFFFFFF0;
        int z = pos.r() & 0xFFFFFFF0;
        return (aim)regionCache.getUnchecked((Object)Pair.of((Object)world, (Object)new cm(x, y, z)));
    }

    static {
        stencilBits.set(0, 8);
        regionCache = CacheBuilder.newBuilder().maximumSize(500L).concurrencyLevel(5).expireAfterAccess(1L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<Pair<aid, cm>, aim>(){

            public aim load(Pair<aid, cm> key) throws Exception {
                return new aim((aid)key.getLeft(), ((cm)key.getRight()).a(-1, -1, -1), ((cm)key.getRight()).a(16, 16, 16), 1);
            }
        });
    }
}

