/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.api.Recipes;
import com.mrcrayfish.furniture.gui.containers.ContainerOven;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityOven
extends TileEntityLockable
implements ISidedInventory,
ITickable {
    private static final int[] left_slots = new int[]{0, 1, 2, 3};
    private static final int[] right_slots = new int[]{4, 5, 6, 7};
    private ItemStack[] inventory = new ItemStack[8];
    public int cookTime = 0;
    public int cookingTime = 0;
    public int cookingItem = 0;
    public static final int COOK_TIME = 200;
    private Random rand = new Random();

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.inventory[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.inventory[par1] != null) {
            if (this.inventory[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.inventory[par1];
                this.inventory[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[par1].func_77979_a(par2);
            if (this.inventory[par1].field_77994_a == 0) {
                this.inventory[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.inventory[par1] != null) {
            ItemStack itemstack = this.inventory[par1];
            this.inventory[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.inventory[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        NBTTagList tagList;
        super.func_145839_a(tagCompound);
        this.inventory = new ItemStack[this.func_70302_i_()];
        if (tagCompound.func_74764_b("inventory") && (tagList = (NBTTagList)tagCompound.func_74781_a("inventory")) != null) {
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = tagList.func_150305_b(i);
                byte slot = itemTag.func_74771_c("slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)itemTag);
            }
        }
        this.cookTime = tagCompound.func_74765_d("cookTime");
        this.cookingTime = tagCompound.func_74765_d("cookingTime");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74777_a("cookTime", (short)this.cookTime);
        tagCompound.func_74777_a("cookingTime", (short)this.cookingTime);
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.length; ++slot) {
            if (this.inventory[slot] == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("slot", (byte)slot);
            this.inventory[slot].func_77955_b(itemTag);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        tagCompound.func_74782_a("inventory", (NBTBase)tagList);
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189515_b(new NBTTagCompound()));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCookProgressScaled(int par1) {
        return this.cookingTime * par1 / 200;
    }

    public boolean isBurning() {
        return this.cookTime > 0;
    }

    public boolean isCooking() {
        return this.cookingTime > 0;
    }

    public int getCookingItem() {
        return this.cookingItem;
    }

    public void func_73660_a() {
        boolean flag = this.cookingTime > 0;
        this.cookingItem = this.canCook();
        if (this.cookingItem != -1) {
            ++this.cookingTime;
            if (!flag) {
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
            }
            if (this.cookingTime == 200) {
                this.cookingTime = 0;
                this.cookItems();
            }
            if (this.field_145850_b.field_72995_K) {
                double randX = this.rand.nextDouble();
                double randZ = this.rand.nextDouble();
                this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)this.field_174879_c.func_177958_n() + randX, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + randZ, 0.0, 0.0, 0.0, new int[0]);
            }
        } else {
            this.cookingTime = 0;
        }
        if (flag && this.cookingTime == 0) {
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
        }
    }

    public boolean canCook(int i) {
        if (i < 4 && this.inventory[i] != null) {
            return Recipes.getOvenRecipeFromInput(this.inventory[i]) != null;
        }
        return false;
    }

    private int canCook() {
        boolean hasItem = false;
        int itemNum = -1;
        for (int x = 0; x < 4; ++x) {
            if (this.inventory[x] == null) continue;
            hasItem = true;
            itemNum = x;
            break;
        }
        if (hasItem) {
            RecipeData data = Recipes.getOvenRecipeFromInput(this.inventory[itemNum]);
            if (data == null) {
                return -1;
            }
            if (this.inventory[itemNum + 4] == null) {
                return itemNum;
            }
            if (this.inventory[itemNum + 4].func_77973_b() != data.getOutput().func_77973_b()) {
                return -1;
            }
            if (this.inventory[itemNum + 4].field_77994_a < this.func_70297_j_() && this.inventory[itemNum + 4].field_77994_a < this.inventory[itemNum + 4].func_77976_d()) {
                return itemNum;
            }
            if (this.inventory[itemNum + 4].field_77994_a < data.getOutput().func_77976_d()) {
                return itemNum;
            }
            return -1;
        }
        return -1;
    }

    public void cookItems() {
        int itemNum = this.canCook();
        if (itemNum != -1) {
            RecipeData data = Recipes.getOvenRecipeFromInput(this.inventory[itemNum]);
            if (data == null) {
                return;
            }
            if (this.inventory[itemNum + 4] == null) {
                this.inventory[itemNum + 4] = data.getOutput().func_77946_l();
            } else if (this.inventory[itemNum + 4].func_77973_b() == data.getOutput().func_77973_b() && this.inventory[itemNum + 4].func_77952_i() == data.getOutput().func_77952_i()) {
                this.inventory[itemNum + 4].field_77994_a += data.getOutput().func_77946_l().field_77994_a;
            }
            if (this.inventory[itemNum].func_77973_b().func_77634_r()) {
                this.inventory[itemNum] = new ItemStack(this.inventory[itemNum].func_77973_b().func_77668_q());
            } else {
                --this.inventory[itemNum].field_77994_a;
            }
            if (this.inventory[itemNum].field_77994_a <= 0) {
                this.inventory[itemNum] = null;
            }
        }
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean isStackValidForSlot(int par1, ItemStack par2ItemStack) {
        return RecipeAPI.getOvenRecipeFromInput(par2ItemStack) != null;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return i <= 8;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return "Oven";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN ? right_slots : left_slots;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.isStackValidForSlot(index, itemStackIn) && index < left_slots.length;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index >= left_slots.length;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerOven((IInventory)playerInventory, (IInventory)this);
    }

    public String func_174875_k() {
        return "0";
    }
}

