/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.tileentity;

import com.mrcrayfish.furniture.api.RecipeAPI;
import com.mrcrayfish.furniture.api.RecipeData;
import com.mrcrayfish.furniture.gui.containers.ContainerDishwasher;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockable;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TileEntityDishwasher
extends TileEntityLockable
implements ISidedInventory,
ITickable {
    private static final int[] slots_top = new int[]{0, 1, 2, 3, 4, 5};
    private static final int[] slots_bottom = new int[]{0, 1, 2, 3, 4, 5, 6};
    private static final int[] slots_sides = new int[]{6};
    private ItemStack[] inventory = new ItemStack[7];
    private String customName;
    private boolean washing = false;
    public boolean superMode = false;
    public int progress = 0;
    public int timeRemaining = 0;
    private Random rand = new Random();
    private int timer = 0;

    public void startWashing() {
        if (this.canWash()) {
            if (this.timeRemaining == 0) {
                this.superMode = this.inventory[6].func_77973_b() == FurnitureItems.itemSuperSoapyWater;
                this.inventory[6] = new ItemStack(this.inventory[6].func_77973_b().func_77668_q());
                this.timeRemaining = 5000;
            }
            this.washing = true;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
        }
    }

    public void stopWashing() {
        this.progress = 0;
        this.washing = false;
        this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
    }

    public boolean canWash() {
        if (this.inventory[6] == null && this.timeRemaining == 0) {
            return false;
        }
        if (this.inventory[6] != null && this.timeRemaining == 0) {
            return TileEntityDishwasher.isFuel(this.inventory[6]);
        }
        boolean flag = false;
        for (int i = 0; i < 6; ++i) {
            if (this.inventory[i] == null) continue;
            RecipeData data = RecipeAPI.getDishwasherRecipeFromInput(this.inventory[i]);
            if (data == null) {
                return false;
            }
            flag = true;
        }
        return flag;
    }

    public boolean isWashing() {
        return this.washing;
    }

    public static boolean isFuel(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() == FurnitureItems.itemSoapyWater) {
            return true;
        }
        return stack.func_77973_b() == FurnitureItems.itemSuperSoapyWater;
    }

    public void func_73660_a() {
        if (this.washing) {
            if (!this.canWash()) {
                this.washing = false;
                this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                return;
            }
            if (this.canRepair()) {
                for (int i = 0; i < 6; ++i) {
                    if (this.inventory[i] == null || this.inventory[i].func_77958_k() - this.inventory[i].func_77952_i() == this.inventory[i].func_77958_k()) continue;
                    this.inventory[i].func_77964_b(this.inventory[i].func_77952_i() - 1);
                }
            }
            --this.timeRemaining;
            if (this.timeRemaining <= 0) {
                if (this.inventory[4] != null) {
                    if (this.inventory[4].func_77973_b() == FurnitureItems.itemSoapyWater) {
                        this.superMode = false;
                        this.inventory[4] = new ItemStack(FurnitureItems.itemSoapyWater.func_77668_q());
                        this.timeRemaining = 5000;
                    } else if (this.inventory[4].func_77973_b() == FurnitureItems.itemSuperSoapyWater) {
                        this.superMode = true;
                        this.inventory[4] = new ItemStack(FurnitureItems.itemSuperSoapyWater.func_77668_q());
                        this.timeRemaining = 5000;
                    }
                } else {
                    this.timeRemaining = 0;
                    this.progress = 0;
                    this.washing = false;
                    this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145854_h);
                }
            }
            ++this.progress;
            if (this.timer == 20) {
                this.timer = 0;
            }
            if (this.timer == 0) {
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), FurnitureSounds.dishwasher, SoundCategory.BLOCKS, 0.75f, 1.0f, true);
            }
            ++this.timer;
        }
    }

    public boolean canRepair() {
        return this.progress % (this.superMode ? 20 : 50) == 0;
    }

    public int func_70302_i_() {
        return 7;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int count) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= count) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack itemstack = this.inventory[slot].func_77979_a(count);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack itemstack = this.inventory[slot];
            this.inventory[slot] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        if (tagCompound.func_74764_b("Items")) {
            NBTTagList tagList = (NBTTagList)tagCompound.func_74781_a("Items");
            this.inventory = new ItemStack[7];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound nbt = tagList.func_150305_b(i);
                byte slot = nbt.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)nbt);
            }
        }
        this.washing = tagCompound.func_74767_n("Washing");
        this.superMode = tagCompound.func_74767_n("SuperMode");
        this.progress = tagCompound.func_74762_e("Progress");
        this.timeRemaining = tagCompound.func_74762_e("Remaining");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        NBTTagList tagList = new NBTTagList();
        for (int slot = 0; slot < this.inventory.length; ++slot) {
            if (this.inventory[slot] == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)slot);
            this.inventory[slot].func_77955_b(nbt);
            tagList.func_74742_a((NBTBase)nbt);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tagList);
        tagCompound.func_74757_a("Washing", this.washing);
        tagCompound.func_74757_a("SuperMode", this.superMode);
        tagCompound.func_74768_a("Progress", this.progress);
        tagCompound.func_74768_a("Remaining", this.timeRemaining);
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tagCom = pkt.func_148857_g();
        this.func_145839_a(tagCom);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tagCom = new NBTTagCompound();
        this.func_189515_b(tagCom);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tagCom);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : "Dishwasher";
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        int target = ContainerDishwasher.toolToSlot(stack);
        if (target != -1) {
            return slot == target;
        }
        return true;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.UP) {
            return slots_top;
        }
        if (side == EnumFacing.DOWN) {
            return slots_bottom;
        }
        return slots_sides;
    }

    public boolean func_180462_a(int index, ItemStack stack, EnumFacing side) {
        if (this.func_174893_q_()) {
            return false;
        }
        if (side == EnumFacing.UP) {
            return RecipeAPI.getDishwasherRecipeFromInput(stack) != null;
        }
        if (side != EnumFacing.DOWN) {
            return TileEntityDishwasher.isFuel(stack);
        }
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing side) {
        return side == EnumFacing.DOWN && !TileEntityDishwasher.isFuel(stack) && stack.func_77952_i() == 0 && !this.func_174893_q_();
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerDishwasher((IInventory)playerInventory, (IInventory)this);
    }

    public String func_174875_k() {
        return "0";
    }
}

