/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockFurniture;
import com.mrcrayfish.furniture.init.FurnitureAchievements;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.util.CollisionHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockShower
extends BlockFurniture {
    private static final AxisAlignedBB NOTHING = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private static final AxisAlignedBB SIDE_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SIDE_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SIDE_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB SIDE_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.9375, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockShower(Material material, boolean top) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
        if (top) {
            this.func_149647_a(null);
        }
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return worldIn.func_175623_d(pos.func_177984_a());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), FurnitureBlocks.shower_top.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)), 2);
        ((EntityPlayer)placer).func_71029_a((StatBase)FurnitureAchievements.bathroom);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (this == FurnitureBlocks.shower_bottom) {
            worldIn.func_175655_b(pos.func_177984_a(), false);
        } else {
            worldIn.func_175655_b(pos.func_177977_b(), false);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState aboveState = worldIn.func_180495_p(pos.func_177984_a());
        Block block = aboveState.func_177230_c();
        int metadata = this.func_176201_c(state);
        if (block == FurnitureBlocks.shower_head_off) {
            worldIn.func_180501_a(pos.func_177984_a(), FurnitureBlocks.shower_head_on.func_176223_P().func_177226_a((IProperty)FACING, aboveState.func_177229_b((IProperty)FACING)), 2);
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f, false);
        } else if (block == FurnitureBlocks.shower_head_on) {
            worldIn.func_180501_a(pos.func_177984_a(), FurnitureBlocks.shower_head_off.func_176223_P().func_177226_a((IProperty)FACING, aboveState.func_177229_b((IProperty)FACING)), 2);
            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.5f, false);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return NOTHING;
        }
        int camera = Minecraft.func_71410_x().field_71474_y.field_74320_O;
        EnumFacing facing = Minecraft.func_71410_x().field_71439_g.func_174811_aO();
        int metadata = this.func_176201_c(state);
        if (camera == 1 || camera == 2) {
            if (facing != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d()) {
                switch (Minecraft.func_71410_x().field_71439_g.func_174811_aO()) {
                    case EAST: {
                        return SIDE_EAST;
                    }
                    case NORTH: {
                        return SIDE_NORTH;
                    }
                    case SOUTH: {
                        return SIDE_SOUTH;
                    }
                    case WEST: {
                        return SIDE_WEST;
                    }
                }
            } else {
                return NOTHING;
            }
        }
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB bounds, List<AxisAlignedBB> list, Entity collidingEntity) {
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case EAST: {
                BlockShower.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_NORTH);
                BlockShower.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_EAST);
                BlockShower.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_SOUTH);
                break;
            }
            case NORTH: {
                BlockShower.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_WEST);
                BlockShower.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_NORTH);
                BlockShower.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_EAST);
                break;
            }
            case SOUTH: {
                BlockShower.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_EAST);
                BlockShower.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_SOUTH);
                BlockShower.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_WEST);
                break;
            }
            case WEST: {
                BlockShower.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_SOUTH);
                BlockShower.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_WEST);
                BlockShower.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_NORTH);
                break;
            }
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return new ItemStack(FurnitureBlocks.shower_bottom).func_77973_b();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(FurnitureBlocks.shower_bottom);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }
}

