/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.blocks;

import com.mrcrayfish.furniture.blocks.BlockFurnitureTile;
import com.mrcrayfish.furniture.init.FurnitureBlocks;
import com.mrcrayfish.furniture.init.FurnitureSounds;
import com.mrcrayfish.furniture.network.PacketHandler;
import com.mrcrayfish.furniture.network.message.MessageFillBath;
import com.mrcrayfish.furniture.tileentity.TileEntityBath;
import com.mrcrayfish.furniture.util.CollisionHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class BlockBath
extends BlockFurnitureTile {
    public static final PropertyInteger WATER_LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)16);
    private static final AxisAlignedBB BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    private static final AxisAlignedBB SIDE_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.125, 0.0, 1.0, 0.9, 0.125);
    private static final AxisAlignedBB SIDE_EAST = CollisionHelper.getBlockBounds(EnumFacing.EAST, 0.0, 0.125, 0.0, 1.0, 0.9, 0.125);
    private static final AxisAlignedBB SIDE_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.SOUTH, 0.0, 0.125, 0.0, 1.0, 0.9, 0.125);
    private static final AxisAlignedBB SIDE_WEST = CollisionHelper.getBlockBounds(EnumFacing.WEST, 0.0, 0.125, 0.0, 1.0, 0.9, 0.125);
    private static final AxisAlignedBB HEAD_NORTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.125, 0.125, 0.125, 0.9, 0.875);
    private static final AxisAlignedBB HEAD_EAST = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.125, 0.125, 0.125, 0.9, 0.875);
    private static final AxisAlignedBB HEAD_SOUTH = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.125, 0.125, 0.125, 0.9, 0.875);
    private static final AxisAlignedBB HEAD_WEST = CollisionHelper.getBlockBounds(EnumFacing.NORTH, 0.0, 0.125, 0.125, 0.125, 0.9, 0.875);
    private static final AxisAlignedBB[] HEADS = new AxisAlignedBB[]{HEAD_SOUTH, HEAD_WEST, HEAD_NORTH, HEAD_WEST};
    private static final AxisAlignedBB[] TAILS = new AxisAlignedBB[]{SIDE_SOUTH, SIDE_WEST, SIDE_NORTH, SIDE_WEST};

    public BlockBath(Material material, boolean top) {
        super(material);
        this.func_149711_c(1.0f);
        this.func_149672_a(SoundType.field_185851_d);
        if (top) {
            this.func_149647_a(null);
        }
    }

    @Override
    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        return state.func_177226_a((IProperty)WATER_LEVEL, (Comparable)Integer.valueOf(0));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_175656_a(pos.func_177972_a(placer.func_174811_aO()), FurnitureBlocks.bath_2.func_176223_P().func_177226_a((IProperty)FACING, state.func_177229_b((IProperty)FACING)).func_177226_a((IProperty)WATER_LEVEL, state.func_177229_b((IProperty)WATER_LEVEL)));
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB bounds, List<AxisAlignedBB> list, Entity collidingEntity) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (facing.func_176736_b() % 2 == 0) {
            BlockBath.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_NORTH);
            BlockBath.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_SOUTH);
        } else {
            BlockBath.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_EAST);
            BlockBath.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)SIDE_WEST);
        }
        if (this == FurnitureBlocks.bath_1) {
            BlockBath.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)HEADS[facing.func_176736_b()]);
        } else {
            BlockBath.func_185492_a((BlockPos)pos, (AxisAlignedBB)bounds, list, (AxisAlignedBB)TAILS[facing.func_176736_b()]);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            BlockPos otherBathPos = null;
            otherBathPos = this == FurnitureBlocks.bath_1 ? pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)) : pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d());
            TileEntity tile_entity_1 = worldIn.func_175625_s(pos);
            TileEntity tile_entity_2 = worldIn.func_175625_s(otherBathPos);
            if (tile_entity_1 instanceof TileEntityBath && tile_entity_2 instanceof TileEntityBath) {
                TileEntityBath tileEntityBath = (TileEntityBath)tile_entity_1;
                TileEntityBath tileEntityBath2 = (TileEntityBath)tile_entity_2;
                if (heldItem != null) {
                    if (heldItem.func_77973_b() == Items.field_151133_ar) {
                        if (tileEntityBath.hasWater()) {
                            if (!playerIn.field_71075_bZ.field_75098_d) {
                                if (heldItem.field_77994_a > 1) {
                                    if (playerIn.field_71071_by.func_70441_a(new ItemStack(Items.field_151131_as))) {
                                        --heldItem.field_77994_a;
                                    }
                                } else {
                                    playerIn.func_184611_a(hand, new ItemStack(Items.field_151131_as));
                                }
                            }
                            tileEntityBath.removeWaterLevel();
                            tileEntityBath2.removeWaterLevel();
                            worldIn.func_175666_e(pos, (Block)this);
                        }
                    } else if (heldItem.func_77973_b() == Items.field_151131_as) {
                        if (!tileEntityBath.isFull()) {
                            tileEntityBath.addWaterLevel();
                            tileEntityBath2.addWaterLevel();
                            if (!playerIn.field_71075_bZ.field_75098_d) {
                                playerIn.func_184611_a(hand, new ItemStack(Items.field_151133_ar));
                            }
                            worldIn.func_175666_e(pos, (Block)this);
                        }
                    } else if (heldItem.func_77973_b() == Items.field_151069_bo) {
                        if (tileEntityBath.hasWater()) {
                            if (!playerIn.field_71075_bZ.field_75098_d) {
                                if (heldItem.field_77994_a > 1) {
                                    if (playerIn.field_71071_by.func_70441_a(new ItemStack((Item)Items.field_151068_bn, 1, 0))) {
                                        --heldItem.field_77994_a;
                                    }
                                } else {
                                    playerIn.func_184611_a(hand, new ItemStack((Item)Items.field_151068_bn, 1, 0));
                                }
                            }
                            tileEntityBath.removeWaterLevel();
                            tileEntityBath2.removeWaterLevel();
                            worldIn.func_175666_e(pos, (Block)this);
                        }
                    } else if (heldItem.func_77973_b() == Items.field_151068_bn && heldItem.func_77952_i() == 0) {
                        if (!tileEntityBath.isFull()) {
                            tileEntityBath.addWaterLevel();
                            tileEntityBath2.addWaterLevel();
                            if (!playerIn.field_71075_bZ.field_75098_d) {
                                playerIn.func_184611_a(hand, new ItemStack(Items.field_151069_bo));
                            }
                            worldIn.func_175666_e(pos, (Block)this);
                        }
                    } else if (this == FurnitureBlocks.bath_2) {
                        if (this.hasWaterSource(worldIn, pos)) {
                            if (!tileEntityBath.isFull()) {
                                tileEntityBath.addWaterLevel();
                                tileEntityBath2.addWaterLevel();
                                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, FurnitureSounds.tap, SoundCategory.BLOCKS, 0.75f, 0.8f, true);
                                worldIn.func_175698_g(pos.func_177982_a(0, -2, 0));
                                worldIn.func_175666_e(pos, (Block)this);
                            }
                        } else {
                            playerIn.func_146105_b((ITextComponent)new TextComponentString("You need to have a water source under the block the bath head is on to fill it. Alternatively you can use a water bucket to fill it."));
                        }
                    }
                } else if (this == FurnitureBlocks.bath_2) {
                    if (this.hasWaterSource(worldIn, pos)) {
                        if (!tileEntityBath.isFull()) {
                            tileEntityBath.addWaterLevel();
                            tileEntityBath2.addWaterLevel();
                            worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, FurnitureSounds.tap, SoundCategory.BLOCKS, 0.75f, 0.8f, true);
                            worldIn.func_175698_g(pos.func_177982_a(0, -2, 0));
                            worldIn.func_175666_e(pos, (Block)this);
                        }
                    } else {
                        playerIn.func_146105_b((ITextComponent)new TextComponentString("You need to have a water source under the block the bath head is on to fill it. Alternatively you can use a water bucket to fill it."));
                    }
                }
                PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageFillBath(tileEntityBath.getWaterLevel(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), otherBathPos.func_177958_n(), otherBathPos.func_177956_o(), otherBathPos.func_177952_p()), new NetworkRegistry.TargetPoint(playerIn.field_71093_bK, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 128.0));
                worldIn.func_175704_b(pos, pos);
                worldIn.func_175704_b(otherBathPos, otherBathPos);
            }
        }
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (this == FurnitureBlocks.bath_1) {
            worldIn.func_175655_b(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)FACING)), false);
        } else {
            worldIn.func_175655_b(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d()), false);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityBath();
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return new ItemStack(FurnitureBlocks.bath_1).func_77973_b();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(FurnitureBlocks.bath_1);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityBath bath = (TileEntityBath)world.func_175625_s(pos);
        return state.func_177226_a((IProperty)WATER_LEVEL, (Comparable)Integer.valueOf(bath.getWaterLevel()));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, WATER_LEVEL});
    }

    public static boolean canPlaceBath(World world, BlockPos pos, EnumFacing facing) {
        return world.func_175623_d(pos) && world.func_175623_d(pos.func_177967_a(facing, 1));
    }

    public boolean hasWaterSource(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177982_a(0, -2, 0)) == Blocks.field_150355_j.func_176223_P();
    }

    @Override
    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityBath bath = (TileEntityBath)world.func_175625_s(pos);
        return bath.getWaterLevel();
    }
}

