/*
 * Decompiled with CFR 0.152.
 */
package furgl.babyMobs.util;

import furgl.babyMobs.common.BabyMobs;
import furgl.babyMobs.common.event.OnUpdateEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntitySpawner {
    private boolean isRunning = false;
    private int totalDelay;
    private Class entityClass;
    private Entity entity;
    private Particle entityFX;
    protected World world;
    protected Vec3d origin;
    protected int numEntities;
    protected double x;
    protected double y;
    protected double z;
    protected Random rand = new Random();
    protected String shape = "none";
    protected double radius;
    protected double length;
    protected int entityIterator;
    protected int heightIterator;
    protected float pitch;
    protected float yaw;
    protected String movement = "none";
    protected double movementSpeed;
    protected Entity target;
    protected boolean homing;
    protected int delay = 0;
    protected double randVar = 0.0;
    protected int numRuns = 1;
    protected int consecRuns = 1;
    protected int updateTime = 10;

    public EntitySpawner(Class entityClass, World world, Vec3d origin, int numEntities) {
        this.entityClass = entityClass;
        this.world = world;
        this.origin = origin;
        this.numEntities = numEntities;
        this.x = origin.field_72450_a;
        this.y = origin.field_72448_b;
        this.z = origin.field_72449_c;
    }

    public void setShapeCircle(double radius) {
        this.radius = radius;
        this.shape = "circle";
    }

    public void setShapeSphere(double radius) {
        this.radius = radius;
        this.shape = "sphere";
    }

    public void setShapeLine(double length, float pitch, float yaw) {
        this.length = length;
        this.pitch = pitch;
        this.yaw = yaw;
        this.shape = "line";
    }

    public void setMovementFollowShape(double movementSpeed) {
        this.movementSpeed = movementSpeed;
        this.movement = "followShape";
    }

    public void setMovementInOut(double movementSpeed) {
        this.movementSpeed = movementSpeed;
        this.movement = "in/out";
    }

    public void setMovementRandom(double movementSpeed) {
        this.movementSpeed = movementSpeed;
        this.movement = "random";
    }

    public void setMovementTarget(double movementSpeed, Entity target, boolean homing) {
        this.movementSpeed = movementSpeed;
        this.target = target;
        this.homing = homing;
        this.movement = "target";
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public void setRandVar(double randVar) {
        this.randVar = randVar;
    }

    public void setNumRuns(int numRuns) {
        this.numRuns = numRuns;
    }

    public void setConsecRuns(int consecRuns) {
        this.consecRuns = consecRuns;
    }

    public void setUpdateTick(int updateTime) {
        this.updateTime = updateTime;
    }

    public void run() {
        if (this.entityClass.getSuperclass() == BabyMobs.proxy.getParticleClass() && this.world.field_72995_K) {
            OnUpdateEvent.addOnClientUpdate(this);
        } else if (this.entityClass.getSuperclass() != BabyMobs.proxy.getParticleClass() && !this.world.field_72995_K) {
            OnUpdateEvent.addOnServerUpdate(this);
        }
        this.isRunning = true;
        this.totalDelay = this.delay * this.numEntities * this.consecRuns;
        this.onUpdate();
    }

    public void onUpdate() {
        if (this.isRunning) {
            for (int runIterator = 0; runIterator < this.numRuns; ++runIterator) {
                for (int entityIterator = 0; entityIterator < this.numEntities * this.consecRuns; ++entityIterator) {
                    if (this.totalDelay - this.delay * entityIterator != 0) continue;
                    switch (this.shape) {
                        case "circle": {
                            this.x = this.radius * (double)MathHelper.func_76134_b((float)((float)(Math.PI * 2 * (double)entityIterator / (double)this.numEntities))) + ((double)this.rand.nextInt(20) - 10.0) / 10.0 * this.randVar + this.origin.field_72450_a;
                            this.y = ((double)this.rand.nextInt(20) - 10.0) / 10.0 * this.randVar + this.origin.field_72448_b;
                            this.z = this.radius * (double)MathHelper.func_76126_a((float)((float)(Math.PI * 2 * (double)entityIterator / (double)this.numEntities))) + ((double)this.rand.nextInt(20) - 10.0) / 10.0 * this.randVar + this.origin.field_72449_c;
                            break;
                        }
                        case "sphere": {
                            for (int heightIterator = 0; heightIterator < this.numEntities; ++heightIterator) {
                                this.x = (double)MathHelper.func_76134_b((float)((float)(Math.PI * 2 * (double)heightIterator / (double)this.numEntities))) * this.radius * (double)MathHelper.func_76134_b((float)((float)(Math.PI * 2 * (double)entityIterator / (double)this.numEntities))) + ((double)this.rand.nextInt(20) - 10.0) / 10.0 * this.randVar + this.origin.field_72450_a;
                                this.y = this.radius * (double)MathHelper.func_76126_a((float)((float)(Math.PI * 2 * (double)heightIterator / (double)this.numEntities))) + ((double)this.rand.nextInt(20) - 10.0) / 10.0 * this.randVar + this.origin.field_72448_b;
                                this.z = (double)MathHelper.func_76134_b((float)((float)(Math.PI * 2 * (double)heightIterator / (double)this.numEntities))) * this.radius * (double)MathHelper.func_76126_a((float)((float)(Math.PI * 2 * (double)entityIterator / (double)this.numEntities))) + ((double)this.rand.nextInt(20) - 10.0) / 10.0 * this.randVar + this.origin.field_72449_c;
                                this.spawnEntity(heightIterator, entityIterator);
                            }
                            break;
                        }
                        case "line": {
                            int entityIterator1;
                            for (entityIterator1 = entityIterator; entityIterator1 >= this.numEntities; entityIterator1 -= this.numEntities) {
                            }
                            entityIterator1 = Math.abs(this.numEntities - entityIterator1);
                            this.x = this.origin.field_72450_a + ((double)this.rand.nextInt(20) - 10.0) / 10.0 * this.randVar * (double)entityIterator1 / 5.0 + this.length * (double)entityIterator1 / (double)this.numEntities * Math.cos((double)this.yaw * Math.PI / 180.0 + 1.5707963267948966);
                            this.y = this.origin.field_72448_b + ((double)this.rand.nextInt(20) - 10.0) / 10.0 * this.randVar * (double)entityIterator1 / 5.0 - this.length * (double)entityIterator1 / (double)this.numEntities * Math.sin((double)this.pitch * Math.PI / 180.0);
                            this.z = this.origin.field_72449_c + ((double)this.rand.nextInt(20) - 10.0) / 10.0 * this.randVar * (double)entityIterator1 / 5.0 + this.length * (double)entityIterator1 / (double)this.numEntities * Math.sin((double)this.yaw * Math.PI / 180.0 + 1.5707963267948966);
                            break;
                        }
                        default: {
                            this.x = this.origin.field_72450_a;
                            this.y = this.origin.field_72448_b;
                            this.z = this.origin.field_72449_c;
                        }
                    }
                    if (this.shape.equals("sphere")) continue;
                    this.spawnEntity(this.heightIterator, entityIterator);
                }
            }
            --this.totalDelay;
            if (this.totalDelay < 0) {
                this.isRunning = false;
                if (this.entityClass.getSuperclass() == BabyMobs.proxy.getParticleClass() && this.world.field_72995_K) {
                    OnUpdateEvent.removeOnClientUpdate(this);
                } else if (this.entityClass.getSuperclass() != BabyMobs.proxy.getParticleClass() && !this.world.field_72995_K) {
                    OnUpdateEvent.removeOnServerUpdate(this);
                }
            }
        }
    }

    public void spawnEntity(int heightIterator, int entityIterator) {
        this.heightIterator = heightIterator;
        this.entityIterator = entityIterator;
        if (this.entityClass.getSuperclass() == BabyMobs.proxy.getParticleClass() && this.world.field_72995_K) {
            BabyMobs.proxy.spawnEntitySpawner(this.entityClass, this.world, this.x, this.y, this.z, this, this.heightIterator, this.entityIterator);
        } else if (this.entityClass.getSuperclass() != BabyMobs.proxy.getParticleClass() && !this.world.field_72995_K) {
            try {
                Object object = this.entityClass.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE, EntitySpawner.class, Integer.TYPE, Integer.TYPE).newInstance(this.world, this.x, this.y, this.z, this, this.heightIterator, this.entityIterator);
                if (object instanceof Entity) {
                    this.entity = (Entity)object;
                    this.entity.func_70107_b(this.x, this.y, this.z);
                    this.world.func_72838_d(this.entity);
                } else {
                    this.entityFX = (Particle)object;
                    this.entityFX.func_187109_b(this.x, this.y, this.z);
                    Minecraft.func_71410_x().field_71452_i.func_78873_a(this.entityFX);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                System.out.println("ERROR: ENTITY " + this.entityClass + " MISSING SPAWNER CONSTRUCTOR");
                e.printStackTrace();
            }
        }
    }
}

