/*
 * Decompiled with CFR 0.152.
 */
package furgl.babyMobs.common;

import furgl.babyMobs.client.gui.achievements.Achievements;
import furgl.babyMobs.client.gui.creativeTab.BabyMobsCreativeTab;
import furgl.babyMobs.common.CommonProxy;
import furgl.babyMobs.common.block.ModBlocks;
import furgl.babyMobs.common.config.Config;
import furgl.babyMobs.common.entity.ModEntities;
import furgl.babyMobs.common.event.AttackEvent;
import furgl.babyMobs.common.event.BabyReplaceEvent;
import furgl.babyMobs.common.event.BlockPatternEvent;
import furgl.babyMobs.common.event.BreakSpeedEvent;
import furgl.babyMobs.common.event.ConfigChangeEvent;
import furgl.babyMobs.common.event.InteractHorseEvent;
import furgl.babyMobs.common.event.OnUpdateEvent;
import furgl.babyMobs.common.event.SetAttackTargetEvent;
import furgl.babyMobs.common.event.SpawnDragonEvent;
import furgl.babyMobs.common.event.SummonCommandEvent;
import furgl.babyMobs.common.event.ZombieTrapEvent;
import furgl.babyMobs.common.item.ModItems;
import furgl.babyMobs.common.item.spawnEgg.ItemBabySpawnEgg;
import furgl.babyMobs.common.packet.PacketMotionY;
import furgl.babyMobs.common.packet.PacketVolatileLevitation;
import furgl.babyMobs.common.potion.ModPotions;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="babymobs", name="Baby Mobs", version="1.5.4", guiFactory="furgl.babyMobs.client.gui.config.BabyMobsGuiFactory", acceptedMinecraftVersions="[1.10.2]")
public class BabyMobs {
    public static final String MODID = "babymobs";
    public static final String MODNAME = "Baby Mobs";
    public static final String VERSION = "1.5.4";
    @Mod.Instance(value="babymobs")
    public static BabyMobs instance;
    @SidedProxy(clientSide="furgl.babyMobs.client.ClientProxy", serverSide="furgl.babyMobs.common.CommonProxy")
    public static CommonProxy proxy;
    public static final BabyMobsCreativeTab tab;
    public static SimpleNetworkWrapper network;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        network = NetworkRegistry.INSTANCE.newSimpleChannel("babyMobsChannel");
        this.registerPackets();
        Config.init(event.getSuggestedConfigurationFile());
        ModEntities.registerEntities();
        ModItems.init();
        ModBlocks.init();
        Achievements.init();
        ModPotions.preInit();
        this.registerDispenserBehaviors();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerEventListeners();
        this.registerCraftingRecipes();
        proxy.registerAchievements();
        proxy.registerRenders();
        ModPotions.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    public void registerEventListeners() {
        MinecraftForge.EVENT_BUS.register((Object)new BabyReplaceEvent());
        MinecraftForge.EVENT_BUS.register((Object)new SpawnDragonEvent());
        MinecraftForge.EVENT_BUS.register((Object)new BlockPatternEvent());
        MinecraftForge.EVENT_BUS.register((Object)new BreakSpeedEvent());
        MinecraftForge.EVENT_BUS.register((Object)new SummonCommandEvent());
        MinecraftForge.EVENT_BUS.register((Object)new ConfigChangeEvent());
        MinecraftForge.EVENT_BUS.register((Object)new OnUpdateEvent());
        MinecraftForge.EVENT_BUS.register((Object)new AttackEvent());
        MinecraftForge.EVENT_BUS.register((Object)new SetAttackTargetEvent());
        MinecraftForge.EVENT_BUS.register((Object)new ZombieTrapEvent());
        MinecraftForge.EVENT_BUS.register((Object)new InteractHorseEvent());
    }

    private void registerPackets() {
        int id = 0;
        network.registerMessage(PacketVolatileLevitation.Handler.class, PacketVolatileLevitation.class, id++, Side.CLIENT);
        network.registerMessage(PacketMotionY.Handler.class, PacketMotionY.class, id++, Side.CLIENT);
    }

    private void registerCraftingRecipes() {
        GameRegistry.addRecipe((ItemStack)new ItemStack(ModItems.golden_bread), (Object[])new Object[]{"NNN", "NBN", "NNN", Character.valueOf('N'), Items.field_151074_bl, Character.valueOf('B'), Items.field_151025_P});
    }

    public void registerDispenserBehaviors() {
        for (ItemBabySpawnEgg egg : ModItems.eggs) {
            BlockDispenser.field_149943_a.func_82595_a((Object)egg, (Object)new BehaviorDefaultDispenseItem(){

                public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                    EnumFacing enumfacing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
                    double d0 = source.func_82615_a() + (double)enumfacing.func_82601_c();
                    double d1 = (float)source.func_180699_d().func_177956_o() + 0.2f;
                    double d2 = source.func_82616_c() + (double)enumfacing.func_82599_e();
                    Entity entity = ItemBabySpawnEgg.spawnCreature(source.func_82618_k(), ((ItemBabySpawnEgg)stack.func_77973_b()).entityName, d0, d1, d2);
                    if (entity instanceof EntityLivingBase && stack.func_82837_s()) {
                        ((EntityLiving)entity).func_96094_a(stack.func_82833_r());
                    }
                    stack.func_77979_a(1);
                    return stack;
                }
            });
        }
    }

    static {
        tab = new BabyMobsCreativeTab("tabBabyMobs");
    }
}

