/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.util;

import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.util.ErrorUtil;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandResultStats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.CommandEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class CommandUtil {
    public static String[] getGiveCommandParameters(EntityPlayer sender, ItemStack itemStack, int amount) {
        String senderName = sender.func_70005_c_();
        Item item = itemStack.func_77973_b();
        ResourceLocation itemResourceLocation = item.getRegistryName();
        if (itemResourceLocation == null) {
            String stackInfo = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("item.getRegistryName() returned null for: " + stackInfo);
        }
        ArrayList<String> commandStrings = new ArrayList<String>();
        commandStrings.add(senderName);
        commandStrings.add(itemResourceLocation.toString());
        commandStrings.add(String.valueOf(amount));
        commandStrings.add(String.valueOf(itemStack.func_77960_j()));
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            commandStrings.add(tagCompound.toString());
        }
        return commandStrings.toArray(new String[commandStrings.size()]);
    }

    public static void writeChatMessage(EntityPlayer player, String translationKey, TextFormatting color) {
        TextComponentTranslation component = new TextComponentTranslation(translationKey, new Object[0]);
        component.func_150256_b().func_150238_a(color);
        player.func_145747_a((ITextComponent)component);
    }

    public static boolean hasPermission(EntityPlayerMP sender, ItemStack itemStack) {
        if (sender.func_184812_l_()) {
            return true;
        }
        MinecraftServer minecraftServer = sender.field_71133_b;
        ICommand giveCommand = CommandUtil.getGiveCommand(sender);
        if (giveCommand != null && giveCommand.func_184882_a(minecraftServer, (ICommandSender)sender)) {
            String[] commandParameters = CommandUtil.getGiveCommandParameters((EntityPlayer)sender, itemStack, itemStack.field_77994_a);
            CommandEvent event = new CommandEvent(giveCommand, (ICommandSender)sender, commandParameters);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                Throwable exception = event.getException();
                if (exception != null) {
                    Throwables.propagateIfPossible((Throwable)exception);
                }
                return false;
            }
            return true;
        }
        return sender.func_70003_b(minecraftServer.func_110455_j(), "give");
    }

    public static void executeGive(EntityPlayerMP sender, ItemStack itemStack) {
        int count = itemStack.field_77994_a;
        boolean addedToInventory = sender.field_71071_by.func_70441_a(itemStack);
        if (addedToInventory) {
            sender.field_70170_p.func_184148_a(null, sender.field_70165_t, sender.field_70163_u, sender.field_70161_v, SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((sender.func_70681_au().nextFloat() - sender.func_70681_au().nextFloat()) * 0.7f + 1.0f) * 2.0f);
            sender.field_71069_bz.func_75142_b();
        }
        if (addedToInventory && itemStack.field_77994_a <= 0) {
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_ITEMS, count);
        } else {
            sender.func_174794_a(CommandResultStats.Type.AFFECTED_ITEMS, count - itemStack.field_77994_a);
            EntityItem entityitem = sender.func_71019_a(itemStack, false);
            if (entityitem != null) {
                entityitem.func_174868_q();
                entityitem.func_145797_a(sender.func_70005_c_());
            }
        }
        ICommand giveCommand = CommandUtil.getGiveCommand(sender);
        if (giveCommand != null) {
            itemStack.field_77994_a = 1;
            CommandBase.func_152373_a((ICommandSender)sender, (ICommand)giveCommand, (String)"commands.give.success", (Object[])new Object[]{itemStack.func_151000_E(), count, sender.func_70005_c_()});
        }
    }

    @Nullable
    private static ICommand getGiveCommand(EntityPlayerMP sender) {
        MinecraftServer minecraftServer = sender.field_71133_b;
        ICommandManager commandManager = minecraftServer.func_71187_D();
        Map commands = commandManager.func_71555_a();
        return (ICommand)commands.get("give");
    }
}

