/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.brewing;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mezz.jei.Internal;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.config.Config;
import mezz.jei.plugins.vanilla.brewing.BrewingRecipeWrapper;
import mezz.jei.util.Java6Helper;
import mezz.jei.util.Log;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionHelper;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.brewing.AbstractBrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.brewing.VanillaBrewingRecipe;

public class BrewingRecipeMaker {
    private final Set<Class> unhandledRecipeClasses = new HashSet<Class>();
    private final Map<String, Integer> brewingSteps = new HashMap<String, Integer>();
    private final IIngredientRegistry ingredientRegistry;
    private final IIngredientHelper<ItemStack> itemStackHelper;

    public static List<BrewingRecipeWrapper> getBrewingRecipes(IIngredientRegistry ingredientRegistry) {
        BrewingRecipeMaker brewingRecipeMaker = new BrewingRecipeMaker(ingredientRegistry);
        return brewingRecipeMaker.getBrewingRecipes();
    }

    private BrewingRecipeMaker(IIngredientRegistry ingredientRegistry) {
        this.ingredientRegistry = ingredientRegistry;
        this.itemStackHelper = ingredientRegistry.getIngredientHelper(ItemStack.class);
    }

    private List<BrewingRecipeWrapper> getBrewingRecipes() {
        this.unhandledRecipeClasses.clear();
        this.brewingSteps.clear();
        HashSet<BrewingRecipeWrapper> recipes = new HashSet<BrewingRecipeWrapper>();
        this.addVanillaBrewingRecipes(recipes);
        this.addModdedBrewingRecipes(recipes);
        ArrayList<BrewingRecipeWrapper> recipeList = new ArrayList<BrewingRecipeWrapper>(recipes);
        Collections.sort(recipeList, new Comparator<BrewingRecipeWrapper>(){

            @Override
            public int compare(BrewingRecipeWrapper o1, BrewingRecipeWrapper o2) {
                return Java6Helper.compare(o1.getBrewingSteps(), o2.getBrewingSteps());
            }
        });
        return recipeList;
    }

    private void addVanillaBrewingRecipes(Collection<BrewingRecipeWrapper> recipes) {
        boolean foundNewPotions;
        ImmutableList<ItemStack> potionIngredients = this.ingredientRegistry.getPotionIngredients();
        ArrayList<ItemStack> knownPotions = new ArrayList<ItemStack>();
        ItemStack waterBottle = PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_151068_bn), (PotionType)PotionTypes.field_185230_b);
        knownPotions.add(waterBottle);
        int brewingStep = 1;
        do {
            List<ItemStack> newPotions;
            foundNewPotions = !(newPotions = this.getNewPotions(brewingStep, knownPotions, potionIngredients, recipes)).isEmpty();
            knownPotions.addAll(newPotions);
            if (++brewingStep <= 100) continue;
            Log.error("Calculation of vanilla brewing recipes is broken, aborting after 100 brewing steps.", new Object[0]);
            return;
        } while (foundNewPotions);
    }

    private List<ItemStack> getNewPotions(int brewingStep, List<ItemStack> knownPotions, ImmutableList<ItemStack> potionIngredients, Collection<BrewingRecipeWrapper> recipes) {
        ArrayList<ItemStack> newPotions = new ArrayList<ItemStack>();
        for (ItemStack potionInput : knownPotions) {
            for (ItemStack potionIngredient : potionIngredients) {
                BrewingRecipeWrapper recipe;
                int outputId;
                PotionType potionInputType;
                int inputId;
                PotionType potionOutputType;
                ItemStack potionOutput = PotionHelper.func_185212_d((ItemStack)potionIngredient, (ItemStack)potionInput.func_77946_l());
                if (potionOutput == null || potionInput.func_77973_b() == potionOutput.func_77973_b() && ((potionOutputType = PotionUtils.func_185191_c((ItemStack)potionOutput)) == PotionTypes.field_185230_b || (inputId = PotionType.func_185171_a((PotionType)(potionInputType = PotionUtils.func_185191_c((ItemStack)potionInput)))) == (outputId = PotionType.func_185171_a((PotionType)potionOutputType))) || recipes.contains(recipe = new BrewingRecipeWrapper(potionIngredient, potionInput.func_77946_l(), potionOutput, brewingStep))) continue;
                recipes.add(recipe);
                newPotions.add(potionOutput);
                String potionUid = this.itemStackHelper.getUniqueId(potionOutput);
                this.brewingSteps.put(potionUid, brewingStep);
            }
        }
        return newPotions;
    }

    private void addModdedBrewingRecipes(Collection<BrewingRecipeWrapper> recipes) {
        Collection<Object> brewingRecipes = BrewingRecipeRegistry.getRecipes();
        Collection<IBrewingRecipe> unknownSteps = this.addModdedBrewingRecipes((Collection<IBrewingRecipe>)brewingRecipes, recipes);
        while (unknownSteps.size() > 0) {
            brewingRecipes = unknownSteps;
            if ((unknownSteps = this.addModdedBrewingRecipes((Collection<IBrewingRecipe>)brewingRecipes, recipes)).size() != brewingRecipes.size()) continue;
            return;
        }
    }

    private Collection<IBrewingRecipe> addModdedBrewingRecipes(Collection<IBrewingRecipe> brewingRecipes, Collection<BrewingRecipeWrapper> recipes) {
        ArrayList<IBrewingRecipe> unknownSteps = new ArrayList<IBrewingRecipe>();
        for (IBrewingRecipe iBrewingRecipe : brewingRecipes) {
            Class<?> recipeClass;
            if (iBrewingRecipe instanceof AbstractBrewingRecipe) {
                AbstractBrewingRecipe brewingRecipe = (AbstractBrewingRecipe)iBrewingRecipe;
                List<ItemStack> ingredientList = Internal.getStackHelper().toItemStackList(brewingRecipe.getIngredient());
                if (ingredientList.isEmpty()) continue;
                ItemStack input = brewingRecipe.getInput();
                ItemStack output = brewingRecipe.getOutput();
                String potionInputUid = Internal.getStackHelper().getUniqueIdentifierForStack(input);
                String potionOutputUid = Internal.getStackHelper().getUniqueIdentifierForStack(output);
                Integer steps = this.brewingSteps.get(potionInputUid);
                if (steps == null) {
                    unknownSteps.add((IBrewingRecipe)brewingRecipe);
                    continue;
                }
                int outputBrewingStep = steps + 1;
                this.brewingSteps.put(potionOutputUid, outputBrewingStep);
                BrewingRecipeWrapper recipe = new BrewingRecipeWrapper(ingredientList, input, output, outputBrewingStep);
                recipes.add(recipe);
                continue;
            }
            if (iBrewingRecipe instanceof VanillaBrewingRecipe || this.unhandledRecipeClasses.contains(recipeClass = iBrewingRecipe.getClass())) continue;
            this.unhandledRecipeClasses.add(recipeClass);
            if (!Config.isDebugModeEnabled()) continue;
            Log.debug("Can't handle brewing recipe class: {}", recipeClass);
        }
        return unknownSteps;
    }
}

