/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.jei.description;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import mezz.jei.util.MathUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class ItemDescriptionRecipe
extends BlankRecipeWrapper {
    private static final int lineSpacing = 2;
    private final List<String> description;
    private final List<ItemStack> itemStacks;
    private final IDrawable slotDrawable;

    public static List<ItemDescriptionRecipe> create(IGuiHelper guiHelper, List<ItemStack> itemStacks, String ... descriptionKeys) {
        ArrayList<ItemDescriptionRecipe> recipes = new ArrayList<ItemDescriptionRecipe>();
        List<String> descriptionLines = ItemDescriptionRecipe.translateDescriptionLines(descriptionKeys);
        descriptionLines = ItemDescriptionRecipe.expandNewlines(descriptionLines);
        descriptionLines = ItemDescriptionRecipe.wrapDescriptionLines(descriptionLines);
        int lineCount = descriptionLines.size();
        Minecraft minecraft = Minecraft.func_71410_x();
        int maxLinesPerPage = 105 / (minecraft.field_71466_p.field_78288_b + 2);
        int pageCount = MathUtil.divideCeil(lineCount, maxLinesPerPage);
        for (int i = 0; i < pageCount; ++i) {
            int startLine = i * maxLinesPerPage;
            int endLine = Math.min((i + 1) * maxLinesPerPage, lineCount);
            List<String> description = descriptionLines.subList(startLine, endLine);
            ItemDescriptionRecipe recipe = new ItemDescriptionRecipe(guiHelper, itemStacks, description);
            recipes.add(recipe);
        }
        return recipes;
    }

    private static List<String> translateDescriptionLines(String ... descriptionKeys) {
        ArrayList<String> descriptionLines = new ArrayList<String>();
        for (String descriptionKey : descriptionKeys) {
            String translatedLine = Translator.translateToLocal(descriptionKey);
            descriptionLines.add(translatedLine);
        }
        return descriptionLines;
    }

    private static List<String> expandNewlines(List<String> descriptionLines) {
        ArrayList<String> descriptionLinesExpanded = new ArrayList<String>();
        for (String descriptionLine : descriptionLines) {
            String[] descriptionLineExpanded = descriptionLine.split("\\\\n");
            Collections.addAll(descriptionLinesExpanded, descriptionLineExpanded);
        }
        return descriptionLinesExpanded;
    }

    private static List<String> wrapDescriptionLines(List<String> descriptionLines) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ArrayList<String> descriptionLinesWrapped = new ArrayList<String>();
        for (String descriptionLine : descriptionLines) {
            List textLines = minecraft.field_71466_p.func_78271_c(descriptionLine, 160);
            descriptionLinesWrapped.addAll(textLines);
        }
        return descriptionLinesWrapped;
    }

    private ItemDescriptionRecipe(IGuiHelper guiHelper, List<ItemStack> itemStacks, List<String> description) {
        this.description = description;
        this.itemStacks = itemStacks;
        this.slotDrawable = guiHelper.getSlotDrawable();
    }

    @Override
    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, Collections.singletonList(this.itemStacks));
        ingredients.setOutputs(ItemStack.class, this.itemStacks);
    }

    @Override
    public List<ItemStack> getInputs() {
        return this.itemStacks;
    }

    @Override
    public List<ItemStack> getOutputs() {
        return this.itemStacks;
    }

    @Override
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int xPos = (recipeWidth - this.slotDrawable.getWidth()) / 2;
        int yPos = 0;
        this.slotDrawable.draw(minecraft, xPos, yPos);
        xPos = 0;
        yPos += this.slotDrawable.getHeight() + 4;
        for (String descriptionLine : this.description) {
            minecraft.field_71466_p.func_78276_b(descriptionLine, xPos, yPos, Color.black.getRGB());
            yPos += minecraft.field_71466_p.field_78288_b + 2;
        }
    }

    public List<String> getDescription() {
        return this.description;
    }
}

