/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.runtime.providers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import minetweaker.runtime.IScriptIterator;
import minetweaker.runtime.IScriptProvider;

public class ScriptProviderCustom
implements IScriptProvider {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final String moduleName;
    private final List<CustomScript> scripts;

    public ScriptProviderCustom(String moduleName) {
        this.moduleName = moduleName;
        this.scripts = new ArrayList<CustomScript>();
    }

    public void add(String name, byte[] content) {
        this.scripts.add(new CustomScript(name, content));
    }

    public void add(String name, String content) {
        this.add(name, content.getBytes(UTF8));
    }

    @Override
    public Iterator<IScriptIterator> getScripts() {
        return Collections.singleton(new CustomScriptIterator()).iterator();
    }

    private class CustomScriptIterator
    implements IScriptIterator {
        private final Iterator<CustomScript> iterator;
        private CustomScript current;

        private CustomScriptIterator() {
            this.iterator = ScriptProviderCustom.this.scripts.iterator();
        }

        @Override
        public String getGroupName() {
            return ScriptProviderCustom.this.moduleName;
        }

        @Override
        public boolean next() {
            if (this.iterator.hasNext()) {
                this.current = this.iterator.next();
                return true;
            }
            return false;
        }

        @Override
        public String getName() {
            return this.current.name;
        }

        @Override
        public InputStream open() throws IOException {
            return new ByteArrayInputStream(this.current.content);
        }
    }

    private class CustomScript {
        private final String name;
        private final byte[] content;

        public CustomScript(String name, byte[] content) {
            this.name = name;
            this.content = content;
        }
    }
}

