/*
 * Decompiled with CFR 0.152.
 */
package minetweaker.runtime.providers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import minetweaker.runtime.IScriptIterator;

public class ScriptIteratorDirectory
implements IScriptIterator {
    private final File directory;
    private Iterator<File> contents;
    private File current;

    public ScriptIteratorDirectory(File directory) {
        this.directory = directory;
        File scriptDir = new File(directory, "scripts");
        ArrayList<File> contentsList = new ArrayList<File>();
        if (scriptDir.exists()) {
            ScriptIteratorDirectory.iterate(scriptDir, contentsList);
        }
        this.contents = contentsList.iterator();
    }

    private static void iterate(File directory, List<File> contentsList) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                ScriptIteratorDirectory.iterate(file, contentsList);
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".zs")) continue;
            contentsList.add(file);
        }
    }

    @Override
    public String getGroupName() {
        return this.directory.getName();
    }

    @Override
    public boolean next() {
        if (this.contents.hasNext()) {
            this.current = this.contents.next();
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        if (this.current == null || this.directory == null) {
            return "zzNullzz";
        }
        return this.current.getAbsolutePath().substring(this.directory.getAbsolutePath().length());
    }

    @Override
    public InputStream open() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.current));
    }
}

