/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.lwjgl.input.Keyboard;

public class Constants {
    public static final Ordering<String> CASE_INSENSITIVE_NULL_SAFE_ORDER = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).nullsLast();
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Joiner path = Joiner.on((String)File.separator).useForNull("");
    private static final String END = null;
    public static String JOURNEYMAP_DIR = "journeymap";
    public static String CONFIG_DIR_LEGACY = path.join((Object)JOURNEYMAP_DIR, (Object)"config", new Object[0]);
    public static String CONFIG_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"config", new Object[]{Journeymap.JM_VERSION.toMajorMinorString(), END});
    public static String DATA_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"data", new Object[0]);
    public static String SP_DATA_DIR = path.join((Object)DATA_DIR, (Object)WorldType.sp, new Object[]{END});
    public static String MP_DATA_DIR = path.join((Object)DATA_DIR, (Object)WorldType.mp, new Object[]{END});
    public static String RESOURCE_PACKS_DEFAULT = "Default";
    public static String CONTROL_KEYNAME_COMBO;
    public static String KEYBINDING_CATEGORY;
    public static KeyBinding KB_MAP;
    public static KeyBinding KB_MAP_ZOOMIN;
    public static KeyBinding KB_MAP_ZOOMOUT;
    public static KeyBinding KB_MAP_DAY;
    public static KeyBinding KB_MAP_NIGHT;
    public static KeyBinding KB_MINIMAP_PRESET;
    public static KeyBinding KB_WAYPOINT;
    private static String ICON_DIR;
    public static String ENTITY_ICON_DIR;
    public static String WAYPOINT_ICON_DIR;
    public static String THEME_ICON_DIR;

    public static List<KeyBinding> initKeybindings() {
        CONTROL_KEYNAME_COMBO = "Ctrl,";
        KEYBINDING_CATEGORY = Constants.getString("jm.common.hotkeys_keybinding_category", CONTROL_KEYNAME_COMBO);
        KB_MAP = new KeyBinding("key.journeymap.map_toggle", 36, KEYBINDING_CATEGORY);
        KB_MAP_ZOOMIN = new KeyBinding("key.journeymap.zoom_in", 13, KEYBINDING_CATEGORY);
        KB_MAP_ZOOMOUT = new KeyBinding("key.journeymap.zoom_out", 12, KEYBINDING_CATEGORY);
        KB_MAP_DAY = new KeyBinding("key.journeymap.minimap_type", 26, KEYBINDING_CATEGORY);
        KB_MAP_NIGHT = new KeyBinding("key.journeymap.minimap_type", 27, KEYBINDING_CATEGORY);
        KB_MINIMAP_PRESET = new KeyBinding("key.journeymap.minimap_preset", 43, KEYBINDING_CATEGORY);
        KB_WAYPOINT = new KeyBinding("key.journeymap.create_waypoint", 48, KEYBINDING_CATEGORY);
        return Arrays.asList(KB_MAP, KB_MAP_ZOOMIN, KB_MAP_ZOOMOUT, KB_MAP_DAY, KB_MAP_NIGHT, KB_MINIMAP_PRESET, KB_WAYPOINT);
    }

    public static Locale getLocale() {
        Locale locale = Locale.getDefault();
        try {
            String lang = FMLClientHandler.instance().getClient().func_135016_M().func_135041_c().func_135034_a();
            locale = new Locale(lang);
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't determine locale from game settings, defaulting to " + locale);
        }
        return locale;
    }

    public static String getString(String key) {
        if (FMLClientHandler.instance().getClient() == null) {
            return key;
        }
        try {
            String result = I18n.func_135052_a((String)key, (Object[])new Object[0]);
            if (result.equals(key)) {
                Journeymap.getLogger().warn("Message key not found: " + key);
            }
            return result;
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn(String.format("Message key '%s' threw exception: %s", key, t.getMessage()));
            return key;
        }
    }

    public static String getString(String key, Object ... params) {
        if (FMLClientHandler.instance().getClient() == null) {
            return String.format("%s (%s)", key, Joiner.on((String)",").join(params));
        }
        try {
            String result = I18n.func_135052_a((String)key, (Object[])params);
            if (result.equals(key)) {
                Journeymap.getLogger().warn("Message key not found: " + key);
            }
            return result;
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn(String.format("Message key '%s' threw exception: %s", key, t.getMessage()));
            return key;
        }
    }

    public static String getKeyName(KeyBinding keyBinding) {
        return Keyboard.getKeyName((int)keyBinding.func_151463_i());
    }

    public static boolean safeEqual(String first, String second) {
        int result = CASE_INSENSITIVE_NULL_SAFE_ORDER.compare((Object)first, (Object)second);
        if (result != 0) {
            return false;
        }
        return CASE_INSENSITIVE_NULL_SAFE_ORDER.compare((Object)first, (Object)second) == 0;
    }

    public static List<ResourcePackRepository.Entry> getResourcePacks() {
        ArrayList<ResourcePackRepository.Entry> entries = new ArrayList<ResourcePackRepository.Entry>();
        try {
            ResourcePackRepository resourcepackrepository = FMLClientHandler.instance().getClient().func_110438_M();
            entries.addAll(resourcepackrepository.func_110613_c());
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Can't get resource pack names: %s", LogFormatter.toString(t)));
        }
        return entries;
    }

    public static String getModNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            if (!Loader.isModLoaded((String)mod.getModId())) continue;
            list.add(String.format("%s:%s", mod.getName(), mod.getVersion()));
        }
        Collections.sort(list);
        return Joiner.on((String)", ").join(list);
    }

    public static String birthdayMessage() {
        Calendar today = Calendar.getInstance();
        int month = today.get(2);
        int date = today.get(5);
        if (month == 6 && date == 2) {
            return Constants.getString("jm.common.birthday", "techbrew");
        }
        if (month == 8 && date == 21) {
            return Constants.getString("jm.common.birthday", "mysticdrew");
        }
        return null;
    }

    static {
        ICON_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"icon", new Object[0]);
        ENTITY_ICON_DIR = path.join((Object)ICON_DIR, (Object)"entity", new Object[]{END});
        WAYPOINT_ICON_DIR = path.join((Object)ICON_DIR, (Object)"waypoint", new Object[]{END});
        THEME_ICON_DIR = path.join((Object)ICON_DIR, (Object)"theme", new Object[]{END});
    }

    public static enum WorldType {
        mp,
        sp;

    }
}

