/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.town.tracker;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import joshie.harvest.core.HFTrackers;
import joshie.harvest.core.network.PacketHandler;
import joshie.harvest.town.BuildingLocations;
import joshie.harvest.town.data.TownData;
import joshie.harvest.town.data.TownDataServer;
import joshie.harvest.town.packet.PacketNewTown;
import joshie.harvest.town.packet.PacketSyncTowns;
import joshie.harvest.town.tracker.TownTracker;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;

public class TownTrackerServer
extends TownTracker<TownDataServer> {
    private BiMap<UUID, Integer> townIDs = HashBiMap.create();

    public void newDay() {
        Cache isFar = CacheBuilder.newBuilder().build();
        for (TownDataServer town : this.townData) {
            town.newDay(this.getWorld(), (Cache<BlockPos, Boolean>)isFar);
        }
    }

    public void syncToPlayer(EntityPlayerMP player) {
        PacketHandler.sendToClient(new PacketSyncTowns(this.townData), (EntityPlayer)player);
        for (TownDataServer town : this.townData) {
            town.getQuests().sync(player);
        }
    }

    @Override
    public BlockPos getCoordinatesForOverworldMine(Entity entity, int mineID) {
        BlockPos default_ = super.getCoordinatesForOverworldMine(entity, mineID);
        UUID uuid = (UUID)this.townIDs.inverse().get((Object)mineID);
        if (uuid == null) {
            return default_;
        }
        TownData data = (TownData)this.uuidMap.get(uuid);
        if (data == null) {
            return default_;
        }
        if (!data.hasBuilding(BuildingLocations.MINEENTRANCE.getResource())) {
            return data.getTownCentre();
        }
        BlockPos location = data.getCoordinatesFor(BuildingLocations.MINEENTRANCE);
        return location != null ? location : data.getTownCentre();
    }

    @Override
    public Rotation getMineOrientation(int mineID) {
        UUID uuid = (UUID)this.townIDs.inverse().get((Object)mineID);
        if (uuid == null) {
            return Rotation.NONE;
        }
        TownDataServer data = (TownDataServer)this.uuidMap.get(uuid);
        if (data == null || !data.hasBuilding(BuildingLocations.MINEENTRANCE.getResource())) {
            return Rotation.NONE;
        }
        return data.getFacingFor(BuildingLocations.MINEENTRANCE.getResource());
    }

    @Override
    public int getMineIDFromCoordinates(BlockPos pos) {
        Object data = this.getClosestTownToBlockPos(pos);
        if (!((TownData)data).hasBuilding(BuildingLocations.MINEENTRANCE.getResource())) {
            return -1;
        }
        if (this.townIDs.containsKey((Object)((TownData)data).getID())) {
            return (Integer)this.townIDs.get((Object)((TownData)data).getID());
        }
        return this.matchUUIDWithMineID(((TownData)data).getID());
    }

    private int matchUUIDWithMineID(UUID uuid) {
        for (int i = 0; i < 32000; ++i) {
            if (this.townIDs.inverse().containsKey((Object)i)) continue;
            this.townIDs.put((Object)uuid, (Object)i);
            HFTrackers.markDirty(this.getDimension());
            return i;
        }
        return 0;
    }

    @Override
    public TownDataServer createNewTown(BlockPos pos) {
        TownDataServer data = new TownDataServer(this.getDimension(), pos);
        this.townData.add(data);
        this.uuidMap.put(data.getID(), data);
        this.matchUUIDWithMineID(data.getID());
        PacketHandler.sendToDimension(this.getDimension(), new PacketNewTown((TownData)data));
        data.getQuests().sync(null);
        HFTrackers.markDirty(this.getDimension());
        return data;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.townData = new HashSet();
        NBTTagList dimensionTowns = nbt.func_150295_c("Towns", 10);
        for (int j = 0; j < dimensionTowns.func_74745_c(); ++j) {
            NBTTagCompound tag = dimensionTowns.func_150305_b(j);
            TownDataServer theData = new TownDataServer();
            theData.readFromNBT(tag);
            if (theData.getTownCentre().func_177956_o() <= 0) continue;
            this.uuidMap.put(theData.getID(), theData);
            this.townData.add(theData);
        }
        this.townIDs = HashBiMap.create();
        NBTTagList ids = nbt.func_150295_c("IDs", 10);
        for (int j = 0; j < ids.func_74745_c(); ++j) {
            NBTTagCompound tag = ids.func_150305_b(j);
            int id = tag.func_74762_e("ID");
            UUID uuid = UUID.fromString(tag.func_74779_i("UUID"));
            this.townIDs.put((Object)uuid, (Object)id);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList town_list = new NBTTagList();
        for (TownData data : this.townData) {
            NBTTagCompound townData = new NBTTagCompound();
            data.writeToNBT(townData);
            town_list.func_74742_a((NBTBase)townData);
        }
        nbt.func_74782_a("Towns", (NBTBase)town_list);
        NBTTagList ids = new NBTTagList();
        for (Map.Entry entry : this.townIDs.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("ID", ((Integer)entry.getValue()).intValue());
            tag.func_74778_a("UUID", ((UUID)entry.getKey()).toString());
            ids.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("IDs", (NBTBase)ids);
        return nbt;
    }
}

