/*
 * Decompiled with CFR 0.152.
 */
package joshie.harvest.town.tracker;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joshie.harvest.core.util.HFTracker;
import joshie.harvest.npc.HFNPCs;
import joshie.harvest.town.data.TownData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.DimensionManager;

public abstract class TownTracker<T extends TownData>
extends HFTracker {
    final HashMap<UUID, T> uuidMap = new HashMap();
    Set<T> townData = new HashSet<T>();

    @Nullable
    private T getClosestTown(BlockPos pos) {
        TownData closest = null;
        double thatTownDistance = Double.MAX_VALUE;
        for (TownData town : this.townData) {
            double thisTownDistance = town.getTownCentre().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            if (closest != null && !(thisTownDistance < thatTownDistance)) continue;
            thatTownDistance = thisTownDistance;
            closest = town;
        }
        return (T)(thatTownDistance > HFNPCs.TOWN_DISTANCE || closest == null ? null : closest);
    }

    @Nonnull
    public T getClosestTownToBlockPos(BlockPos pos) {
        T data = this.getClosestTown(pos);
        if (data == null) {
            data = this.createNewTown(pos);
        }
        return data;
    }

    public abstract T createNewTown(BlockPos var1);

    public T getTownByID(UUID townID) {
        TownData result = (TownData)this.uuidMap.get(townID);
        return (T)(result == null ? null : result);
    }

    public BlockPos getCoordinatesForOverworldMine(Entity entity, int mineID) {
        return entity instanceof EntityPlayer ? ((EntityPlayer)entity).getBedLocation(0) : DimensionManager.getWorld((int)0).func_175694_M();
    }

    public int getMineIDFromCoordinates(BlockPos pos) {
        return -1;
    }

    public Rotation getMineOrientation(int mineID) {
        return Rotation.NONE;
    }
}

